/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpurlconnection;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.PeerServiceAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.javaagent.bootstrap.internal.CommonConfig;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.GetOutputStreamContext;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.HttpMethodAttributeExtractor;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.HttpUrlHttpAttributesGetter;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.RequestPropertySetter;
import java.net.HttpURLConnection;
import java.util.Map;

public final class HttpUrlConnectionSingletons {
    private static final Instrumenter<HttpURLConnection, Integer> INSTRUMENTER;

    public static Instrumenter<HttpURLConnection, Integer> instrumenter() {
        return INSTRUMENTER;
    }

    private HttpUrlConnectionSingletons() {
    }

    static {
        HttpUrlHttpAttributesGetter httpAttributesGetter = new HttpUrlHttpAttributesGetter();
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)"io.opentelemetry.http-url-connection", (SpanNameExtractor)HttpSpanNameExtractor.builder((HttpCommonAttributesGetter)httpAttributesGetter).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()).build()).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpAttributesGetter)).addAttributesExtractor(HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)httpAttributesGetter).setCapturedRequestHeaders(CommonConfig.get().getClientRequestHeaders()).setCapturedResponseHeaders(CommonConfig.get().getClientResponseHeaders()).setKnownMethods(CommonConfig.get().getKnownHttpRequestMethods()).build()).addAttributesExtractor(PeerServiceAttributesExtractor.create((ServerAttributesGetter)httpAttributesGetter, (Map)CommonConfig.get().getPeerServiceMapping())).addAttributesExtractor(HttpMethodAttributeExtractor.create(CommonConfig.get().getKnownHttpRequestMethods())).addContextCustomizer((context, httpRequestPacket, startAttributes) -> GetOutputStreamContext.init(context)).addOperationMetrics(HttpClientMetrics.get());
        if (CommonConfig.get().shouldEmitExperimentalHttpClientMetrics()) {
            builder.addOperationMetrics(HttpClientExperimentalMetrics.get());
        }
        INSTRUMENTER = builder.buildClientInstrumenter((TextMapSetter)RequestPropertySetter.INSTANCE);
    }
}

