/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpurlconnection;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.CallDepth;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.GetOutputStreamContext;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.HttpUrlConnectionSingletons;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.HttpUrlState;
import java.net.HttpURLConnection;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class HttpUrlConnectionInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.nameStartsWith((String)"java.net.").or((ElementMatcher)ElementMatchers.nameStartsWith((String)"sun.net")).or((ElementMatcher)ElementMatchers.named((String)"weblogic.net.http.HttpURLConnection")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"sun.net.www.protocol.https.HttpsURLConnectionImpl"))).and((ElementMatcher)AgentElementMatchers.extendsClass((ElementMatcher)ElementMatchers.named((String)"java.net.HttpURLConnection")));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.namedOneOf((String[])new String[]{"connect", "getOutputStream", "getInputStream"})), this.getClass().getName() + "$HttpUrlConnectionAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.isMethod().and((ElementMatcher)ElementMatchers.isPublic()).and((ElementMatcher)ElementMatchers.named((String)"getResponseCode")), this.getClass().getName() + "$GetResponseCodeAdvice");
    }

    public static class GetResponseCodeAdvice {
        @Advice.OnMethodExit
        public static void methodExit(@Advice.This HttpURLConnection connection, @Advice.Return int returnValue) {
            VirtualField storage = VirtualField.find(HttpURLConnection.class, HttpUrlState.class);
            HttpUrlState httpUrlState = (HttpUrlState)storage.get((Object)connection);
            if (httpUrlState != null) {
                httpUrlState.statusCode = returnValue;
            }
        }
    }

    public static class HttpUrlConnectionAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void methodEnter(@Advice.This HttpURLConnection connection, @Advice.FieldValue(value="connected") boolean connected, @Advice.Local(value="otelHttpUrlState") HttpUrlState httpUrlState, @Advice.Local(value="otelScope") Scope scope, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            callDepth = CallDepth.forClass(HttpURLConnection.class);
            if (callDepth.getAndIncrement() > 0) {
                return;
            }
            Context parentContext = Java8BytecodeBridge.currentContext();
            if (!HttpUrlConnectionSingletons.instrumenter().shouldStart(parentContext, (Object)connection)) {
                return;
            }
            VirtualField storage = VirtualField.find(HttpURLConnection.class, HttpUrlState.class);
            httpUrlState = (HttpUrlState)storage.get((Object)connection);
            if (httpUrlState != null) {
                if (!httpUrlState.finished) {
                    scope = httpUrlState.context.makeCurrent();
                }
                return;
            }
            Context context = HttpUrlConnectionSingletons.instrumenter().start(parentContext, (Object)connection);
            httpUrlState = new HttpUrlState(context);
            storage.set((Object)connection, (Object)httpUrlState);
            scope = context.makeCurrent();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void methodExit(@Advice.This HttpURLConnection connection, @Advice.FieldValue(value="responseCode") int responseCode, @Advice.Thrown Throwable throwable, @Advice.Origin(value="#m") String methodName, @Advice.Local(value="otelHttpUrlState") HttpUrlState httpUrlState, @Advice.Local(value="otelScope") Scope scope, @Advice.Local(value="otelCallDepth") CallDepth callDepth) {
            if (callDepth.decrementAndGet() > 0) {
                return;
            }
            if (scope == null) {
                return;
            }
            callDepth.getAndIncrement();
            try {
                scope.close();
                Class<?> connectionClass = connection.getClass();
                String requestMethod = connection.getRequestMethod();
                GetOutputStreamContext.set(httpUrlState.context, connectionClass, methodName, requestMethod);
                if (throwable != null) {
                    if (responseCode >= 400) {
                        HttpUrlConnectionSingletons.instrumenter().end(httpUrlState.context, (Object)connection, (Object)responseCode, null);
                    } else {
                        HttpUrlConnectionSingletons.instrumenter().end(httpUrlState.context, (Object)connection, (Object)(responseCode > 0 ? responseCode : httpUrlState.statusCode), throwable);
                    }
                    httpUrlState.finished = true;
                } else if (methodName.equals("getInputStream") && responseCode > 0) {
                    HttpUrlConnectionSingletons.instrumenter().end(httpUrlState.context, (Object)connection, (Object)responseCode, null);
                    httpUrlState.finished = true;
                }
            }
            finally {
                callDepth.decrementAndGet();
            }
        }
    }
}

