/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpurlconnection;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.internal.HttpAttributes;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.instrumentation.httpurlconnection.GetOutputStreamContext;
import io.opentelemetry.semconv.SemanticAttributes;
import java.net.HttpURLConnection;
import java.util.Set;
import javax.annotation.Nullable;

public class HttpMethodAttributeExtractor<REQUEST extends HttpURLConnection, RESPONSE extends Integer>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final Set<String> knownMethods;

    private HttpMethodAttributeExtractor(Set<String> knownMethods) {
        this.knownMethods = knownMethods;
    }

    public static AttributesExtractor<? super HttpURLConnection, ? super Integer> create(Set<String> knownMethods) {
        return new HttpMethodAttributeExtractor(knownMethods);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, HttpURLConnection connection) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, HttpURLConnection connection, @Nullable Integer responseCode, @Nullable Throwable error) {
        GetOutputStreamContext getOutputStreamContext = GetOutputStreamContext.get(context);
        if (getOutputStreamContext.isOutputStreamMethodOfSunConnectionCalled()) {
            String method = connection.getRequestMethod();
            if (SemconvStability.emitStableHttpSemconv()) {
                if (this.knownMethods.contains(method)) {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpAttributes.HTTP_REQUEST_METHOD, (Object)method);
                    attributes.remove(HttpAttributes.HTTP_REQUEST_METHOD_ORIGINAL);
                } else {
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpAttributes.HTTP_REQUEST_METHOD, (Object)"_OTHER");
                    AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)HttpAttributes.HTTP_REQUEST_METHOD_ORIGINAL, (Object)method);
                }
            }
            if (SemconvStability.emitOldHttpSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)SemanticAttributes.HTTP_METHOD, (Object)method);
            }
            Span span = Span.fromContext((Context)context);
            span.updateName(method);
        }
    }
}

