/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.httpurlconnection;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.net.HttpURLConnection;

public class GetOutputStreamContext
implements ImplicitContextKeyed {
    private static final ContextKey<GetOutputStreamContext> KEY = ContextKey.named((String)"opentelemetry-http-url-connection-get-output-stream");
    private volatile boolean outputStreamMethodOfSunConnectionCalled;

    private GetOutputStreamContext() {
    }

    public Context storeInContext(Context context) {
        return context.with(KEY, (Object)this);
    }

    public static Context init(Context context) {
        if (context.get(KEY) != null) {
            return context;
        }
        return context.with((ImplicitContextKeyed)new GetOutputStreamContext());
    }

    public static GetOutputStreamContext get(Context context) {
        return (GetOutputStreamContext)context.get(KEY);
    }

    public static void set(Context context, Class<? extends HttpURLConnection> connectionClass, String methodName, String requestMethod) {
        GetOutputStreamContext getOutputStreamContext = (GetOutputStreamContext)context.get(KEY);
        String connectionClassName = connectionClass.getName();
        if ("sun.net.www.protocol.http.HttpURLConnection".equals(connectionClassName) && "getOutputStream".equals(methodName) && "POST".equals(requestMethod)) {
            getOutputStreamContext.outputStreamMethodOfSunConnectionCalled = true;
        }
    }

    public boolean isOutputStreamMethodOfSunConnectionCalled() {
        return this.outputStreamMethodOfSunConnectionCalled;
    }
}

