/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.gwt;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.gwt.GwtSingletons;
import java.lang.reflect.Method;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class GwtRpcInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.named((String)"com.google.gwt.user.server.rpc.RPC");
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"invokeAndEncodeResponse").and((ElementMatcher)ElementMatchers.takesArguments((int)5)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, Object.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, Method.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, Object[].class)).and((ElementMatcher)ElementMatchers.takesArgument((int)3, (ElementMatcher)ElementMatchers.named((String)"com.google.gwt.user.server.rpc.SerializationPolicy"))).and((ElementMatcher)ElementMatchers.takesArgument((int)4, Integer.TYPE)), this.getClass().getName() + "$InvokeAndEncodeResponseAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"encodeResponseForFailure").and((ElementMatcher)ElementMatchers.takesArguments((int)4)).and((ElementMatcher)ElementMatchers.takesArgument((int)0, Method.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)1, Throwable.class)).and((ElementMatcher)ElementMatchers.takesArgument((int)2, (ElementMatcher)ElementMatchers.named((String)"com.google.gwt.user.server.rpc.SerializationPolicy"))).and((ElementMatcher)ElementMatchers.takesArgument((int)3, Integer.TYPE)), this.getClass().getName() + "$EncodeResponseForFailureAdvice");
    }

    public static class EncodeResponseForFailureAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=1) Throwable throwable) {
            if (throwable == null) {
                return;
            }
            Context context = Java8BytecodeBridge.currentContext();
            if (context.get(GwtSingletons.RPC_CONTEXT_KEY) == null) {
                return;
            }
            Java8BytecodeBridge.spanFromContext((Context)context).recordException(throwable);
        }
    }

    public static class InvokeAndEncodeResponseAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=1) Method method, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope) {
            context = GwtSingletons.instrumenter().start(Java8BytecodeBridge.currentContext(), (Object)method).with(GwtSingletons.RPC_CONTEXT_KEY, (Object)true);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Argument(value=1) Method method, @Advice.Local(value="otelContext") Context context, @Advice.Local(value="otelScope") Scope scope, @Advice.Thrown Throwable throwable) {
            scope.close();
            GwtSingletons.instrumenter().end(context, (Object)method, null, throwable);
        }
    }
}

