/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.bootstrap.Java8BytecodeBridge;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.AsyncHttpClientSingletons;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.RequestContext;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Request;

public class AsyncHttpClientInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<TypeDescription> typeMatcher() {
        return AgentElementMatchers.implementsInterface((ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.AsyncHttpClient"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"executeRequest").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.Request"))).and((ElementMatcher)ElementMatchers.takesArgument((int)1, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.AsyncHandler"))).and((ElementMatcher)ElementMatchers.isPublic()), this.getClass().getName() + "$ExecuteRequestAdvice");
    }

    public static class ExecuteRequestAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static void onEnter(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) AsyncHandler<?> handler, @Advice.Local(value="otelScope") Scope scope) {
            Context parentContext = Java8BytecodeBridge.currentContext();
            RequestContext requestContext = new RequestContext(parentContext, request);
            if (!AsyncHttpClientSingletons.instrumenter().shouldStart(parentContext, (Object)requestContext)) {
                return;
            }
            Context context = AsyncHttpClientSingletons.instrumenter().start(parentContext, (Object)requestContext);
            requestContext.setContext(context);
            VirtualField.find(AsyncHandler.class, RequestContext.class).set(handler, (Object)requestContext);
            scope = context.makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Local(value="otelScope") Scope scope) {
            if (scope != null) {
                scope.close();
            }
        }
    }
}

