/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.RequestContext;
import io.opentelemetry.semconv.SemanticAttributes;
import javax.annotation.Nullable;
import org.asynchttpclient.Response;
import org.asynchttpclient.netty.request.NettyRequest;

public class AsyncHttpClientAdditionalAttributesExtractor
implements AttributesExtractor<RequestContext, Response> {
    public void onStart(AttributesBuilder attributes, Context parentContext, RequestContext requestContext) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, RequestContext requestContext, @Nullable Response response, @Nullable Throwable error) {
        String userAgent;
        NettyRequest nettyRequest = requestContext.getNettyRequest();
        if (nettyRequest != null && (userAgent = nettyRequest.getHttpRequest().headers().get("User-Agent")) != null) {
            attributes.put(SemanticAttributes.USER_AGENT_ORIGINAL, (Object)userAgent);
        }
    }
}

