/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0;

import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.util.VirtualField;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.extension.matcher.AgentElementMatchers;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.AsyncHttpClientSingletons;
import io.opentelemetry.javaagent.instrumentation.asynchttpclient.v2_0.RequestContext;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.Response;

public class AsyncCompletionHandlerInstrumentation
implements TypeInstrumentation {
    public ElementMatcher<ClassLoader> classLoaderOptimization() {
        return AgentElementMatchers.hasClassesNamed((String[])new String[]{"org.asynchttpclient.AsyncCompletionHandler"});
    }

    public ElementMatcher<TypeDescription> typeMatcher() {
        return ElementMatchers.hasSuperClass((ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.AsyncCompletionHandler"));
    }

    public void transform(TypeTransformer transformer) {
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"onCompleted").and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"org.asynchttpclient.Response"))).and((ElementMatcher)ElementMatchers.isPublic()), this.getClass().getName() + "$OnCompletedAdvice");
        transformer.applyAdviceToMethod((ElementMatcher)ElementMatchers.named((String)"onThrowable").and((ElementMatcher)ElementMatchers.takesArgument((int)0, Throwable.class)).and((ElementMatcher)ElementMatchers.isPublic()), this.getClass().getName() + "$OnThrowableAdvice");
    }

    public static class OnThrowableAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope onEnter(@Advice.This AsyncCompletionHandler<?> handler, @Advice.Argument(value=0) Throwable throwable) {
            VirtualField virtualField = VirtualField.find(AsyncHandler.class, RequestContext.class);
            RequestContext requestContext = (RequestContext)virtualField.get(handler);
            if (requestContext == null) {
                return null;
            }
            virtualField.set(handler, null);
            AsyncHttpClientSingletons.instrumenter().end(requestContext.getContext(), (Object)requestContext, null, throwable);
            return requestContext.getParentContext().makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Enter Scope scope) {
            if (null != scope) {
                scope.close();
            }
        }
    }

    public static class OnCompletedAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class)
        public static Scope onEnter(@Advice.This AsyncCompletionHandler<?> handler, @Advice.Argument(value=0) Response response) {
            VirtualField virtualField = VirtualField.find(AsyncHandler.class, RequestContext.class);
            RequestContext requestContext = (RequestContext)virtualField.get(handler);
            if (requestContext == null) {
                return null;
            }
            virtualField.set(handler, null);
            AsyncHttpClientSingletons.instrumenter().end(requestContext.getContext(), (Object)requestContext, (Object)response, null);
            return requestContext.getParentContext().makeCurrent();
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
        public static void onExit(@Advice.Enter Scope scope) {
            if (null != scope) {
                scope.close();
            }
        }
    }
}

