/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webmvc.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerExperimentalMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.JavaxHttpServletRequestGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webmvc.v5_3.SpringWebMvcTelemetry;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SpringWebMvcTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webmvc-5.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<HttpServletRequest, HttpServletResponse>> additionalExtractors = new ArrayList<AttributesExtractor<HttpServletRequest, HttpServletResponse>>();
    private final HttpServerAttributesExtractorBuilder<HttpServletRequest, HttpServletResponse> httpAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);
    private final HttpSpanNameExtractorBuilder<HttpServletRequest> httpSpanNameExtractorBuilder = HttpSpanNameExtractor.builder((HttpCommonAttributesGetter)SpringWebMvcHttpAttributesGetter.INSTANCE);
    @Nullable
    private Function<SpanNameExtractor<HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractorTransformer;
    private boolean emitExperimentalHttpServerMetrics = false;

    SpringWebMvcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder addAttributesExtractor(AttributesExtractor<HttpServletRequest, HttpServletResponse> attributesExtractor) {
        this.additionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedRequestHeaders(List<String> requestHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setCapturedResponseHeaders(List<String> responseHeaders) {
        this.httpAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setSpanNameExtractor(Function<SpanNameExtractor<HttpServletRequest>, ? extends SpanNameExtractor<? super HttpServletRequest>> spanNameExtractor) {
        this.spanNameExtractorTransformer = spanNameExtractor;
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setKnownMethods(Set<String> knownMethods) {
        this.httpAttributesExtractorBuilder.setKnownMethods(knownMethods);
        this.httpSpanNameExtractorBuilder.setKnownMethods(knownMethods);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebMvcTelemetryBuilder setEmitExperimentalHttpServerMetrics(boolean emitExperimentalHttpServerMetrics) {
        this.emitExperimentalHttpServerMetrics = emitExperimentalHttpServerMetrics;
        return this;
    }

    public SpringWebMvcTelemetry build() {
        SpanNameExtractor<? super HttpServletRequest> originalSpanNameExtractor;
        SpringWebMvcHttpAttributesGetter httpAttributesGetter = SpringWebMvcHttpAttributesGetter.INSTANCE;
        SpanNameExtractor<? super HttpServletRequest> spanNameExtractor = originalSpanNameExtractor = this.httpSpanNameExtractorBuilder.build();
        if (this.spanNameExtractorTransformer != null) {
            spanNameExtractor = this.spanNameExtractorTransformer.apply((SpanNameExtractor<HttpServletRequest>)originalSpanNameExtractor);
        }
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)httpAttributesGetter)).addAttributesExtractor(this.httpAttributesExtractorBuilder.build()).addAttributesExtractors(this.additionalExtractors).addContextCustomizer(HttpServerRoute.create((HttpServerAttributesGetter)httpAttributesGetter)).addOperationMetrics(HttpServerMetrics.get());
        if (this.emitExperimentalHttpServerMetrics) {
            builder.addOperationMetrics(HttpServerExperimentalMetrics.get());
        }
        return new SpringWebMvcTelemetry((Instrumenter<HttpServletRequest, HttpServletResponse>)builder.buildServerInstrumenter((TextMapGetter)JavaxHttpServletRequestGetter.INSTANCE));
    }
}

