/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3.internal;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpClientMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientExperimentalAttributesExtractor;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.WebClientNetAttributesGetter;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;

public final class SpringWebfluxTelemetryClientBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<ClientRequest, ClientResponse>> clientAdditionalExtractors = new ArrayList<AttributesExtractor<ClientRequest, ClientResponse>>();
    private final HttpClientAttributesExtractorBuilder<ClientRequest, ClientResponse> httpClientAttributesExtractorBuilder = HttpClientAttributesExtractor.builder((HttpClientAttributesGetter)WebClientHttpAttributesGetter.INSTANCE, (NetClientAttributesGetter)new WebClientNetAttributesGetter());
    private boolean captureExperimentalSpanAttributes = false;

    public SpringWebfluxTelemetryClientBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryClientBuilder addClientAttributesExtractor(AttributesExtractor<ClientRequest, ClientResponse> attributesExtractor) {
        this.clientAdditionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryClientBuilder setCapturedClientRequestHeaders(List<String> requestHeaders) {
        this.httpClientAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryClientBuilder setCapturedClientResponseHeaders(List<String> responseHeaders) {
        this.httpClientAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryClientBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    public Instrumenter<ClientRequest, ClientResponse> build() {
        WebClientHttpAttributesGetter httpClientAttributesGetter = WebClientHttpAttributesGetter.INSTANCE;
        InstrumenterBuilder clientBuilder = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)HttpSpanNameExtractor.create((HttpCommonAttributesGetter)httpClientAttributesGetter)).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpClientAttributesGetter)httpClientAttributesGetter)).addAttributesExtractor(this.httpClientAttributesExtractorBuilder.build()).addAttributesExtractors(this.clientAdditionalExtractors).addOperationMetrics(HttpClientMetrics.get());
        if (this.captureExperimentalSpanAttributes) {
            clientBuilder.addAttributesExtractor((AttributesExtractor)new WebClientExperimentalAttributesExtractor());
        }
        return clientBuilder.buildInstrumenter(SpanKindExtractor.alwaysClient());
    }
}

