/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;

enum WebfluxServerHttpAttributesGetter implements HttpServerAttributesGetter<ServerWebExchange, ServerWebExchange>
{
    INSTANCE;


    public String getHttpRequestMethod(ServerWebExchange request) {
        return request.getRequest().getMethodValue();
    }

    public List<String> getHttpRequestHeader(ServerWebExchange request, String name) {
        return (List)request.getRequest().getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public Integer getHttpResponseStatusCode(ServerWebExchange request, ServerWebExchange response, @Nullable Throwable error) {
        return response.getResponse().getRawStatusCode();
    }

    public List<String> getHttpResponseHeader(ServerWebExchange request, ServerWebExchange response, String name) {
        return (List)response.getResponse().getHeaders().getOrDefault((Object)name, Collections.emptyList());
    }

    @Nullable
    public String getUrlScheme(ServerWebExchange request) {
        return request.getRequest().getURI().getScheme();
    }

    @Nullable
    public String getUrlPath(ServerWebExchange request) {
        return request.getRequest().getURI().getPath();
    }

    @Nullable
    public String getUrlQuery(ServerWebExchange request) {
        return request.getRequest().getURI().getQuery();
    }

    @Nullable
    public String getHttpRoute(ServerWebExchange request) {
        Object bestPatternObj = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (bestPatternObj == null) {
            return null;
        }
        String route = bestPatternObj instanceof PathPattern ? ((PathPattern)bestPatternObj).getPatternString() : bestPatternObj.toString();
        if (route.equals("/**")) {
            return null;
        }
        String contextPath = request.getRequest().getPath().contextPath().value();
        return contextPath + (route.startsWith("/") ? route : "/" + route);
    }
}

