/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.spring.webflux.v5_3;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpCommonAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpRouteHolder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesExtractorBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.http.HttpSpanStatusExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.SpringWebfluxTelemetry;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxServerHttpAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxServerNetAttributesGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.WebfluxTextMapGetter;
import io.opentelemetry.instrumentation.spring.webflux.v5_3.internal.SpringWebfluxTelemetryClientBuilder;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;

public final class SpringWebfluxTelemetryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.spring-webflux-5.3";
    private final OpenTelemetry openTelemetry;
    private final SpringWebfluxTelemetryClientBuilder clientBuilder;
    private final List<AttributesExtractor<ServerWebExchange, ServerWebExchange>> serverAdditionalExtractors = new ArrayList<AttributesExtractor<ServerWebExchange, ServerWebExchange>>();
    private final HttpServerAttributesExtractorBuilder<ServerWebExchange, ServerWebExchange> httpServerAttributesExtractorBuilder = HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)WebfluxServerHttpAttributesGetter.INSTANCE, (NetServerAttributesGetter)new WebfluxServerNetAttributesGetter());

    SpringWebfluxTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.clientBuilder = new SpringWebfluxTelemetryClientBuilder(openTelemetry);
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder addClientAttributesExtractor(AttributesExtractor<ClientRequest, ClientResponse> attributesExtractor) {
        this.clientBuilder.addClientAttributesExtractor(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedClientRequestHeaders(List<String> requestHeaders) {
        this.clientBuilder.setCapturedClientRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedClientResponseHeaders(List<String> responseHeaders) {
        this.clientBuilder.setCapturedClientResponseHeaders(responseHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.clientBuilder.setCaptureExperimentalSpanAttributes(captureExperimentalSpanAttributes);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder addServerAttributesExtractor(AttributesExtractor<ServerWebExchange, ServerWebExchange> attributesExtractor) {
        this.serverAdditionalExtractors.add(attributesExtractor);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedServerRequestHeaders(List<String> requestHeaders) {
        this.httpServerAttributesExtractorBuilder.setCapturedRequestHeaders(requestHeaders);
        return this;
    }

    @CanIgnoreReturnValue
    public SpringWebfluxTelemetryBuilder setCapturedServerResponseHeaders(List<String> responseHeaders) {
        this.httpServerAttributesExtractorBuilder.setCapturedResponseHeaders(responseHeaders);
        return this;
    }

    public SpringWebfluxTelemetry build() {
        Instrumenter<ClientRequest, ClientResponse> clientInstrumenter = this.clientBuilder.build();
        WebfluxServerHttpAttributesGetter serverAttributesGetter = WebfluxServerHttpAttributesGetter.INSTANCE;
        SpanNameExtractor serverSpanNameExtractor = HttpSpanNameExtractor.create((HttpCommonAttributesGetter)serverAttributesGetter);
        Instrumenter serverInstrumenter = Instrumenter.builder((OpenTelemetry)this.openTelemetry, (String)INSTRUMENTATION_NAME, (SpanNameExtractor)serverSpanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)serverAttributesGetter)).addAttributesExtractor(this.httpServerAttributesExtractorBuilder.build()).addAttributesExtractors(this.serverAdditionalExtractors).addContextCustomizer(HttpRouteHolder.create((HttpServerAttributesGetter)serverAttributesGetter)).addOperationMetrics(HttpServerMetrics.get()).buildServerInstrumenter((TextMapGetter)WebfluxTextMapGetter.INSTANCE);
        return new SpringWebfluxTelemetry(clientInstrumenter, (Instrumenter<ServerWebExchange, ServerWebExchange>)serverInstrumenter, this.openTelemetry.getPropagators());
    }
}

