/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.v2_6;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.instrumentation.kafka.internal.KafkaInstrumenterFactory;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProcessRequest;
import io.opentelemetry.instrumentation.kafka.internal.KafkaProducerRequest;
import io.opentelemetry.instrumentation.kafkaclients.v2_6.KafkaTelemetry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.clients.producer.RecordMetadata;

public final class KafkaTelemetryBuilder {
    static final String INSTRUMENTATION_NAME = "io.opentelemetry.kafka-clients-2.6";
    private final OpenTelemetry openTelemetry;
    private final List<AttributesExtractor<KafkaProducerRequest, RecordMetadata>> producerAttributesExtractors = new ArrayList<AttributesExtractor<KafkaProducerRequest, RecordMetadata>>();
    private final List<AttributesExtractor<KafkaProcessRequest, Void>> consumerAttributesExtractors = new ArrayList<AttributesExtractor<KafkaProcessRequest, Void>>();
    private List<String> capturedHeaders = Collections.emptyList();
    private boolean captureExperimentalSpanAttributes = false;
    private boolean propagationEnabled = true;

    KafkaTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = Objects.requireNonNull(openTelemetry);
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addProducerAttributesExtractors(AttributesExtractor<KafkaProducerRequest, RecordMetadata> extractor) {
        this.producerAttributesExtractors.add(extractor);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder addConsumerAttributesExtractors(AttributesExtractor<KafkaProcessRequest, Void> extractor) {
        this.consumerAttributesExtractors.add(extractor);
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setCapturedHeaders(List<String> capturedHeaders) {
        this.capturedHeaders = capturedHeaders;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setCaptureExperimentalSpanAttributes(boolean captureExperimentalSpanAttributes) {
        this.captureExperimentalSpanAttributes = captureExperimentalSpanAttributes;
        return this;
    }

    @CanIgnoreReturnValue
    public KafkaTelemetryBuilder setPropagationEnabled(boolean propagationEnabled) {
        this.propagationEnabled = propagationEnabled;
        return this;
    }

    public KafkaTelemetry build() {
        KafkaInstrumenterFactory instrumenterFactory = new KafkaInstrumenterFactory(this.openTelemetry, INSTRUMENTATION_NAME).setCapturedHeaders(this.capturedHeaders).setCaptureExperimentalSpanAttributes(this.captureExperimentalSpanAttributes);
        return new KafkaTelemetry(this.openTelemetry, (Instrumenter<KafkaProducerRequest, RecordMetadata>)instrumenterFactory.createProducerInstrumenter(this.producerAttributesExtractors), (Instrumenter<KafkaProcessRequest, Void>)instrumenterFactory.createConsumerOperationInstrumenter(MessageOperation.RECEIVE, this.consumerAttributesExtractors), this.propagationEnabled);
    }
}

