/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.AutoValue_RpcClientMetrics_State;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcMetricsAdvice;
import io.opentelemetry.instrumentation.api.incubator.semconv.rpc.RpcSizeAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.instrumentation.api.internal.OperationMetricsUtil;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RpcClientMetrics
implements OperationListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> RPC_CLIENT_REQUEST_METRICS_STATE = ContextKey.named((String)"rpc-client-request-metrics-state");
    private static final Logger logger = Logger.getLogger(RpcClientMetrics.class.getName());
    private final DoubleHistogram clientDurationHistogram;
    private final LongHistogram clientRequestSize;
    private final LongHistogram clientResponseSize;

    private RpcClientMetrics(Meter meter) {
        DoubleHistogramBuilder durationBuilder = meter.histogramBuilder("rpc.client.duration").setDescription("The duration of an outbound RPC invocation.").setUnit("ms");
        RpcMetricsAdvice.applyClientDurationAdvice(durationBuilder);
        this.clientDurationHistogram = durationBuilder.build();
        LongHistogramBuilder requestSizeBuilder = meter.histogramBuilder("rpc.client.request.size").setUnit("By").setDescription("Measures the size of RPC request messages (uncompressed).").ofLongs();
        RpcMetricsAdvice.applyClientRequestSizeAdvice(requestSizeBuilder);
        this.clientRequestSize = requestSizeBuilder.build();
        LongHistogramBuilder responseSizeBuilder = meter.histogramBuilder("rpc.client.response.size").setUnit("By").setDescription("Measures the size of RPC response messages (uncompressed).").ofLongs();
        RpcMetricsAdvice.applyClientRequestSizeAdvice(responseSizeBuilder);
        this.clientResponseSize = responseSizeBuilder.build();
    }

    public static OperationMetrics get() {
        return OperationMetricsUtil.create((String)"rpc client", RpcClientMetrics::new);
    }

    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(RPC_CLIENT_REQUEST_METRICS_STATE, (Object)new AutoValue_RpcClientMetrics_State(startAttributes, startNanos));
    }

    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long rpcClientResponseBodySize;
        State state = (State)context.get(RPC_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC request metrics.", context);
            return;
        }
        Attributes attributes = state.startAttributes().toBuilder().putAll(endAttributes).build();
        this.clientDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / NANOS_PER_MS, attributes, context);
        Long rpcClientRequestBodySize = (Long)attributes.get(RpcSizeAttributesExtractor.RPC_REQUEST_SIZE);
        if (rpcClientRequestBodySize != null) {
            this.clientRequestSize.record(rpcClientRequestBodySize.longValue(), attributes, context);
        }
        if ((rpcClientResponseBodySize = (Long)attributes.get(RpcSizeAttributesExtractor.RPC_RESPONSE_SIZE)) != null) {
            this.clientResponseSize.record(rpcClientResponseBodySize.longValue(), attributes, context);
        }
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

