/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db.internal;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.Context;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Nullable;

public final class SqlCommenterUtil {
    public static String processQuery(String query) {
        if (!Span.current().getSpanContext().isValid()) {
            return query;
        }
        if (SqlCommenterUtil.containsSqlComment(query)) {
            return query;
        }
        class State {
            @Nullable
            String traceparent;
            @Nullable
            String tracestate;

            State() {
            }
        }
        State state = new State();
        W3CTraceContextPropagator.getInstance().inject(Context.current(), (Object)state, (carrier, key, value) -> {
            if (carrier == null) {
                return;
            }
            if ("traceparent".equals(key)) {
                carrier.traceparent = value;
            } else if ("tracestate".equals(key)) {
                carrier.tracestate = value;
            }
        });
        try {
            query = query + " /*traceparent='" + state.traceparent + "'";
            if (state.tracestate != null) {
                query = query + ", tracestate=" + SqlCommenterUtil.serialize(state.tracestate);
            }
            query = query + "*/";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return query;
    }

    private static boolean containsSqlComment(String query) {
        return query.contains("--") || query.contains("/*");
    }

    private static String serialize(String value) throws UnsupportedEncodingException {
        String result = URLEncoder.encode(value, "UTF-8").replace("+", "%20");
        return "'" + result + "'";
    }

    private SqlCommenterUtil() {
    }
}

