/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.graphql.v12_0;

import graphql.ExecutionResult;
import graphql.GraphQLError;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.SimpleInstrumentation;
import graphql.execution.instrumentation.SimpleInstrumentationContext;
import graphql.execution.instrumentation.parameters.InstrumentationExecuteOperationParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import graphql.language.AstPrinter;
import graphql.language.AstTransformer;
import graphql.language.BooleanValue;
import graphql.language.EnumValue;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.language.NodeVisitorStub;
import graphql.language.NullValue;
import graphql.language.OperationDefinition;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.DataFetcher;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import graphql.util.TreeTransformerUtil;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.graphql.v12_0.OpenTelemetryInstrumentationState;
import io.opentelemetry.semconv.SemanticAttributes;
import java.util.Locale;

final class OpenTelemetryInstrumentation
extends SimpleInstrumentation {
    private static final NodeVisitor sanitizingVisitor = new SanitizingVisitor();
    private static final AstTransformer astTransformer = new AstTransformer();
    private final Instrumenter<InstrumentationExecutionParameters, ExecutionResult> instrumenter;
    private final boolean sanitizeQuery;

    OpenTelemetryInstrumentation(Instrumenter<InstrumentationExecutionParameters, ExecutionResult> instrumenter, boolean sanitizeQuery) {
        this.instrumenter = instrumenter;
        this.sanitizeQuery = sanitizeQuery;
    }

    public InstrumentationState createState() {
        return new OpenTelemetryInstrumentationState();
    }

    public InstrumentationContext<ExecutionResult> beginExecution(InstrumentationExecutionParameters parameters) {
        Context parentContext = Context.current();
        if (!this.instrumenter.shouldStart(parentContext, (Object)parameters)) {
            return SimpleInstrumentationContext.noOp();
        }
        Context context = this.instrumenter.start(parentContext, (Object)parameters);
        OpenTelemetryInstrumentationState state = (OpenTelemetryInstrumentationState)parameters.getInstrumentationState();
        state.setContext(context);
        return SimpleInstrumentationContext.whenCompleted((result, throwable) -> {
            Span span = Span.fromContext((Context)context);
            for (GraphQLError error : result.getErrors()) {
                AttributesBuilder attributes = Attributes.builder();
                attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)String.valueOf(error.getErrorType()));
                attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)error.getMessage());
                span.addEvent("exception", attributes.build());
            }
            this.instrumenter.end(context, (Object)parameters, result, throwable);
        });
    }

    public InstrumentationContext<ExecutionResult> beginExecuteOperation(InstrumentationExecuteOperationParameters parameters) {
        OpenTelemetryInstrumentationState state = (OpenTelemetryInstrumentationState)parameters.getInstrumentationState();
        Span span = Span.fromContext((Context)state.getContext());
        Node<?> operationDefinition = parameters.getExecutionContext().getOperationDefinition();
        OperationDefinition.Operation operation = operationDefinition.getOperation();
        String operationType = operation.name().toLowerCase(Locale.ROOT);
        String operationName = operationDefinition.getName();
        String spanName = operationType;
        if (operationName != null && !operationName.isEmpty()) {
            spanName = spanName + " " + operationName;
        }
        span.updateName(spanName);
        state.setOperation(operation);
        state.setOperationName(operationName);
        Node<?> node = operationDefinition;
        if (this.sanitizeQuery) {
            node = OpenTelemetryInstrumentation.sanitize(node);
        }
        state.setQuery(AstPrinter.printAst(node));
        return SimpleInstrumentationContext.noOp();
    }

    public DataFetcher<?> instrumentDataFetcher(DataFetcher<?> dataFetcher, InstrumentationFieldFetchParameters parameters) {
        OpenTelemetryInstrumentationState state = (OpenTelemetryInstrumentationState)parameters.getInstrumentationState();
        Context context = state.getContext();
        return environment -> {
            try (Scope scope = context.makeCurrent();){
                Object object = dataFetcher.get(environment);
                return object;
            }
        };
    }

    private static Node<?> sanitize(Node<?> node) {
        return astTransformer.transform(node, sanitizingVisitor);
    }

    private static class SanitizingVisitor
    extends NodeVisitorStub {
        private SanitizingVisitor() {
        }

        protected TraversalControl visitValue(Value<?> node, TraverserContext<Node> context) {
            EnumValue newValue = new EnumValue("?");
            return TreeTransformerUtil.changeNode(context, (Object)newValue);
        }

        private TraversalControl visitSafeValue(Value<?> node, TraverserContext<Node> context) {
            return super.visitValue(node, context);
        }

        public TraversalControl visitVariableReference(VariableReference node, TraverserContext<Node> context) {
            return this.visitSafeValue((Value<?>)node, context);
        }

        public TraversalControl visitBooleanValue(BooleanValue node, TraverserContext<Node> context) {
            return this.visitSafeValue((Value<?>)node, context);
        }

        public TraversalControl visitNullValue(NullValue node, TraverserContext<Node> context) {
            return this.visitSafeValue((Value<?>)node, context);
        }
    }
}

