/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.graphql.v12_0;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.graphql.v12_0.OpenTelemetryInstrumentationState;
import java.util.Locale;
import javax.annotation.Nullable;

final class GraphqlAttributesExtractor
implements AttributesExtractor<InstrumentationExecutionParameters, ExecutionResult> {
    private static final AttributeKey<String> OPERATION_NAME = AttributeKey.stringKey((String)"graphql.operation.name");
    private static final AttributeKey<String> OPERATION_TYPE = AttributeKey.stringKey((String)"graphql.operation.type");
    private static final AttributeKey<String> GRAPHQL_DOCUMENT = AttributeKey.stringKey((String)"graphql.document");

    GraphqlAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, InstrumentationExecutionParameters request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, InstrumentationExecutionParameters request, @Nullable ExecutionResult response, @Nullable Throwable error) {
        OpenTelemetryInstrumentationState state = (OpenTelemetryInstrumentationState)request.getInstrumentationState();
        attributes.put(OPERATION_NAME, (Object)state.getOperationName());
        if (state.getOperation() != null) {
            attributes.put(OPERATION_TYPE, (Object)state.getOperation().name().toLowerCase(Locale.ROOT));
        }
        attributes.put(GRAPHQL_DOCUMENT, (Object)state.getQuery());
    }
}

