/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.graphql.v12_0;

import graphql.ExecutionResult;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import io.opentelemetry.instrumentation.graphql.v12_0.GraphQLTelemetryBuilder;
import io.opentelemetry.instrumentation.graphql.v12_0.GraphqlAttributesExtractor;
import io.opentelemetry.instrumentation.graphql.v12_0.OpenTelemetryInstrumentation;

public final class GraphQLTelemetry {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.graphql-java-12.0";
    private final Instrumenter<InstrumentationExecutionParameters, ExecutionResult> instrumenter;
    private final boolean sanitizeQuery;

    public static GraphQLTelemetry create(OpenTelemetry openTelemetry) {
        return GraphQLTelemetry.builder(openTelemetry).build();
    }

    public static GraphQLTelemetryBuilder builder(OpenTelemetry openTelemetry) {
        return new GraphQLTelemetryBuilder(openTelemetry);
    }

    GraphQLTelemetry(OpenTelemetry openTelemetry, boolean sanitizeQuery) {
        InstrumenterBuilder builder = Instrumenter.builder((OpenTelemetry)openTelemetry, (String)INSTRUMENTATION_NAME, ignored -> "GraphQL Operation").setSpanStatusExtractor((spanStatusBuilder, instrumentationExecutionParameters, executionResult, error) -> {
            if (!executionResult.getErrors().isEmpty()) {
                spanStatusBuilder.setStatus(StatusCode.ERROR);
            } else {
                SpanStatusExtractor.getDefault().extract(spanStatusBuilder, instrumentationExecutionParameters, executionResult, error);
            }
        });
        builder.addAttributesExtractor((AttributesExtractor)new GraphqlAttributesExtractor());
        this.instrumenter = builder.buildInstrumenter();
        this.sanitizeQuery = sanitizeQuery;
    }

    public Instrumentation newInstrumentation() {
        return new OpenTelemetryInstrumentation(this.instrumenter, this.sanitizeQuery);
    }
}

