/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.cassandra.v4_4;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Node;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.cassandra.v4_4.CassandraRequest;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

final class CassandraAttributesExtractor
implements AttributesExtractor<CassandraRequest, ExecutionInfo> {
    CassandraAttributesExtractor() {
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, CassandraRequest request) {
    }

    public void onEnd(AttributesBuilder attributes, Context context, CassandraRequest request, @Nullable ExecutionInfo executionInfo, @Nullable Throwable error) {
        if (executionInfo == null) {
            return;
        }
        Node coordinator = executionInfo.getCoordinator();
        if (coordinator != null) {
            if (coordinator.getDatacenter() != null) {
                attributes.put(SemanticAttributes.DB_CASSANDRA_COORDINATOR_DC, (Object)coordinator.getDatacenter());
            }
            if (coordinator.getHostId() != null) {
                attributes.put(SemanticAttributes.DB_CASSANDRA_COORDINATOR_ID, (Object)coordinator.getHostId().toString());
            }
        }
        attributes.put(SemanticAttributes.DB_CASSANDRA_SPECULATIVE_EXECUTION_COUNT, executionInfo.getSpeculativeExecutionCount());
        Statement statement = (Statement)executionInfo.getRequest();
        DriverExecutionProfile config = request.getSession().getContext().getConfig().getDefaultProfile();
        String consistencyLevel = statement.getConsistencyLevel() != null ? statement.getConsistencyLevel().name() : config.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY);
        attributes.put(SemanticAttributes.DB_CASSANDRA_CONSISTENCY_LEVEL, (Object)consistencyLevel);
        if (statement.getPageSize() > 0) {
            attributes.put(SemanticAttributes.DB_CASSANDRA_PAGE_SIZE, statement.getPageSize());
        } else {
            int pageSize = config.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE);
            if (pageSize > 0) {
                attributes.put(SemanticAttributes.DB_CASSANDRA_PAGE_SIZE, pageSize);
            }
        }
        Boolean idempotent = statement.isIdempotent();
        if (idempotent == null) {
            idempotent = config.getBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE);
        }
        attributes.put(SemanticAttributes.DB_CASSANDRA_IDEMPOTENCE, (Object)idempotent);
    }
}

