/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import io.openliberty.tools.common.plugins.util.InstallFeatureUtil;
import io.openliberty.tools.common.plugins.util.OSUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import io.openliberty.tools.common.plugins.util.ServerFeatureUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class PrepareFeatureUtil
extends ServerFeatureUtil {
    private final File installDirectory;
    private String openLibertyVersion;
    public static final String OPEN_LIBERTY_GROUP_ID = "io.openliberty.features";
    public static final String INSTALL_MAP_ARTIFACT_ID = "install-map";
    public static final String FEATURES_JSON_ARTIFACT_ID = "features";
    private static final String MIN_USER_FEATURE_VERSION = "21.0.0.11";
    private File installJarFile;
    private File jsonFile;

    public PrepareFeatureUtil(File installDirectory, String openLibertyVersion) throws PluginScenarioException, PluginExecutionException {
        this.installDirectory = installDirectory;
        this.openLibertyVersion = openLibertyVersion;
        this.installJarFile = this.loadInstallJarFile(installDirectory);
        DefaultArtifactVersion minVersion = new DefaultArtifactVersion(MIN_USER_FEATURE_VERSION);
        DefaultArtifactVersion version = new DefaultArtifactVersion(openLibertyVersion);
        if (version.compareTo((ArtifactVersion)minVersion) < 0) {
            throw new PluginScenarioException("Installing user features on Liberty version " + version + " is not supported. The minimum required version of Liberty for installing user features is " + minVersion + ".");
        }
        if (this.installJarFile == null) {
            throw new PluginScenarioException("Install map jar not found.");
        }
    }

    public void prepareFeatures(List<String> featureBOMs) throws PluginExecutionException {
        HashMap<File, String> esaMap = new HashMap<File, String>();
        for (String BOMCoordinate : featureBOMs) {
            String[] coord = BOMCoordinate.split(":");
            String groupId = coord[0];
            String artifactId = coord[1];
            String version = coord[2];
            File additionalBOM = this.downloadArtifact(groupId, artifactId, "pom", version);
            esaMap.putAll(this.populateESAMap(additionalBOM));
            this.prepareFeature(groupId, artifactId, version, additionalBOM, esaMap);
        }
    }

    private Map<File, String> populateESAMap(File additionalBOM) {
        HashMap<File, String> result = new HashMap();
        try {
            result = this.downloadArtifactsFromBOM(additionalBOM);
        }
        catch (PluginExecutionException e) {
            this.warn(e.getMessage());
            this.warn("A features-bom file must be provided at " + additionalBOM.getAbsolutePath() + ". Please ignore this warning if this is not a user feature.");
        }
        return result;
    }

    private void prepareFeature(String groupId, String artifactId, String version, File additionalBOM, Map<File, String> esaMap) throws PluginExecutionException {
        Object json = null;
        try {
            String repoLocation = this.parseRepositoryLocation(additionalBOM, groupId, artifactId, "pom", version);
            String targetJsonFile = this.createArtifactFilePath(repoLocation, groupId, FEATURES_JSON_ARTIFACT_ID, "json", version);
            File generatedJson = this.generateJson(targetJsonFile, esaMap);
            if (generatedJson.exists()) {
                this.jsonFile = generatedJson;
                this.provideJsonFileDependency(generatedJson, groupId, version);
                this.info("The features.json has been generated at the following location: " + generatedJson);
            }
        }
        catch (PluginExecutionException e) {
            this.warn(e.getMessage());
        }
    }

    private Map<File, String> downloadArtifactsFromBOM(File additionalBOM) throws PluginExecutionException {
        HashMap<File, String> result = new HashMap<File, String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(additionalBOM);
            doc.getDocumentElement().normalize();
            NodeList dependencyList = doc.getElementsByTagName("dependency");
            for (int itr = 0; itr < dependencyList.getLength(); ++itr) {
                Node node = dependencyList.item(itr);
                if (node.getNodeType() != 1) continue;
                Element eElement = (Element)node;
                String groupId = eElement.getElementsByTagName("groupId").item(0).getTextContent();
                String artifactId = eElement.getElementsByTagName("artifactId").item(0).getTextContent();
                String version = eElement.getElementsByTagName("version").item(0).getTextContent();
                String type = eElement.getElementsByTagName("type").item(0).getTextContent();
                File artifactFile = this.downloadArtifact(groupId, artifactId, type, version);
                result.put(artifactFile, groupId);
            }
        }
        catch (PluginExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PluginExecutionException("Cannot read the BOM file " + additionalBOM.getAbsolutePath(), e);
        }
        return result;
    }

    private String createArtifactFilePath(String repoLocation, String groupId, String artifactId, String fileType, String version) {
        if (OSUtil.isWindows()) {
            groupId = groupId.replace(".", "\\");
            return String.format("%s%s\\%s\\%s\\%s-%s.%s", repoLocation, groupId, artifactId, version, artifactId, version, fileType);
        }
        groupId = groupId.replace(".", "/");
        return String.format("%s%s/%s/%s/%s-%s.%s", repoLocation, groupId, artifactId, version, artifactId, version, fileType);
    }

    private String parseRepositoryLocation(File fileFromRepo, String groupId, String artifactId, String fileType, String version) {
        String absFileFromRepo = fileFromRepo.getAbsolutePath();
        String fileSubString = "";
        if (OSUtil.isWindows()) {
            groupId = groupId.replace(".", "\\");
            fileSubString = String.format("%s\\%s\\%s\\%s-%s.%s", groupId, artifactId, version, artifactId, version, fileType);
        } else {
            groupId = groupId.replace(".", "/");
            fileSubString = String.format("%s/%s/%s/%s-%s.%s", groupId, artifactId, version, artifactId, version, fileType);
        }
        return absFileFromRepo.replace(fileSubString, "");
    }

    public File generateJson(String targetJsonFile, Map<File, String> esaFileMap) throws PluginExecutionException {
        FileInputStream instream = null;
        FileOutputStream outstream = null;
        try {
            int length;
            Path targetDir = Files.createTempDirectory("generatedJson", new FileAttribute[0]);
            URL installJarURL = null;
            try {
                installJarURL = this.installJarFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new PluginExecutionException("Could not resolve URL from file " + this.installJarFile, e);
            }
            Map<String, Object> mapBasedInstallKernel = null;
            File json = null;
            ArrayList<File> esaFileList = new ArrayList<File>();
            esaFileList.addAll(esaFileMap.keySet());
            try (URLClassLoader loader = new URLClassLoader(new URL[]{installJarURL}, this.getClass().getClassLoader());){
                mapBasedInstallKernel = this.createMapBasedInstallKernelInstance(loader, this.installDirectory);
                mapBasedInstallKernel.put("individual.esas", esaFileList);
                mapBasedInstallKernel.put("target.json.dir", targetDir.toFile());
                mapBasedInstallKernel.put("generate.json.group.id.map", esaFileMap);
                mapBasedInstallKernel.put("generate.json", true);
                json = (File)mapBasedInstallKernel.get("generate.json");
                if (mapBasedInstallKernel.get("action.error.message") != null) {
                    this.debug("generateJson action.error.message: " + mapBasedInstallKernel.get("action.error.message"));
                    this.debug("generateJson action.exception.stacktrace: " + mapBasedInstallKernel.get("action.exception.stacktrace"));
                }
            }
            catch (PrivilegedActionException e) {
                throw new PluginExecutionException("Could not load the jar " + this.installJarFile.getAbsolutePath(), e);
            }
            File targetFile = new File(targetJsonFile);
            instream = new FileInputStream(json);
            targetFile.getParentFile().mkdirs();
            outstream = new FileOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            while ((length = instream.read(buffer)) > 0) {
                outstream.write(buffer, 0, length);
            }
            File file = targetFile;
            return file;
        }
        catch (IOException e) {
            this.debug(e);
            throw new PluginExecutionException("Cannot read or create json file " + targetJsonFile, e);
        }
        finally {
            try {
                instream.close();
                outstream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private File loadInstallJarFile(File installDirectory) {
        File installJarOverride;
        if (this.openLibertyVersion != null && (installJarOverride = this.downloadOverrideJar(OPEN_LIBERTY_GROUP_ID, INSTALL_MAP_ARTIFACT_ID)) != null && installJarOverride.exists()) {
            return installJarOverride;
        }
        return InstallFeatureUtil.getMapBasedInstallKernelJar(new File(installDirectory, "lib"));
    }

    private File downloadOverrideJar(String groupId, String artifactId) {
        try {
            return this.downloadArtifact(groupId, artifactId, "jar", String.format("[%s)", this.openLibertyVersion + ", " + InstallFeatureUtil.getNextProductVersion(this.openLibertyVersion)));
        }
        catch (PluginExecutionException e) {
            this.debug("Could not find override bundle " + groupId + ":" + artifactId + " for the current Open Liberty version " + this.openLibertyVersion, e);
            return null;
        }
    }

    private Map<String, Object> createMapBasedInstallKernelInstance(final ClassLoader loader, File installDirectory) throws PrivilegedActionException, PluginExecutionException {
        Map<String, Object> mapBasedInstallKernel = AccessController.doPrivileged(new PrivilegedExceptionAction<Map<String, Object>>(){

            @Override
            public Map<String, Object> run() throws Exception {
                Class<?> clazz = loader.loadClass("com.ibm.ws.install.map.InstallMap");
                return (Map)clazz.newInstance();
            }
        });
        if (mapBasedInstallKernel == null) {
            throw new PluginExecutionException("Cannot run install jar file " + this.installJarFile);
        }
        String bundle = this.getOverrideBundleDescriptor(OPEN_LIBERTY_GROUP_ID, "repository-resolver");
        if (bundle != null) {
            ArrayList<String> bundles = new ArrayList<String>();
            bundles.add(bundle);
            this.debug("Overriding jar using: " + bundle);
            mapBasedInstallKernel.put("override.jar.bundles", bundles);
        }
        mapBasedInstallKernel.put("runtime.install.dir", installDirectory);
        try {
            mapBasedInstallKernel.put("install.map.jar.file", this.installJarFile);
            this.debug("install.map.jar.file: " + this.installJarFile);
        }
        catch (RuntimeException e) {
            this.debug("This version of the install map does not support the key \"install.map.jar.file\"", e);
            String installJarFileSubpath = this.installJarFile.getParentFile().getName() + File.separator + this.installJarFile.getName();
            mapBasedInstallKernel.put("install.map.jar", installJarFileSubpath);
            this.debug("install.map.jar: " + installJarFileSubpath);
        }
        this.debug("install.kernel.init.code: " + mapBasedInstallKernel.get("install.kernel.init.code"));
        this.debug("install.kernel.init.error.message: " + mapBasedInstallKernel.get("install.kernel.init.error.message"));
        File usrDir = new File(installDirectory, "usr");
        mapBasedInstallKernel.put("target.user.directory", usrDir);
        return mapBasedInstallKernel;
    }

    public String getOverrideBundleDescriptor(String groupId, String artifactId) throws PluginExecutionException {
        String symbolicName;
        File overrideJar = this.downloadOverrideJar(groupId, artifactId);
        if (overrideJar != null && overrideJar.exists() && (symbolicName = InstallFeatureUtil.extractSymbolicName(overrideJar)) != null) {
            return overrideJar.getAbsolutePath() + ";" + symbolicName;
        }
        return null;
    }

    public void provideJsonFileDependency(File file, String groupId, String version) {
    }

    @Override
    public abstract void debug(String var1);

    @Override
    public abstract void debug(String var1, Throwable var2);

    @Override
    public abstract void debug(Throwable var1);

    @Override
    public abstract void warn(String var1);

    @Override
    public abstract void info(String var1);

    @Override
    public abstract void error(String var1);

    @Override
    public abstract void error(String var1, Throwable var2);

    @Override
    public abstract boolean isDebugEnabled();

    public abstract File downloadArtifact(String var1, String var2, String var3, String var4) throws PluginExecutionException;
}

