/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public abstract class XmlDocument {
    protected Document doc;

    public void createDocument(String rootElement) throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        this.doc = docBuilder.newDocument();
        this.doc.setXmlStandalone(true);
        Element element = this.doc.createElement(rootElement);
        this.doc.appendChild(element);
    }

    public void createDocument(File xmlFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setCoalescing(true);
        builderFactory.setIgnoringElementContentWhitespace(true);
        builderFactory.setValidating(false);
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        this.doc = builder.parse(xmlFile);
    }

    public void writeXMLDocument(String fileName) throws IOException, TransformerException {
        File f = new File(fileName);
        this.writeXMLDocument(f);
    }

    public void writeXMLDocument(File f) throws IOException, TransformerException {
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        FileOutputStream outFile = new FileOutputStream(f);
        DOMSource source = new DOMSource(this.doc);
        StreamResult result = new StreamResult(outFile);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("doctype-public", "yes");
        transformer.setOutputProperty("version", "1.0");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (this.isIndented()) {
            transformer.setOutputProperty("indent", "no");
        } else {
            transformer.setOutputProperty("indent", "yes");
        }
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.transform(source, result);
        outFile.close();
    }

    protected boolean isIndented() {
        Node x = this.doc.getDocumentElement().getFirstChild();
        return this.isWhitespace(x);
    }

    protected boolean isWhitespace(Node node) {
        return node != null && node instanceof Text && ((Text)node).getData().trim().isEmpty();
    }

    public static void addNewlineBeforeFirstElement(File f) throws IOException {
        byte[] contents = Files.readAllBytes(f.toPath());
        String xmlContents = new String(contents, StandardCharsets.UTF_8);
        xmlContents = xmlContents.replace("?><", "?>" + System.getProperty("line.separator") + "<");
        Files.write(f.toPath(), xmlContents.getBytes(), new OpenOption[0]);
    }
}

