/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.config;

import io.openliberty.tools.common.CommonLoggerI;
import io.openliberty.tools.common.plugins.util.VariableUtility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ServerConfigDocument {
    private static ServerConfigDocument instance;
    private static CommonLoggerI log;
    private static DocumentBuilder docBuilder;
    private static File configDirectory;
    private static File serverXMLFile;
    private static Set<String> names;
    private static Set<String> namelessLocations;
    private static Set<String> locations;
    private static HashMap<String, String> locationsAndNames;
    private static Properties props;
    private static Properties defaultProps;
    private static Map<String, File> libertyDirectoryPropertyToFile;
    private static final XPathExpression XPATH_SERVER_APPLICATION;
    private static final XPathExpression XPATH_SERVER_WEB_APPLICATION;
    private static final XPathExpression XPATH_SERVER_ENTERPRISE_APPLICATION;
    private static final XPathExpression XPATH_SERVER_INCLUDE;
    private static final XPathExpression XPATH_SERVER_VARIABLE;

    public Set<String> getLocations() {
        return locations;
    }

    public Set<String> getNames() {
        return names;
    }

    public Set<String> getNamelessLocations() {
        return namelessLocations;
    }

    public static Properties getProperties() {
        return props;
    }

    public static Map<String, File> getLibertyDirPropertyFiles() {
        return libertyDirectoryPropertyToFile;
    }

    public static Properties getDefaultProperties() {
        return defaultProps;
    }

    private static File getServerXML() {
        return serverXMLFile;
    }

    public ServerConfigDocument(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) {
        this(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, true, null);
    }

    public ServerConfigDocument(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence) {
        this(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, giveConfigDirPrecedence, null);
    }

    public ServerConfigDocument(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence, Map<String, File> libertyDirPropertyFiles) {
        ServerConfigDocument.initializeAppsLocation(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, giveConfigDirPrecedence, libertyDirPropertyFiles);
    }

    private static DocumentBuilder getDocumentBuilder() {
        if (docBuilder == null) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setIgnoringComments(true);
            docBuilderFactory.setCoalescing(true);
            docBuilderFactory.setIgnoringElementContentWhitespace(true);
            docBuilderFactory.setValidating(false);
            try {
                docBuilder = docBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        return docBuilder;
    }

    public static void markInstanceStale() {
        instance = null;
    }

    public static ServerConfigDocument getInstance(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile) throws IOException {
        return ServerConfigDocument.getInstance(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, true, null);
    }

    public static ServerConfigDocument getInstance(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence) throws IOException {
        return ServerConfigDocument.getInstance(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, giveConfigDirPrecedence, null);
    }

    public static ServerConfigDocument getInstance(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence, Map<String, File> libertyDirPropertyFiles) throws IOException {
        if (instance == null || !serverXML.getCanonicalPath().equals(ServerConfigDocument.getServerXML().getCanonicalPath())) {
            instance = new ServerConfigDocument(log, serverXML, configDir, bootstrapFile, bootstrapProp, serverEnvFile, giveConfigDirPrecedence, libertyDirPropertyFiles);
        }
        return instance;
    }

    private static void initializeAppsLocation(CommonLoggerI log, File serverXML, File configDir, File bootstrapFile, Map<String, String> bootstrapProp, File serverEnvFile, boolean giveConfigDirPrecedence, Map<String, File> libertyDirPropertyFiles) {
        try {
            ServerConfigDocument.log = log;
            serverXMLFile = serverXML;
            configDirectory = configDir;
            if (libertyDirPropertyFiles != null) {
                libertyDirectoryPropertyToFile = new HashMap<String, File>(libertyDirPropertyFiles);
            } else {
                log.warn("The properties for directories are null and could lead to application locations not being resolved correctly.");
                libertyDirectoryPropertyToFile = new HashMap<String, File>();
            }
            locations = new HashSet<String>();
            names = new HashSet<String>();
            namelessLocations = new HashSet<String>();
            locationsAndNames = new HashMap();
            props = new Properties();
            defaultProps = new Properties();
            Document doc = ServerConfigDocument.parseDocument(new FileInputStream(serverXMLFile));
            ServerConfigDocument.parseVariablesForDefaultValues(doc);
            File cfgFile = ServerConfigDocument.findConfigFile("server.env", serverEnvFile, giveConfigDirPrecedence);
            if (cfgFile != null) {
                ServerConfigDocument.parseProperties(new FileInputStream(cfgFile));
            }
            File cfgDirFile = ServerConfigDocument.getFileFromConfigDirectory("bootstrap.properties");
            if (giveConfigDirPrecedence && cfgDirFile != null) {
                ServerConfigDocument.parseProperties(new FileInputStream(cfgDirFile));
            } else if (bootstrapProp != null && !bootstrapProp.isEmpty()) {
                for (Map.Entry<String, String> entry : bootstrapProp.entrySet()) {
                    if (entry.getValue() == null) continue;
                    props.setProperty(entry.getKey(), entry.getValue());
                }
            } else if (bootstrapFile != null && bootstrapFile.exists()) {
                ServerConfigDocument.parseProperties(new FileInputStream(bootstrapFile));
            } else if (cfgDirFile != null) {
                ServerConfigDocument.parseProperties(new FileInputStream(cfgDirFile));
            }
            ServerConfigDocument.parseIncludeVariables(doc);
            ServerConfigDocument.parseConfigDropinsDirVariables("defaults");
            ServerConfigDocument.parseVariablesForValues(doc);
            ServerConfigDocument.parseConfigDropinsDirVariables("overrides");
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            ServerConfigDocument.parseNames(doc, "/server/application | /server/webApplication | /server/enterpriseApplication");
            ServerConfigDocument.parseInclude(doc);
            ServerConfigDocument.parseConfigDropinsDir();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void parseNames(Document doc, String expression) throws XPathExpressionException, IOException, SAXException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getAttributes().getNamedItem("name") != null) {
                String nameValue = nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String locationValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
                if (nameValue.isEmpty()) continue;
                String resolvedName = VariableUtility.resolveVariables(log, nameValue, null, ServerConfigDocument.getProperties(), ServerConfigDocument.getDefaultProperties(), ServerConfigDocument.getLibertyDirPropertyFiles());
                String resolvedLocation = VariableUtility.resolveVariables(log, locationValue, null, ServerConfigDocument.getProperties(), ServerConfigDocument.getDefaultProperties(), ServerConfigDocument.getLibertyDirPropertyFiles());
                if (resolvedName == null) {
                    if (!names.contains(nameValue)) {
                        names.add(nameValue);
                    }
                } else if (!names.contains(resolvedName)) {
                    names.add(resolvedName);
                }
                if (resolvedLocation == null) continue;
                if (resolvedName == null) {
                    locationsAndNames.put(resolvedLocation, nameValue);
                    continue;
                }
                locationsAndNames.put(resolvedLocation, resolvedName);
                continue;
            }
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty()) continue;
            String resolved = VariableUtility.resolveVariables(log, nodeValue, null, ServerConfigDocument.getProperties(), ServerConfigDocument.getDefaultProperties(), ServerConfigDocument.getLibertyDirPropertyFiles());
            if (resolved == null) {
                if (namelessLocations.contains(nodeValue)) continue;
                namelessLocations.add(nodeValue);
                continue;
            }
            if (namelessLocations.contains(resolved)) continue;
            namelessLocations.add(resolved);
        }
    }

    public static String findNameForLocation(String location) {
        String appName = locationsAndNames.get(location);
        if (appName == null || appName.isEmpty()) {
            appName = location.substring(0, location.lastIndexOf(46));
        }
        return appName;
    }

    private static void parseApplication(Document doc, XPathExpression expression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)expression.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String nodeValue = nodeList.item(i).getAttributes().getNamedItem("location").getNodeValue();
            if (nodeValue.isEmpty()) continue;
            String resolved = VariableUtility.resolveVariables(log, nodeValue, null, ServerConfigDocument.getProperties(), ServerConfigDocument.getDefaultProperties(), ServerConfigDocument.getLibertyDirPropertyFiles());
            if (resolved == null) {
                log.info("The variables referenced by location " + nodeValue + " cannot be resolved.");
                if (locations.contains(nodeValue)) continue;
                locations.add(nodeValue);
                continue;
            }
            if (locations.contains(resolved)) continue;
            log.debug("Adding resolved app location: " + resolved + " for specified location: " + nodeValue);
            locations.add(resolved);
        }
    }

    private static void parseInclude(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element child = (Element)nodeList.item(i);
            String nodeValue = child.getAttribute("location");
            String includeFileName = VariableUtility.resolveVariables(log, nodeValue, null, ServerConfigDocument.getProperties(), ServerConfigDocument.getDefaultProperties(), ServerConfigDocument.getLibertyDirPropertyFiles());
            if (includeFileName == null || includeFileName.trim().isEmpty()) {
                log.warn("Unable to resolve include file location " + nodeValue + ". Skipping the included file during application location processing.");
                return;
            }
            Document docIncl = ServerConfigDocument.getIncludeDoc(includeFileName);
            if (docIncl == null) continue;
            ServerConfigDocument.parseApplication(docIncl, XPATH_SERVER_APPLICATION);
            ServerConfigDocument.parseApplication(docIncl, XPATH_SERVER_WEB_APPLICATION);
            ServerConfigDocument.parseApplication(docIncl, XPATH_SERVER_ENTERPRISE_APPLICATION);
            ServerConfigDocument.parseInclude(docIncl);
        }
    }

    private static void parseConfigDropinsDir() throws XPathExpressionException, IOException, SAXException {
        File configDropins = ServerConfigDocument.getConfigDropinsDir();
        if (configDropins != null && configDropins.exists()) {
            File defaults;
            File overrides = new File(configDropins, "overrides");
            if (overrides.exists()) {
                ServerConfigDocument.parseDropinsFiles(overrides.listFiles());
            }
            if ((defaults = new File(configDropins, "defaults")).exists()) {
                ServerConfigDocument.parseDropinsFiles(defaults.listFiles());
            }
        }
    }

    private static void parseDropinsFiles(File[] files) throws XPathExpressionException, IOException, SAXException {
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            ServerConfigDocument.parseDropinsFile(files[i]);
        }
    }

    private static Document parseDropinsXMLFile(File file) throws FileNotFoundException, IOException {
        Document document;
        FileInputStream is = new FileInputStream(file);
        try {
            document = ServerConfigDocument.parseDocument(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXException ex) {
                log.info("Skipping parsing " + file.getAbsolutePath() + " because it was not recognized as XML.");
                return null;
            }
        }
        is.close();
        return document;
    }

    private static void parseDropinsFile(File file) throws IOException, XPathExpressionException, SAXException {
        Document doc = ServerConfigDocument.parseDropinsXMLFile(file);
        if (doc != null) {
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_WEB_APPLICATION);
            ServerConfigDocument.parseApplication(doc, XPATH_SERVER_ENTERPRISE_APPLICATION);
            ServerConfigDocument.parseInclude(doc);
        }
    }

    private static Document getIncludeDoc(String loc) throws IOException, SAXException {
        Document doc = null;
        File locFile = null;
        if (loc.startsWith("http:") || loc.startsWith("https:")) {
            if (ServerConfigDocument.isValidURL(loc)) {
                URL url = new URL(loc);
                URLConnection connection = url.openConnection();
                doc = ServerConfigDocument.parseDocument(connection.getInputStream());
            }
        } else if (loc.startsWith("file:")) {
            if (ServerConfigDocument.isValidURL(loc) && (locFile = new File(loc)).exists()) {
                FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                doc = ServerConfigDocument.parseDocument(inputStream);
            }
        } else if (!loc.startsWith("ftp:")) {
            locFile = new File(loc);
            if (locFile.isAbsolute()) {
                if (locFile.exists()) {
                    FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                    doc = ServerConfigDocument.parseDocument(inputStream);
                }
            } else {
                if (configDirectory != null && configDirectory.exists()) {
                    locFile = new File(configDirectory, loc);
                }
                if (locFile == null || !locFile.exists()) {
                    locFile = new File(ServerConfigDocument.getServerXML().getParentFile(), loc);
                }
                if (locFile != null && locFile.exists()) {
                    FileInputStream inputStream = new FileInputStream(locFile.getCanonicalPath());
                    doc = ServerConfigDocument.parseDocument(inputStream);
                }
            }
        }
        return doc;
    }

    private static Document parseDocument(InputStream in) throws SAXException, IOException {
        try (InputStream ins = in;){
            Document document = ServerConfigDocument.getDocumentBuilder().parse(ins);
            return document;
        }
    }

    private static void parseProperties(InputStream ins) throws Exception {
        try {
            props.load(ins);
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
        }
    }

    private static boolean isValidURL(String url) {
        try {
            URL testURL = new URL(url);
            testURL.toURI();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static void parseVariablesForDefaultValues(Document doc) throws XPathExpressionException {
        ServerConfigDocument.parseVariables(doc, true, false, false);
    }

    private static void parseVariablesForValues(Document doc) throws XPathExpressionException {
        ServerConfigDocument.parseVariables(doc, false, true, false);
    }

    private static void parseVariablesForBothValues(Document doc) throws XPathExpressionException {
        ServerConfigDocument.parseVariables(doc, false, false, true);
    }

    private static void parseVariables(Document doc, boolean defaultValues, boolean values, boolean both) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPATH_SERVER_VARIABLE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap attr = nodeList.item(i).getAttributes();
            String varName = attr.getNamedItem("name").getNodeValue();
            if (varName.isEmpty()) continue;
            String varValue = ServerConfigDocument.getValue(attr, "value");
            String varDefaultValue = ServerConfigDocument.getValue(attr, "defaultValue");
            if ((values || both) && varValue != null && !varValue.isEmpty()) {
                props.setProperty(varName, varValue);
            }
            if (!defaultValues && !both || varDefaultValue == null || varDefaultValue.isEmpty()) continue;
            defaultProps.setProperty(varName, varDefaultValue);
        }
    }

    private static String getValue(NamedNodeMap attr, String nodeName) {
        String value = null;
        Node valueNode = attr.getNamedItem(nodeName);
        if (valueNode != null) {
            value = valueNode.getNodeValue();
        }
        return value;
    }

    private static void parseIncludeVariables(Document doc) throws XPathExpressionException, IOException, SAXException {
        NodeList nodeList = (NodeList)XPATH_SERVER_INCLUDE.evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element child = (Element)nodeList.item(i);
            String nodeValue = child.getAttribute("location");
            String includeFileName = VariableUtility.resolveVariables(log, nodeValue, null, ServerConfigDocument.getProperties(), ServerConfigDocument.getDefaultProperties(), ServerConfigDocument.getLibertyDirPropertyFiles());
            if (includeFileName == null || includeFileName.trim().isEmpty()) {
                log.warn("Unable to resolve include file location " + nodeValue + ". Skipping the included file during application location processing.");
                return;
            }
            Document docIncl = ServerConfigDocument.getIncludeDoc(includeFileName);
            if (docIncl != null) {
                ServerConfigDocument.parseVariablesForBothValues(docIncl);
                ServerConfigDocument.parseIncludeVariables(docIncl);
                continue;
            }
            log.warn("Unable to parse include file " + includeFileName + ". Skipping the included file during application location processing.");
        }
    }

    private static File getConfigDropinsDir() {
        File configDropins = null;
        if (configDirectory != null && configDirectory.exists()) {
            configDropins = new File(configDirectory, "configDropins");
        }
        if (configDropins == null || !configDropins.exists()) {
            configDropins = new File(ServerConfigDocument.getServerXML().getParent(), "configDropins");
        }
        return configDropins;
    }

    private static void parseConfigDropinsDirVariables(String inDir) throws XPathExpressionException, SAXException, IOException {
        File dir;
        File configDropins = ServerConfigDocument.getConfigDropinsDir();
        if (configDropins != null && configDropins.exists() && (dir = new File(configDropins, inDir)).exists()) {
            File[] cfgFiles = dir.listFiles();
            for (int i = 0; i < cfgFiles.length; ++i) {
                if (!cfgFiles[i].isFile()) continue;
                ServerConfigDocument.parseDropinsFilesVariables(cfgFiles[i]);
            }
        }
    }

    private static void parseDropinsFilesVariables(File file) throws SAXException, IOException, XPathExpressionException {
        Document doc = ServerConfigDocument.parseDropinsXMLFile(file);
        if (doc != null) {
            ServerConfigDocument.parseVariablesForBothValues(doc);
            ServerConfigDocument.parseIncludeVariables(doc);
        }
    }

    private static File findConfigFile(String fileName, File specificFile, boolean giveConfigDirPrecedence) {
        File f = new File(configDirectory, fileName);
        if (giveConfigDirPrecedence) {
            if (configDirectory != null && f.exists()) {
                return f;
            }
            if (specificFile != null && specificFile.exists()) {
                return specificFile;
            }
        } else {
            if (specificFile != null && specificFile.exists()) {
                return specificFile;
            }
            if (configDirectory != null && f.exists()) {
                return f;
            }
        }
        return null;
    }

    private static File getFileFromConfigDirectory(String file) {
        File f = new File(configDirectory, file);
        if (configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    static {
        libertyDirectoryPropertyToFile = null;
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            XPATH_SERVER_APPLICATION = xPath.compile("/server/application");
            XPATH_SERVER_WEB_APPLICATION = xPath.compile("/server/webApplication");
            XPATH_SERVER_ENTERPRISE_APPLICATION = xPath.compile("/server/enterpriseApplication");
            XPATH_SERVER_INCLUDE = xPath.compile("/server/include");
            XPATH_SERVER_VARIABLE = xPath.compile("/server/variable");
        }
        catch (XPathExpressionException ex) {
            throw new RuntimeException(ex);
        }
    }
}

