/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.plugins.util;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.openliberty.tools.ant.ServerTask;
import io.openliberty.tools.common.plugins.util.AbstractContainerSupportUtil;
import io.openliberty.tools.common.plugins.util.JavaCompilerOptions;
import io.openliberty.tools.common.plugins.util.OSUtil;
import io.openliberty.tools.common.plugins.util.PluginExecutionException;
import io.openliberty.tools.common.plugins.util.PluginScenarioException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.maven.artifact.versioning.ComparableVersion;

public abstract class DevUtil
extends AbstractContainerSupportUtil {
    private static final String START_SERVER_MESSAGE_PREFIX = "CWWKF0011I:";
    private static final String START_APP_MESSAGE_REGEXP = "CWWKZ0001I.*";
    private static final String UPDATED_APP_MESSAGE_REGEXP = "CWWKZ0003I.*";
    private static final String PORT_IN_USE_MESSAGE_PREFIX = "CWWKO0221E:";
    private static final String WEB_APP_AVAILABLE_MESSAGE_PREFIX = "CWWKT0016I:";
    private static final String LISTENING_ON_PORT_MESSAGE_PREFIX = "CWWKO0219I:";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTP_PREFIX_ESCAPED = "http:\\/\\/";
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTPS_PREFIX_ESCAPED = "https:\\/\\/";
    private static final String DEVMODE_DIR_NAME = "/devmode";
    public static final String DEVMODE_PROJECT_ROOT = "io.openliberty.tools.projectRoot";
    private static final String GENERATED_HEADER_REGEX = "# Generated by liberty-.*-plugin";
    private static final String DEVMODE_CONTAINER_BASE_NAME = "liberty-dev";
    private static final String DEVMODE_IMAGE_SUFFIX = "-dev-mode";
    public static final String SKIP_BETA_INSTALL_WARNING = "skipBetaInstallFeatureWarning";
    public static final String DEVC_HIDDEN_FOLDER = ".libertyDevc";
    private static final String[] IGNORE_DIRECTORY_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_PREFIXES = new String[]{"."};
    private static final String[] IGNORE_FILE_POSTFIXES = new String[]{".dmp", "~", "___jb_tmp___", "___jb_old___"};
    private static final String[] DEFAULT_COMPILER_OPTIONS = new String[]{"-g", "-parameters"};
    private static final int LIBERTY_DEFAULT_HTTP_PORT = 9080;
    private static final int LIBERTY_DEFAULT_HTTPS_PORT = 9443;
    private static final int LIBERTY_DEFAULT_DEBUG_PORT = 7777;
    private static final int DOCKER_TIMEOUT = 20;
    private File serverDirectory;
    private File sourceDirectory;
    private File testSourceDirectory;
    private File configDirectory;
    private File projectDirectory;
    private List<File> resourceDirs;
    private boolean hotTests;
    private Path tempConfigPath;
    private boolean skipTests;
    private boolean skipUTs;
    private boolean skipITs;
    private String applicationId;
    private int appStartupTimeout;
    private int appUpdateTimeout;
    private Thread serverThread;
    private PluginExecutionException serverThreadException;
    private AtomicBoolean devStop;
    private String hostName;
    private String httpPort;
    private String httpsPort;
    private String containerHttpPort;
    private String containerHttpsPort;
    private final long compileWaitMillis;
    private AtomicBoolean inputUnavailable;
    private int alternativeDebugPort = -1;
    private boolean libertyDebug;
    private int libertyDebugPort;
    private AtomicBoolean detectedAppStarted;
    private long serverStartTimeout;
    private boolean useBuildRecompile;
    private Map<File, Properties> propertyFilesMap;
    private final Set<FileAlterationObserver> fileObservers;
    private final Set<FileAlterationObserver> newFileObservers;
    private final Set<FileAlterationObserver> cancelledFileObservers;
    private AtomicBoolean calledShutdownHook;
    private boolean gradle;
    private long pollingInterval;
    private FileTrackMode trackingMode;
    private final boolean container;
    private String imageName;
    private String containerName;
    private File dockerfile;
    private Path tempDockerfilePath = null;
    private String dockerRunOpts;
    private volatile Process dockerRunProcess;
    private File defaultDockerfile;
    private int dockerBuildTimeout;
    private boolean skipDefaultPorts;
    private boolean keepTempDockerfile;
    protected List<String> srcMount = new ArrayList<String>();
    protected List<String> destMount = new ArrayList<String>();
    private boolean firstStartup = true;
    private Set<Path> dockerfileDirectoriesToWatch = new HashSet<Path>();
    private Set<Path> dockerfileDirectoriesTracked = new HashSet<Path>();
    private Set<WatchKey> dockerfileDirectoriesWatchKeys = new HashSet<WatchKey>();
    private Set<FileAlterationObserver> dockerfileDirectoriesFileObservers = new HashSet<FileAlterationObserver>();
    private final JavaCompilerOptions compilerOptions;
    private final String mavenCacheLocation;
    private AtomicBoolean externalContainerShutdown;
    private AtomicBoolean shownFeaturesShWarning;
    protected AtomicBoolean hasFeaturesSh;
    protected AtomicBoolean serverFullyStarted;
    private final File buildDirectory;
    private static final String MIN_DOCKER_VERSION = "18.03.0";
    private static final long DOCKER_BUILD_SOFT_TIMEOUT = 30000L;
    private HotkeyReader hotkeyReader = null;
    Collection<File> recompileJavaSources;
    Collection<File> recompileJavaTests;
    Collection<File> deleteJavaSources;
    Collection<File> deleteJavaTests;
    Collection<File> failedCompilationJavaSources;
    Collection<File> failedCompilationJavaTests;
    long lastJavaSourceChange;
    long lastJavaTestChange;
    boolean triggerJavaSourceRecompile;
    boolean triggerJavaTestRecompile;
    File outputDirectory;
    File serverXmlFile;
    File serverXmlFileParent;
    File bootstrapPropertiesFile;
    File bootstrapPropertiesFileParent;
    File jvmOptionsFile;
    File jvmOptionsFileParent;
    File buildFile;
    File dockerfileUsed;
    List<String> artifactPaths;
    WatchService watcher;

    @Override
    public abstract void debug(String var1);

    public abstract void debug(String var1, Throwable var2);

    public abstract void debug(Throwable var1);

    public abstract void warn(String var1);

    public abstract void info(String var1);

    public abstract void error(String var1);

    @Override
    public abstract void error(String var1, Throwable var2);

    public abstract boolean isDebugEnabled();

    public abstract List<String> getArtifacts();

    public abstract boolean recompileBuildFile(File var1, List<String> var2, ThreadPoolExecutor var3) throws PluginExecutionException;

    public abstract void runUnitTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void runIntegrationTests() throws PluginScenarioException, PluginExecutionException;

    public abstract void checkConfigFile(File var1, File var2);

    public abstract boolean compile(File var1);

    public abstract void stopServer();

    public abstract ServerTask getServerTask() throws Exception;

    public abstract void redeployApp() throws PluginExecutionException;

    public abstract String getServerStartTimeoutExample();

    public abstract String getProjectName();

    public abstract boolean isLooseApplication();

    public DevUtil(File buildDirectory, File serverDirectory, File sourceDirectory, File testSourceDirectory, File configDirectory, File projectDirectory, List<File> resourceDirs, boolean hotTests, boolean skipTests, boolean skipUTs, boolean skipITs, String applicationId, long serverStartTimeout, int appStartupTimeout, int appUpdateTimeout, long compileWaitMillis, boolean libertyDebug, boolean useBuildRecompile, boolean gradle, boolean pollingTest, boolean container, File dockerfile, String dockerRunOpts, int dockerBuildTimeout, boolean skipDefaultPorts, JavaCompilerOptions compilerOptions, boolean keepTempDockerfile, String mavenCacheLocation) {
        this.buildDirectory = buildDirectory;
        this.serverDirectory = serverDirectory;
        this.sourceDirectory = sourceDirectory;
        this.testSourceDirectory = testSourceDirectory;
        this.configDirectory = configDirectory;
        this.projectDirectory = projectDirectory;
        this.resourceDirs = resourceDirs;
        this.hotTests = hotTests;
        this.skipTests = skipTests;
        this.skipUTs = skipUTs;
        this.skipITs = skipITs;
        this.applicationId = applicationId;
        this.serverStartTimeout = serverStartTimeout;
        this.appStartupTimeout = appStartupTimeout;
        this.appUpdateTimeout = appUpdateTimeout;
        this.devStop = new AtomicBoolean(false);
        this.compileWaitMillis = compileWaitMillis;
        this.inputUnavailable = new AtomicBoolean(false);
        this.libertyDebug = libertyDebug;
        this.detectedAppStarted = new AtomicBoolean(false);
        this.useBuildRecompile = useBuildRecompile;
        this.calledShutdownHook = new AtomicBoolean(false);
        this.gradle = gradle;
        this.fileObservers = new HashSet<FileAlterationObserver>();
        this.newFileObservers = new HashSet<FileAlterationObserver>();
        this.cancelledFileObservers = new HashSet<FileAlterationObserver>();
        this.pollingInterval = 100L;
        this.trackingMode = pollingTest ? FileTrackMode.POLLING : FileTrackMode.NOT_SET;
        this.container = container;
        this.dockerfile = dockerfile;
        this.dockerRunOpts = dockerRunOpts;
        if (projectDirectory != null) {
            this.defaultDockerfile = new File(projectDirectory, "Dockerfile");
        }
        this.dockerBuildTimeout = dockerBuildTimeout < 1 ? 600 : dockerBuildTimeout;
        this.skipDefaultPorts = skipDefaultPorts;
        this.compilerOptions = compilerOptions;
        this.keepTempDockerfile = keepTempDockerfile;
        this.mavenCacheLocation = mavenCacheLocation;
        this.externalContainerShutdown = new AtomicBoolean(false);
        this.shownFeaturesShWarning = new AtomicBoolean(false);
        this.hasFeaturesSh = new AtomicBoolean(false);
        this.serverFullyStarted = new AtomicBoolean(false);
    }

    public void runTests(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs) {
        if (!this.skipTests) {
            ServerTask serverTask = null;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                this.error("Could not get the server task for running tests.", e);
            }
            File logFile = this.getMessagesLogFile(serverTask);
            String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                this.debug("Thread interrupted while waiting to start tests.", e);
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.debug("Tests were re-invoked before previous tests began. Cancelling previous tests and resubmitting them.");
                } else {
                    this.debug("Changes were detected before tests began. Cancelling tests and resubmitting them.");
                }
                return;
            }
            if (!(this.gradle || this.skipUTs || forceSkipUTs)) {
                this.info("Running unit tests...");
                try {
                    this.runUnitTests();
                    this.info("Unit tests finished.");
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
            if (executor.getQueue().size() >= 1) {
                Runnable head = (Runnable)executor.getQueue().peek();
                boolean manualInvocation = ((TestJob)head).isManualInvocation();
                if (manualInvocation) {
                    this.info("Tests were invoked while previous tests were running. Restarting tests.");
                } else {
                    this.info("Changes were detected while tests were running. Restarting tests.");
                }
                return;
            }
            if (!this.skipITs) {
                if (!this.detectedAppStarted.get()) {
                    if (this.appStartupTimeout < 0) {
                        this.warn("The verifyTimeout (verifyAppStartTimeout) value needs to be an integer greater than or equal to 0.  The default value of 30 seconds will be used.");
                        this.appStartupTimeout = 30;
                    }
                    long timeout = this.appStartupTimeout * 1000;
                    this.info("Waiting up to " + this.appStartupTimeout + " seconds to find the application start up or update message...");
                    String startMessage = serverTask.waitForStringInLog("(CWWKZ0001I.*|CWWKZ0003I.*" + this.applicationId + ")", timeout, logFile);
                    if (startMessage == null) {
                        this.error("Unable to verify if the application was started after " + this.appStartupTimeout + " seconds.  Consider increasing the verifyTimeout value if this continues to occur.");
                    } else {
                        this.detectedAppStarted.set(true);
                    }
                } else if (waitForApplicationUpdate) {
                    if (this.appUpdateTimeout < 0) {
                        this.appUpdateTimeout = 5;
                    }
                    long timeout = this.appUpdateTimeout * 1000;
                    serverTask.waitForUpdatedStringInLog(regexp, timeout, logFile, messageOccurrences);
                }
                if (this.gradle) {
                    this.info("Running tests...");
                } else {
                    this.info("Running integration tests...");
                }
                try {
                    this.runIntegrationTests();
                    if (this.gradle) {
                        this.info("Tests finished.");
                    } else {
                        this.info("Integration tests finished.");
                    }
                }
                catch (PluginScenarioException e) {
                    this.debug(e);
                    this.error(e.getMessage());
                    return;
                }
                catch (PluginExecutionException e) {
                    this.error(e.getMessage());
                }
            }
        }
    }

    public int countApplicationUpdatedMessages() {
        int messageOccurrences = -1;
        if (!this.skipTests && !this.skipITs) {
            try {
                ServerTask serverTask = this.getServerTask();
                File logFile = this.getMessagesLogFile(serverTask);
                String regexp = UPDATED_APP_MESSAGE_REGEXP + this.applicationId;
                messageOccurrences = serverTask.countStringOccurrencesInFile(regexp, logFile);
                this.debug("Message occurrences before compile: " + messageOccurrences);
            }
            catch (Exception e) {
                this.debug("Failed to get message occurrences before compile", e);
            }
        }
        return messageOccurrences;
    }

    private File getMessagesLogFile(ServerTask serverTask) {
        File logFile = this.container ? new File(this.serverDirectory, "logs/messages.log") : serverTask.getLogFile();
        return logFile;
    }

    public void startServer() throws PluginExecutionException {
        this.startServer(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(boolean buildContainer, boolean pullParentImage) throws PluginExecutionException {
        try {
            long serverStartTimeoutMillis;
            String startMessage;
            ServerTask serverTask;
            try {
                serverTask = this.getServerTask();
            }
            catch (Exception e) {
                throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
            }
            this.enableServerDebug();
            if (this.container) {
                this.checkDockerVersion();
            }
            if (this.container && buildContainer) {
                File dockerfileToUse = this.getDockerfile();
                this.debug("Dockerfile to use: " + dockerfileToUse);
                if (dockerfileToUse.exists()) {
                    File tempDockerfile = this.prepareTempDockerfile(dockerfileToUse);
                    this.buildDockerImage(tempDockerfile, dockerfileToUse, pullParentImage);
                } else {
                    throw new PluginExecutionException("No Dockerfile was found at " + dockerfileToUse.getAbsolutePath() + ". Create a Dockerfile at the specified location to use dev mode with container support. For an example of how to configure a Dockerfile, see https://github.com/OpenLiberty/ci.docker");
                }
            }
            String logsDirectory = this.serverDirectory.getCanonicalPath() + "/logs";
            final File messagesLogFile = new File(logsDirectory + "/messages.log");
            boolean logsExist = new File(logsDirectory).isDirectory();
            this.serverThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            if (DevUtil.this.container) {
                                DevUtil.this.startContainer();
                            } else {
                                serverTask.execute();
                            }
                        }
                        catch (RuntimeException e) {
                            if (DevUtil.this.devStop.get()) break block4;
                            PluginExecutionException e2 = DevUtil.this.container ? new PluginExecutionException("An error occurred while running the container: " + e.getMessage(), e) : new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
                            DevUtil.this.error(e2.getMessage());
                            DevUtil.this.serverThreadException = e2;
                        }
                    }
                }
            });
            this.serverThread.start();
            this.setDevStop(false);
            if (logsExist) {
                final AtomicBoolean messagesModified = new AtomicBoolean(false);
                FileFilter singleFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        block3: {
                            try {
                                if (file.getCanonicalFile().equals(messagesLogFile.getCanonicalFile())) {
                                    return true;
                                }
                            }
                            catch (IOException e) {
                                if (!file.equals(messagesLogFile)) break block3;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                FileAlterationObserver observer = new FileAlterationObserver(logsDirectory, singleFileFilter);
                observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

                    public void onFileCreate(File file) {
                        messagesModified.set(true);
                    }

                    public void onFileChange(File file) {
                        messagesModified.set(true);
                    }
                });
                try {
                    observer.initialize();
                    while (!messagesModified.get()) {
                        this.checkStopDevMode(false);
                        observer.checkAndNotify();
                        Thread.sleep(500L);
                    }
                    this.debug("messages.log has been changed");
                }
                catch (PluginScenarioException e) {
                    if (this.serverThreadException != null) {
                        throw this.serverThreadException;
                    }
                    throw new PluginExecutionException(e);
                }
                catch (Exception e) {
                    this.error("An error occured while waiting for the server to update messages.log: " + e.getMessage(), e);
                }
                finally {
                    try {
                        observer.destroy();
                    }
                    catch (Exception e) {
                        this.debug("Could not destroy FileAlterationObserver for logs directory " + logsDirectory, e);
                    }
                }
            } else {
                try {
                    while (!messagesLogFile.exists()) {
                        this.checkStopDevMode(false);
                        Thread.sleep(500L);
                    }
                    this.debug("messages.log has been created");
                }
                catch (PluginScenarioException e) {
                    if (this.serverThreadException != null) {
                        throw this.serverThreadException;
                    }
                    throw new PluginExecutionException(e);
                }
                catch (Exception e) {
                    this.error("An error occured while waiting for the server to create messages.log: " + e.getMessage(), e);
                }
            }
            if (this.serverStartTimeout < 0L) {
                this.warn("The serverStartTimeout value needs to be an integer greater than or equal to 0.  The default value of 90 seconds will be used.");
                this.serverStartTimeout = 90L;
            }
            if ((startMessage = serverTask.waitForStringInLog(START_SERVER_MESSAGE_PREFIX, serverStartTimeoutMillis = this.serverStartTimeout * 1000L, messagesLogFile)) == null) {
                this.setDevStop(true);
                if (this.container) {
                    this.stopContainer();
                } else {
                    this.stopServer();
                }
                throw new PluginExecutionException("The server has not started within " + this.serverStartTimeout + " seconds. Consider increasing the server start timeout if this continues to occur. For example, " + this.getServerStartTimeoutExample());
            }
            this.serverFullyStarted.set(true);
            String portError = serverTask.findStringInFile(PORT_IN_USE_MESSAGE_PREFIX, messagesLogFile);
            if (portError != null) {
                this.error(portError.split(PORT_IN_USE_MESSAGE_PREFIX)[1]);
            }
            this.parseHostNameAndPorts(serverTask, messagesLogFile);
        }
        catch (IOException e) {
            throw new PluginExecutionException("An error occurred while starting the server: " + e.getMessage(), e);
        }
    }

    private void checkDockerVersion() throws PluginExecutionException {
        String versionCmd = "docker version --format {{.Client.Version}}";
        String dockerVersion = this.execDockerCmd(versionCmd, 20);
        if (dockerVersion == null) {
            return;
        }
        this.debug("Detected Docker version >" + dockerVersion);
        ComparableVersion minVer = new ComparableVersion(MIN_DOCKER_VERSION);
        ComparableVersion curVer = new ComparableVersion(dockerVersion);
        if (curVer.compareTo(minVer) < 0) {
            throw new PluginExecutionException("The detected Docker client version number is not supported:" + dockerVersion.trim() + ". Docker version must be 18.03.0 or higher.");
        }
    }

    private File getDockerfile() {
        return this.dockerfile != null ? this.dockerfile : this.defaultDockerfile;
    }

    protected List<String> readDockerfile(File dockerfile) throws PluginExecutionException {
        List<String> dockerfileLines = null;
        try {
            dockerfileLines = Files.readAllLines(dockerfile.toPath());
        }
        catch (IOException e) {
            this.error("Failed to read Dockerfile located at " + dockerfile);
            throw new PluginExecutionException("Could not read Dockerfile " + dockerfile + ": " + e.getMessage(), e);
        }
        return dockerfileLines;
    }

    protected static char getEscapeCharacter(List<String> dockerfileLines) throws PluginExecutionException {
        String escapeChar;
        String contentAfterSymbol;
        String directive;
        String[] split;
        String pendingLine;
        int directiveSymbolIndex;
        if (dockerfileLines.size() > 0 && (directiveSymbolIndex = (pendingLine = dockerfileLines.get(0).trim()).indexOf("#")) >= 0 && (split = (directive = (contentAfterSymbol = pendingLine.substring(directiveSymbolIndex + 1, pendingLine.length())).trim()).split("=")).length == 2 && split[0].trim().equalsIgnoreCase("escape") && (escapeChar = split[1].trim()).length() > 0) {
            return escapeChar.charAt(0);
        }
        return '\\';
    }

    protected static List<String> getCleanedLines(List<String> dockerfileLines) throws PluginExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        boolean fromFound = false;
        for (String line : dockerfileLines) {
            int commentIndex;
            String pendingLine = line.trim();
            if (!fromFound) {
                if (pendingLine.startsWith("FROM")) {
                    fromFound = true;
                } else {
                    result.add(pendingLine);
                    continue;
                }
            }
            if ((commentIndex = pendingLine.indexOf("#")) >= 0) {
                String contentBeforeSymbol = pendingLine.substring(0, commentIndex);
                pendingLine = contentBeforeSymbol.trim();
            }
            if (pendingLine.isEmpty()) continue;
            result.add(pendingLine);
        }
        return result;
    }

    protected static List<String> getCombinedLines(List<String> dockerfileLines, char escape) throws PluginExecutionException {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < dockerfileLines.size()) {
            int j;
            String pendingLine = dockerfileLines.get(i).trim();
            for (j = i + 1; pendingLine.length() > 0 && !pendingLine.startsWith("#") && pendingLine.charAt(pendingLine.length() - 1) == escape && j < dockerfileLines.size(); ++j) {
                int multilineIndex = pendingLine.length() - 1;
                String contentBeforeSymbol = pendingLine.substring(0, multilineIndex);
                String nextLine = dockerfileLines.get(j);
                String combined = contentBeforeSymbol + nextLine;
                pendingLine = combined.trim();
            }
            result.add(pendingLine);
            i = j;
        }
        return result;
    }

    protected void removeWarFileLines(List<String> dockerfileLines) throws PluginExecutionException {
        ArrayList<String> warFileLines = new ArrayList<String>();
        for (String line : dockerfileLines) {
            String[] cmdSegments;
            String trimLine = line.trim();
            if (trimLine.startsWith("#") || !trimLine.toLowerCase().contains(".war") || !(cmdSegments = trimLine.split("#")[0].split("\\s+"))[0].equalsIgnoreCase("COPY") && !cmdSegments[0].equalsIgnoreCase("ADD")) continue;
            if (cmdSegments.length < 3) {
                throw new PluginExecutionException("Incorrect syntax on this line in the Dockerfile: '" + line + "'. There must be at least two arguments for the COPY or ADD command, a source path and a destination path.");
            }
            if (!cmdSegments[cmdSegments.length - 2].toLowerCase().endsWith(".war")) continue;
            warFileLines.add(line);
        }
        this.debug("WAR file lines: " + ((Object)warFileLines).toString());
        dockerfileLines.removeAll(warFileLines);
    }

    protected void disableOpenJ9SCC(List<String> dockerfileLines) {
        String RUN_CONFIGURE_COMMAND_LOWERCASE = "run configure.sh";
        for (int i = 0; i < dockerfileLines.size(); ++i) {
            String line = dockerfileLines.get(i);
            if (!line.toLowerCase().equals("run configure.sh")) continue;
            this.debug("Detected RUN configure.sh command.  Skipping OpenJ9 Shared Class Cache.");
            dockerfileLines.add(i, "ENV OPENJ9_SCC=false");
            return;
        }
    }

    protected void detectFeaturesSh(List<String> dockerfileLines) {
        this.shownFeaturesShWarning.set(false);
        String FEATURES_SH_COMMAND_LOWERCASE = "run features.sh";
        for (int i = 0; i < dockerfileLines.size(); ++i) {
            String line = dockerfileLines.get(i);
            if (!line.toLowerCase().equals("run features.sh")) continue;
            this.debug("Detected RUN features.sh command.");
            this.hasFeaturesSh.set(true);
            return;
        }
        this.debug("Did not find RUN features.sh command.");
        this.hasFeaturesSh.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCopyLines(List<String> dockerfileLines, String buildContext) throws PluginExecutionException {
        this.srcMount.clear();
        this.destMount.clear();
        for (String line : dockerfileLines) {
            String[] cmdSegments;
            String trimLine = line.trim();
            if (trimLine.startsWith("#") || !(cmdSegments = trimLine.split("#")[0].split("\\s+"))[0].equalsIgnoreCase("COPY") && !cmdSegments[0].equalsIgnoreCase("ADD")) continue;
            if (cmdSegments.length < 3) {
                throw new PluginExecutionException("Incorrect syntax on this line in the Dockerfile: '" + line + "'. There must be at least two arguments for the COPY or ADD command, a source path and a destination path.");
            }
            if (line.contains("$")) {
                this.warn("The Dockerfile line '" + line + "' will not be able to be hot deployed to the dev mode container. Dev mode does not currently support environment variables in COPY or ADD commands. If you make changes to files specified by this line, type 'r' and press Enter to rebuild the Docker image and restart the container.");
                continue;
            }
            ArrayList<String> srcOrDestArguments = new ArrayList<String>();
            boolean skipLine = false;
            for (int i = 1; i < cmdSegments.length; ++i) {
                String segment = cmdSegments[i];
                if (segment.startsWith("--from")) {
                    this.warn("The Dockerfile line '" + line + "' will not be able to be hot deployed to the dev mode container. Dev mode does not currently support hot deployment with multi-stage COPY commands.");
                    skipLine = true;
                    break;
                }
                if (segment.startsWith("--")) continue;
                srcOrDestArguments.add(segment);
            }
            if (skipLine) continue;
            if (srcOrDestArguments.size() < 2) {
                throw new PluginExecutionException("Incorrect syntax on this line in the Dockerfile: '" + line + "'. There must be at least two arguments for the COPY or ADD command, a source path and a destination path.");
            }
            String dest = (String)srcOrDestArguments.get(srcOrDestArguments.size() - 1);
            List srcArguments = srcOrDestArguments.subList(0, srcOrDestArguments.size() - 1);
            for (String src : srcArguments) {
                if (this.isURL(src)) {
                    this.debug("COPY/ADD do not watch/mount URL:" + src);
                    continue;
                }
                String sourcePath = buildContext + "/" + src;
                File sourceFile = new File(sourcePath);
                if (src.contains("*") || src.contains("?")) {
                    this.warn("The COPY or ADD source " + src + " in the Dockerfile line '" + line + "' will not be able to be hot deployed to the dev mode container. Dev mode does not currently support wildcards in the COPY or ADD commands. If you make changes to files specified by this line, type 'r' and press Enter to rebuild the Docker image and restart the container.");
                    continue;
                }
                if (sourceFile.isDirectory() || cmdSegments[0].equalsIgnoreCase("ADD")) {
                    Set<Path> set = this.dockerfileDirectoriesToWatch;
                    synchronized (set) {
                        try {
                            this.dockerfileDirectoriesToWatch.add(sourceFile.getCanonicalFile().toPath());
                            this.debug("COPY/ADD line=" + line + ", src=" + sourcePath + ", added to dockerfileDirectoriesToWatch: " + sourceFile);
                        }
                        catch (IOException e) {
                            this.error("Could not resolve the canonical path of the directory specified in the Dockerfile: " + sourcePath, e);
                        }
                        continue;
                    }
                }
                String destMountString = this.formatDestMount(dest, sourceFile);
                this.srcMount.add(sourcePath);
                this.destMount.add(destMountString);
                this.debug("COPY line=" + line + ", src=" + sourcePath + ", dest=" + destMountString);
            }
        }
    }

    private String formatDestMount(String destMountString, File srcMountFile) {
        if (destMountString.endsWith("/") || destMountString.endsWith("\\")) {
            destMountString = destMountString + srcMountFile.getName();
        }
        return destMountString;
    }

    private boolean isURL(String name) {
        try {
            URL uRL = new URL(name);
        }
        catch (MalformedURLException m) {
            return false;
        }
        return true;
    }

    protected File prepareTempDockerfile(File dockerfile) throws PluginExecutionException {
        List<String> dockerfileLines = this.readDockerfile(dockerfile);
        char escape = DevUtil.getEscapeCharacter(dockerfileLines);
        dockerfileLines = DevUtil.getCleanedLines(dockerfileLines);
        dockerfileLines = DevUtil.getCombinedLines(dockerfileLines, escape);
        this.removeWarFileLines(dockerfileLines);
        this.processCopyLines(dockerfileLines, dockerfile.getParent());
        this.detectFeaturesSh(dockerfileLines);
        this.disableOpenJ9SCC(dockerfileLines);
        for (String line : dockerfileLines) {
            this.debug(line);
        }
        File tempDockerfile = null;
        try {
            this.debug("Creating temp Dockerfile...");
            tempDockerfile = File.createTempFile("tempDockerfile", "");
            this.debug("temp Dockerfile: " + tempDockerfile);
            this.tempDockerfilePath = tempDockerfile.toPath();
            if (this.keepTempDockerfile) {
                this.info("Keeping temporary Dockerfile: " + this.tempDockerfilePath);
            } else {
                tempDockerfile.deleteOnExit();
            }
            Files.write(tempDockerfile.toPath(), dockerfileLines, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            this.error("Failed to create temp Dockerfile");
            throw new PluginExecutionException("Could not create temp Dockerfile: " + e.getMessage(), e);
        }
        return tempDockerfile;
    }

    private void buildDockerImage(File tempDockerfile, File userDockerfile, boolean pullParentImage) throws PluginExecutionException {
        try {
            this.info("Building Docker image...");
            this.imageName = this.getProjectName() + DEVMODE_IMAGE_SUFFIX;
            this.imageName = this.imageName.replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[\\-]+", "").toLowerCase();
            this.debug("Docker build context: " + userDockerfile.getParent());
            StringBuilder sb = new StringBuilder();
            sb.append("docker build ");
            if (pullParentImage) {
                sb.append("--pull ");
            }
            sb.append("-f " + tempDockerfile + " -t " + this.imageName + " " + userDockerfile.getParent());
            String buildCmd = sb.toString();
            this.info(buildCmd);
            if (this.hasFeaturesSh.get()) {
                this.info("The RUN features.sh command is detected in the Dockerfile and extra time may be necessary when installing features.");
            }
            long startTime = System.currentTimeMillis();
            this.execDockerCmdAndLog(this.getRunProcess(buildCmd), this.dockerBuildTimeout);
            this.checkDockerBuildTime(startTime, userDockerfile.getParentFile());
            this.info("Completed building Docker image.");
        }
        catch (IllegalThreadStateException e) {
            this.debug("IllegalThreadStateException, message=" + e.getMessage());
            throw new PluginExecutionException("The docker build command did not complete within the timeout period: " + this.dockerBuildTimeout + " seconds. Use the dockerBuildTimeout option to specify a longer period or add files not needed in the container to the .dockerignore file", e);
        }
        catch (IOException e) {
            this.error("Input or output error building Docker image: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            this.debug("Thread InterruptedException while building the Docker image: " + e.getMessage());
            throw new PluginExecutionException("Could not build Docker image using Dockerfile: " + userDockerfile.getAbsolutePath() + ". Address the following docker build error and then start dev mode again: " + e.getMessage(), e);
        }
        catch (RuntimeException r) {
            this.debug("RuntimeException building Docker image: " + r.getMessage());
            throw new PluginExecutionException("Could not build Docker image using Dockerfile: " + userDockerfile.getAbsolutePath() + ". Address the following docker build error and then start dev mode again: " + r.getMessage(), r);
        }
    }

    private void checkDockerBuildTime(long startTime, File dockerBuildContext) {
        if (System.currentTimeMillis() - startTime < 30000L) {
            return;
        }
        this.debug("checkDockerBuildTime, dockerBuildContext=" + dockerBuildContext.getAbsolutePath());
        File dockerIgnore = new File(dockerBuildContext, ".dockerignore");
        if (!dockerIgnore.exists()) {
            String buildContextPath;
            try {
                buildContextPath = dockerBuildContext.getCanonicalPath();
            }
            catch (IOException e) {
                buildContextPath = dockerBuildContext.getAbsolutePath();
            }
            this.warn("The docker build command took longer than 30 seconds. You may increase performance by adding unneeded files and directories such as any Liberty runtime directories to a .dockerignore file in " + buildContextPath + ".");
        }
    }

    private void startContainer() {
        try {
            if (OSUtil.isLinux()) {
                this.runCmd("mkdir -p " + this.serverDirectory + "/logs");
            }
            this.info("Starting Docker container...");
            String startContainerCommand = this.getContainerCommand();
            this.info(startContainerCommand);
            this.dockerRunProcess = this.getRunProcess(startContainerCommand);
            this.execDockerCmdAndLog(this.dockerRunProcess, 0);
        }
        catch (IOException e) {
            this.error("Error starting container: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            this.error("Thread was interrupted while starting the container: " + e.getMessage());
        }
        catch (RuntimeException r) {
            try {
                String dockerRmCmd = "docker container rm " + this.containerName;
                this.execDockerCmd(dockerRmCmd, 20);
            }
            catch (Exception e) {
                this.debug("Exception running docker container rm:", e);
            }
            throw r;
        }
    }

    private Process getRunProcess(String command) throws IOException {
        Map<String, String> env;
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
        processBuilder.command(this.getCommandTokens(command));
        if (!OSUtil.isLinux() && !(env = processBuilder.environment()).keySet().contains("DOCKER_BUILDKIT")) {
            env.put("DOCKER_BUILDKIT", "0");
            this.debug("Generating environment for docker build & run: DOCKER_BUILDKIT=0");
        }
        return processBuilder.start();
    }

    private void execDockerCmdAndLog(final Process startingProcess, int timeout) throws InterruptedException {
        Thread logCopyInputThread = new Thread(new Runnable(){

            @Override
            public void run() {
                DevUtil.this.copyStreamToBuildLog(startingProcess.getInputStream(), true);
            }
        });
        logCopyInputThread.start();
        final StringBuilder firstErrorLine = new StringBuilder();
        Thread logCopyErrorThread = new Thread(new Runnable(){

            @Override
            public void run() {
                firstErrorLine.append(DevUtil.this.copyStreamToBuildLog(startingProcess.getErrorStream(), false));
            }
        });
        logCopyErrorThread.start();
        if (timeout == 0) {
            startingProcess.waitFor();
        } else {
            startingProcess.waitFor(timeout, TimeUnit.SECONDS);
        }
        if (startingProcess.exitValue() != 0 && !this.devStop.get()) {
            if (startingProcess.exitValue() == 143) {
                this.setDevStop(true);
                this.externalContainerShutdown.set(true);
            }
            this.debug("Unexpected exit running docker command, return value=" + startingProcess.exitValue());
            String errorMessage = new String(firstErrorLine).trim() + " RC=" + startingProcess.exitValue();
            throw new RuntimeException(errorMessage);
        }
    }

    private String runCmd(String cmd) throws IOException, InterruptedException {
        String result = null;
        Process p = Runtime.getRuntime().exec(cmd);
        p.waitFor(5L, TimeUnit.SECONDS);
        if (p.exitValue() != 0) {
            this.error("Error running command:" + cmd + ", return value=" + p.exitValue());
        } else {
            result = this.readStdOut(p);
        }
        return result;
    }

    private String copyStreamToBuildLog(InputStream stream, boolean info) {
        String firstLine = null;
        BufferedReader inputReader = new BufferedReader(new InputStreamReader(stream));
        try {
            String line;
            while ((line = inputReader.readLine()) != null) {
                if (firstLine == null) {
                    firstLine = line;
                }
                if (info) {
                    this.info(line);
                    continue;
                }
                this.error(line);
                this.alertOnServerError(line, "JVMCFRE003", "Java classes were compiled with a higher version of Java than the JVM in the container. To resolve this issue, set the source and target Java versions in your Gradle build to correspond to the Java version used in your Dockerfile or its parent image, then restart dev mode.", "Java classes were compiled with a higher version of Java than the JVM in the container. To resolve this issue, set the source and target Java versions in your Maven build to correspond to the Java version used in your Dockerfile or its parent image, then clean the project output and restart dev mode.", false);
                if (this.serverFullyStarted.get() || this.hasFeaturesSh.get() || this.shownFeaturesShWarning.get()) continue;
                String errMsg = "Feature definitions were not found in the container. To install features to the container, specify 'RUN features.sh' in your Dockerfile. For an example of how to configure a Dockerfile, see https://github.com/OpenLiberty/ci.docker";
                this.shownFeaturesShWarning.set(this.alertOnServerError(line, "CWWKF0001E", errMsg, errMsg, true));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading container output: " + e.getMessage());
        }
        finally {
            try {
                inputReader.close();
            }
            catch (IOException iOException) {}
        }
        return firstLine;
    }

    private boolean alertOnServerError(String line, String errorCode, String gradleMessage, String mavenMessage, boolean warning) {
        if (this.container && line.contains(errorCode)) {
            if (this.gradle) {
                if (warning) {
                    this.warn("***** [ WARNING ] ***** " + gradleMessage);
                } else {
                    this.error("***** [ ERROR ] ***** " + gradleMessage);
                }
            } else if (warning) {
                this.warn(mavenMessage);
            } else {
                this.error(mavenMessage);
            }
            return true;
        }
        return false;
    }

    private String[] getCommandTokens(String command) {
        StringTokenizer stringTokenizer = new StringTokenizer(command);
        String[] commandTokens = new String[stringTokenizer.countTokens()];
        int i = 0;
        while (stringTokenizer.hasMoreTokens()) {
            commandTokens[i] = stringTokenizer.nextToken();
            ++i;
        }
        return commandTokens;
    }

    private void stopContainer() {
        try {
            this.serverFullyStarted.set(false);
            if (this.dockerRunProcess != null && this.dockerRunProcess.isAlive()) {
                this.info("Stopping container...");
                String dockerStopCmd = "docker stop " + this.containerName;
                this.debug("Stopping container " + this.containerName);
                this.execDockerCmd(dockerStopCmd, 40);
            }
        }
        catch (RuntimeException r) {
            this.error("Error stopping container: " + r.getMessage());
            throw r;
        }
        finally {
            this.dockerRunProcess = null;
        }
    }

    private String execDockerCmd(String command, int timeout) {
        return this.execDockerCmd(command, timeout, true);
    }

    private String getContainerCommand() {
        StringBuilder command = new StringBuilder("docker run --rm");
        if (!this.skipDefaultPorts) {
            int httpsPortToUse;
            int httpPortToUse;
            try {
                httpPortToUse = this.findAvailablePort(9080, false);
                httpsPortToUse = this.findAvailablePort(9443, false);
            }
            catch (IOException x) {
                this.error("An error occurred while trying to find an available network port. Using default port numbers.", x);
                httpPortToUse = 9080;
                httpsPortToUse = 9443;
            }
            command.append(" -p ").append(httpPortToUse).append(":").append(9080);
            command.append(" -p ").append(httpsPortToUse).append(":").append(9443);
        }
        if (this.libertyDebug) {
            int containerDebugPort;
            int hostDebugPort;
            try {
                if (this.alternativeDebugPort == -1) {
                    hostDebugPort = this.findAvailablePort(this.libertyDebugPort, true);
                    containerDebugPort = this.libertyDebugPort;
                } else {
                    containerDebugPort = hostDebugPort = this.alternativeDebugPort;
                }
            }
            catch (IOException x) {
                containerDebugPort = hostDebugPort = this.libertyDebugPort;
            }
            command.append(" -p " + hostDebugPort + ":" + containerDebugPort);
            command.append(" -e WLP_DEBUG_SUSPEND=n -e WLP_DEBUG_ADDRESS=" + containerDebugPort);
        }
        command.append(" -v " + this.buildDirectory + "/" + DEVC_HIDDEN_FOLDER + "/apps:/config/apps");
        command.append(" -v " + this.buildDirectory + "/" + DEVC_HIDDEN_FOLDER + "/dropins:/config/dropins");
        command.append(" -v " + this.projectDirectory.getAbsolutePath() + ":" + DEVMODE_DIR_NAME);
        command.append(" -v " + this.serverDirectory.getAbsolutePath() + "/logs:/logs");
        command.append(" -v " + this.mavenCacheLocation + ":/devmode-maven-cache");
        command.append(this.getCopiedFiles());
        command.append(this.getUserId());
        String name = this.getDockerOption("--name");
        if (name == null || name.isEmpty()) {
            if (name != null && name.isEmpty()) {
                this.error("The Docker option --name is specified with an unsupported value: empty string.");
            }
            this.containerName = this.generateNewContainerName();
            command.append(" --name " + this.containerName);
        } else {
            this.containerName = name;
        }
        this.debug("containerName: " + this.containerName + ".");
        if (this.dockerRunOpts != null) {
            command.append(" " + this.dockerRunOpts);
        }
        command.append(" " + this.imageName);
        command.append(" /opt/ol/wlp/bin/server" + (this.libertyDebug ? " debug " : " run ") + "defaultServer");
        command.append(" -- --io.openliberty.tools.projectRoot=/devmode");
        return command.toString();
    }

    private String getDockerOption(String optionName) {
        if (this.dockerRunOpts == null || this.dockerRunOpts.isEmpty()) {
            return null;
        }
        String[] options = this.dockerRunOpts.split("\\s+");
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals(optionName)) {
                return i < options.length - 1 ? options[i + 1] : null;
            }
            if (!options[i].startsWith(optionName + "=")) continue;
            return options[i].substring(optionName.length() + 1);
        }
        return null;
    }

    private String generateNewContainerName() {
        String dockerContNamesCmd = "docker ps -a --format \"{{.Names}}\"";
        this.debug("docker container names list command: " + dockerContNamesCmd);
        String result = this.execDockerCmd(dockerContNamesCmd, 20);
        if (result == null) {
            return DEVMODE_CONTAINER_BASE_NAME;
        }
        String[] containerNames = result.split(" ");
        int highestNum = -1;
        for (int i = 0; i < containerNames.length; ++i) {
            String[] nameSegments;
            String name = DevUtil.removeSurroundingQuotes(containerNames[i]);
            int num = -1;
            if (name.equals(DEVMODE_CONTAINER_BASE_NAME)) {
                num = 0;
            } else if (name.startsWith("liberty-dev-") && (nameSegments = name.split("-")).length == 3) {
                String lastSegment = nameSegments[nameSegments.length - 1];
                try {
                    num = Integer.parseInt(lastSegment);
                }
                catch (NumberFormatException e) {
                    this.debug("Last segment of container name is not a number.");
                }
            }
            if (num <= highestNum) continue;
            highestNum = num;
        }
        return DEVMODE_CONTAINER_BASE_NAME + (highestNum != -1 ? "-" + ++highestNum : "");
    }

    private String[] getContainerNetworks(String contName) {
        String dockerNetworkCmd = "docker inspect -f '{{.NetworkSettings.Networks}}' " + contName;
        String cmdResult = this.execDockerCmd(dockerNetworkCmd, 20, false);
        if (cmdResult == null || cmdResult.contains(" RC=")) {
            this.warn("Unable to retrieve container networks.");
            return null;
        }
        return DevUtil.parseNetworks(DevUtil.removeSurroundingQuotes(cmdResult.trim()));
    }

    protected static String[] parseNetworks(String dockerResult) {
        if (!dockerResult.matches("map\\[(.*?)\\]")) {
            return null;
        }
        String networkMap = dockerResult.substring(dockerResult.indexOf("[") + 1, dockerResult.indexOf("]"));
        String[] networkHex = networkMap.split(" ");
        String[] networks = new String[networkHex.length];
        for (int i = 0; i < networkHex.length; ++i) {
            networks[i] = networkHex[i].split(":")[0];
        }
        return networks;
    }

    private String getContainerIPAddress(String contName, String network) {
        String dockerIPAddressCmd = "docker inspect -f '{{.NetworkSettings.Networks." + network + ".IPAddress}}' " + contName;
        String result = this.execDockerCmd(dockerIPAddressCmd, 20, false);
        if (result == null || result.contains(" RC=")) {
            this.warn("Unable to retrieve container IP address for network '" + network + "'.");
            return "<no value>";
        }
        return DevUtil.removeSurroundingQuotes(result.trim());
    }

    protected static String removeSurroundingQuotes(String str) {
        if (str != null && str.length() >= 2 && (str.startsWith("\"") && str.endsWith("\"") || str.startsWith("'") && str.endsWith("'"))) {
            return str.substring(1, str.length() - 1);
        }
        return str;
    }

    private String getCopiedFiles() {
        StringBuilder param = new StringBuilder(256);
        for (int i = 0; i < this.srcMount.size(); ++i) {
            if (new File(this.srcMount.get(i)).exists()) {
                param.append(" -v ").append(this.srcMount.get(i)).append(":").append(this.destMount.get(i));
                continue;
            }
            this.error("A file referenced by the Dockerfile is not found: " + this.srcMount.get(i) + ". Update the Dockerfile or ensure the file is in the correct location.");
        }
        return param.toString();
    }

    private String getUserId() {
        if (OSUtil.isLinux()) {
            try {
                String id = this.runCmd("id -u");
                if (id != null) {
                    return " --user " + id;
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "";
    }

    public abstract void libertyCreate() throws PluginExecutionException;

    public abstract void libertyDeploy() throws PluginExecutionException;

    public abstract void libertyInstallFeature() throws PluginExecutionException;

    public void restartServer() throws PluginExecutionException {
        this.restartServer(false);
    }

    public void restartServer(boolean buildContainer) throws PluginExecutionException {
        this.info("Restarting server...");
        this.setDevStop(true);
        if (this.container) {
            this.stopContainer();
        } else {
            this.stopServer();
            if (this.serverThread != null) {
                long threadShutdownTimeoutSeconds = 30L;
                try {
                    this.serverThread.join(30000L);
                    if (this.serverThread.isAlive()) {
                        throw new PluginExecutionException("Could not stop the server after 30 seconds.  Ensure that the server has been stopped, then start dev mode again.");
                    }
                }
                catch (InterruptedException e) {
                    if (this.serverThread.isAlive()) {
                        throw new PluginExecutionException("Could not stop the server.  Ensure that the server has been stopped, then start dev mode again.", e);
                    }
                    this.debug(e);
                }
            }
        }
        System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.TRUE.toString());
        this.libertyCreate();
        if (!this.container) {
            this.libertyInstallFeature();
        }
        this.libertyDeploy();
        this.startServer(buildContainer, false);
        this.setDevStop(false);
        this.info("The server has been restarted.");
        this.printDevModeMessages(this.inputUnavailable.get(), true);
    }

    private void parseHostNameAndPorts(ServerTask serverTask, File messagesLogFile) throws PluginExecutionException {
        List listeningOnPortMessages;
        String webAppMessage = serverTask.findStringInFile(WEB_APP_AVAILABLE_MESSAGE_PREFIX, messagesLogFile);
        this.debug("Web app available message: " + webAppMessage);
        if (webAppMessage != null) {
            int portPrefixIndex = this.parseHostName(webAppMessage);
            this.parseHttpPort(webAppMessage, portPrefixIndex);
        }
        if ((listeningOnPortMessages = serverTask.findStringsInFile(LISTENING_ON_PORT_MESSAGE_PREFIX, messagesLogFile)) != null) {
            this.parseHttpsPort(listeningOnPortMessages);
        }
    }

    protected int parseHostName(String webAppMessage) throws PluginExecutionException {
        int protocolIndex = webAppMessage.indexOf(HTTP_PREFIX);
        int hostNameIndex = protocolIndex + HTTP_PREFIX.length();
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTP_PREFIX_ESCAPED);
            hostNameIndex = protocolIndex + HTTP_PREFIX_ESCAPED.length();
        }
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTPS_PREFIX);
            hostNameIndex = protocolIndex + HTTPS_PREFIX.length();
        }
        if (protocolIndex < 0) {
            protocolIndex = webAppMessage.indexOf(HTTPS_PREFIX_ESCAPED);
            hostNameIndex = protocolIndex + HTTPS_PREFIX_ESCAPED.length();
        }
        if (protocolIndex < 0) {
            throw new PluginExecutionException("Could not parse the host name from the log message: " + webAppMessage);
        }
        int portPrefixIndex = webAppMessage.indexOf(":", hostNameIndex);
        if (portPrefixIndex < 0) {
            throw new PluginExecutionException("Could not parse the port number from the log message: " + webAppMessage);
        }
        this.hostName = this.container ? "localhost" : webAppMessage.substring(hostNameIndex, portPrefixIndex);
        this.debug("Parsed host name: " + this.hostName);
        return portPrefixIndex;
    }

    protected void parseHttpPort(String webAppMessage, int portPrefixIndex) {
        if (!webAppMessage.contains(HTTP_PREFIX)) {
            return;
        }
        int portIndex = portPrefixIndex + 1;
        int portEndIndex = webAppMessage.indexOf("/", portIndex);
        if (portEndIndex < 0) {
            portEndIndex = webAppMessage.length();
        }
        String parsedHttpPort = webAppMessage.substring(portIndex, portEndIndex);
        this.debug("Parsed http port: " + parsedHttpPort);
        if (this.container) {
            this.httpPort = this.findLocalPort(parsedHttpPort);
            this.containerHttpPort = parsedHttpPort;
        } else {
            this.httpPort = parsedHttpPort;
        }
    }

    protected void parseHttpsPort(List<String> messages) throws PluginExecutionException {
        for (String message : messages) {
            String[] messageTokens;
            this.debug("Looking for https port in message: " + message);
            String httpsMessageContents = message.split(LISTENING_ON_PORT_MESSAGE_PREFIX)[1];
            for (String token : messageTokens = httpsMessageContents.split(" ")) {
                if (!token.contains("-ssl")) continue;
                String parsedHttpsPort = this.getPortFromMessageTokens(messageTokens);
                if (parsedHttpsPort != null) {
                    this.debug("Parsed https port: " + parsedHttpsPort);
                    if (this.container) {
                        this.httpsPort = this.findLocalPort(parsedHttpsPort);
                        this.containerHttpsPort = parsedHttpsPort;
                    } else {
                        this.httpsPort = parsedHttpsPort;
                    }
                    return;
                }
                throw new PluginExecutionException("Could not parse the https port number from the log message: " + message);
            }
        }
        this.debug("Could not find https port. The server might not be configured for https.");
    }

    private String getPortFromMessageTokens(String[] messageTokens) throws PluginExecutionException {
        for (int i = messageTokens.length - 1; i >= 0; --i) {
            String numericToken = messageTokens[i].replaceAll("[^\\d]", "");
            if (numericToken.length() <= 0) continue;
            try {
                int parsedPort = Integer.parseInt(numericToken);
                if (parsedPort > 65535) continue;
                return numericToken;
            }
            catch (NumberFormatException e) {
                this.debug("Could not parse integer from numeric token " + numericToken + " from message token " + messageTokens[i], e);
            }
        }
        return null;
    }

    private String findLocalPort(String internalContainerPort) {
        String dockerPortCmd = "docker port " + this.containerName + " " + internalContainerPort;
        String cmdResult = this.execDockerCmd(dockerPortCmd, 20, false);
        if (cmdResult == null) {
            this.warn("Unable to retrieve locally mapped port.");
            return null;
        }
        if (cmdResult.contains(" RC=")) {
            this.warn("Unable to retrieve locally mapped port. Docker result: \"" + cmdResult.split(" RC=")[0] + "\". Ensure the Docker ports are mapped correctly.");
            return null;
        }
        String[] cmdResultSplit = cmdResult.split(":");
        String localPort = cmdResultSplit[cmdResultSplit.length - 1].trim();
        this.debug("Local port: " + localPort);
        return localPort;
    }

    public void cleanUpServerEnv() {
        block5: {
            try {
                File serverEnvBackup = new File(this.serverDirectory.getCanonicalPath() + "/server.env.bak");
                File serverEnvFile = new File(this.serverDirectory.getCanonicalPath() + "/server.env");
                if (serverEnvBackup.exists()) {
                    try {
                        Files.copy(serverEnvBackup.toPath(), serverEnvFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        this.error("Could not restore server.env: " + e.getMessage());
                    }
                    serverEnvBackup.delete();
                    break block5;
                }
                serverEnvFile.delete();
            }
            catch (IOException e) {
                this.error("Could not retrieve server.env: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempConfig() {
        File tempConfig;
        if (this.tempConfigPath != null && (tempConfig = this.tempConfigPath.toFile()).exists()) {
            try {
                FileUtils.deleteDirectory((File)tempConfig);
                this.debug("Successfully deleted liberty:dev temporary configuration folder");
            }
            catch (IOException e) {
                this.warn("Could not delete liberty:dev temporary configuration folder: " + e.getMessage());
            }
        }
    }

    public void cleanUpTempDockerfile() {
        File tempDockerfile;
        if (!this.keepTempDockerfile && this.tempDockerfilePath != null && (tempDockerfile = this.tempDockerfilePath.toFile()).exists()) {
            try {
                Files.delete(this.tempDockerfilePath);
                this.debug("Successfully deleted dev mode temporary Dockerfile");
            }
            catch (IOException e) {
                this.warn("Could not delete dev mode temporary Dockerfile: " + e.getMessage());
            }
        }
    }

    public void setDevStop(boolean devStop) {
        this.devStop.set(devStop);
    }

    public void addShutdownHook(final ThreadPoolExecutor executor) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                DevUtil.this.runShutdownHook(executor);
            }
        });
    }

    private void runShutdownHook(ThreadPoolExecutor executor) {
        if (!this.calledShutdownHook.getAndSet(true)) {
            if (this.trackingMode == FileTrackMode.POLLING || this.trackingMode == FileTrackMode.NOT_SET) {
                this.disablePolling();
            }
            this.setDevStop(true);
            this.cleanUpTempConfig();
            this.cleanUpServerEnv();
            if (this.hotkeyReader != null) {
                this.hotkeyReader.shutdown();
            }
            executor.shutdown();
            if (this.container) {
                this.cleanUpTempDockerfile();
                this.stopContainer();
            } else {
                this.stopServer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disablePolling() {
        Set<FileAlterationObserver> set = this.newFileObservers;
        synchronized (set) {
            this.consolidateFileObservers();
            for (FileAlterationObserver observer : this.fileObservers) {
                try {
                    observer.destroy();
                }
                catch (Exception e) {
                    this.debug("Could not destroy file observer", e);
                }
            }
        }
    }

    public Map<String, String> getDebugEnvironmentVariables() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("WLP_DEBUG_SUSPEND", "n");
        map.put("WLP_DEBUG_ADDRESS", String.valueOf(this.findAvailablePort(this.libertyDebugPort, true)));
        return map;
    }

    public void enableServerDebug() throws IOException {
        this.enableServerDebug(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableServerDebug(boolean doFindPort) throws IOException {
        if (!this.libertyDebug) {
            return;
        }
        String serverEnvPath = this.serverDirectory.getCanonicalPath() + "/server.env";
        File serverEnvFile = new File(serverEnvPath);
        StringBuilder sb = new StringBuilder();
        File serverEnvBackup = new File(serverEnvPath + ".bak");
        if (serverEnvFile.exists()) {
            this.debug("server.env already exists");
            Files.copy(serverEnvFile.toPath(), serverEnvBackup.toPath(), StandardCopyOption.REPLACE_EXISTING);
            boolean deleted = serverEnvFile.delete();
            if (!deleted) {
                this.error("Could not move existing server.env file");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(serverEnvBackup));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                    sb.append("\n");
                }
            }
        } else {
            serverEnvBackup.delete();
        }
        this.debug("Creating server.env file: " + serverEnvFile.getCanonicalPath());
        sb.append("WLP_DEBUG_SUSPEND=n\n");
        sb.append("WLP_DEBUG_ADDRESS=");
        if (doFindPort) {
            sb.append(this.findAvailablePort(this.libertyDebugPort, true));
        } else {
            sb.append(this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort);
        }
        sb.append("\n");
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(serverEnvFile));){
            writer.write(sb.toString());
        }
        if (serverEnvFile.exists()) {
            this.debug("Successfully created liberty:dev server.env file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int findAvailablePort(int preferredPort, boolean isDebugPort) throws IOException {
        int portToTry = preferredPort;
        if (isDebugPort && this.alternativeDebugPort != -1) {
            portToTry = this.alternativeDebugPort;
        }
        ServerSocket serverSocket = null;
        while (portToTry < 65535) {
            if (OSUtil.isWindows()) {
                try {
                    serverSocket = new ServerSocket(portToTry);
                    int n = serverSocket.getLocalPort();
                    return n;
                }
                catch (IOException e) {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                    if (isDebugPort) {
                        serverSocket = new ServerSocket(0);
                        int availablePort = serverSocket.getLocalPort();
                        this.processAvailableDebugPort(preferredPort, portToTry, availablePort);
                        int n = availablePort;
                        return n;
                    }
                    this.debug("findAvailablePort found port is in use: " + portToTry);
                    ++portToTry;
                    continue;
                }
                finally {
                    if (serverSocket != null) {
                        serverSocket.close();
                    }
                    continue;
                }
            }
            try {
                serverSocket = new ServerSocket();
                serverSocket.setReuseAddress(false);
                serverSocket.bind(new InetSocketAddress(InetAddress.getByName(null), portToTry), 1);
                int e = serverSocket.getLocalPort();
                return e;
            }
            catch (IOException e) {
                if (serverSocket != null) {
                    if (isDebugPort) {
                        serverSocket.bind(null, 1);
                        int availablePort = serverSocket.getLocalPort();
                        this.processAvailableDebugPort(preferredPort, portToTry, availablePort);
                        int n = availablePort;
                        return n;
                    }
                    this.debug("findAvailablePort found port is in use: " + portToTry);
                    ++portToTry;
                    continue;
                }
                throw new IOException("Could not create a server socket.", e);
            }
            finally {
                if (serverSocket == null) continue;
                serverSocket.close();
            }
        }
        return preferredPort;
    }

    private void processAvailableDebugPort(int preferredPort, int portToTry, int availablePort) {
        if (portToTry == preferredPort) {
            this.warn("The debug port " + preferredPort + " is not available.  Using " + availablePort + " as the debug port instead.");
        } else {
            this.debug("The previous debug port " + this.alternativeDebugPort + " is no longer available.  Using " + availablePort + " as the debug port instead.");
        }
        this.alternativeDebugPort = availablePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runHotkeyReaderThread(ThreadPoolExecutor executor) {
        if (this.inputUnavailable.get()) {
            return;
        }
        boolean startedNewHotkeyReader = false;
        if (this.hotkeyReader == null) {
            this.hotkeyReader = new HotkeyReader(executor);
            new Thread(this.hotkeyReader).start();
            this.debug("Started hotkey reader.");
            startedNewHotkeyReader = true;
        }
        if (!this.skipTests) {
            AtomicBoolean atomicBoolean = this.inputUnavailable;
            synchronized (atomicBoolean) {
                try {
                    if (startedNewHotkeyReader) {
                        this.inputUnavailable.wait(500L);
                    }
                    this.printDevModeMessages(this.inputUnavailable.get(), this.firstStartup);
                    this.firstStartup = false;
                }
                catch (InterruptedException e) {
                    this.debug("Interrupted while waiting to determine whether input can be read", e);
                }
            }
        }
    }

    private void printDevModeMessages(boolean inputUnavailable, boolean startup) {
        String message;
        if (startup) {
            this.info(this.formatAttentionBarrier());
            this.info(this.formatAttentionTitle("Liberty is running in dev mode."));
        }
        if (!inputUnavailable) {
            if (this.hotTests) {
                message = "Tests will run automatically when changes are detected. You can also press the Enter key to run tests on demand.";
                this.info(startup ? this.formatAttentionMessage(message) : message);
            } else {
                message = "To run tests on demand, press Enter.";
                this.info(startup ? this.formatAttentionMessage(message) : message);
            }
            if (startup) {
                if (this.container) {
                    this.info(this.formatAttentionMessage("To rebuild the Docker image and restart the container, type 'r' and press Enter."));
                } else {
                    this.info(this.formatAttentionMessage("To restart the server, type 'r' and press Enter."));
                }
                this.info(this.formatAttentionMessage("To stop the server and quit dev mode, press Ctrl-C or type 'q' and press Enter."));
            }
        } else {
            this.debug("Cannot read user input, setting hotTests to true.");
            message = "Tests will run automatically when changes are detected.";
            this.info(startup ? this.formatAttentionMessage(message) : message);
            this.hotTests = true;
        }
        if (startup) {
            if (this.container) {
                boolean nonDefaultDebugPortUsed;
                boolean nonDefaultHttpPortUsed = !this.skipDefaultPorts && !String.valueOf(9080).equals(this.httpPort);
                boolean nonDefaultHttpsPortUsed = !this.skipDefaultPorts && !String.valueOf(9443).equals(this.httpsPort);
                boolean bl = nonDefaultDebugPortUsed = this.alternativeDebugPort != -1;
                if (this.containerHttpPort != null || this.containerHttpsPort != null || this.libertyDebug) {
                    this.info(this.formatAttentionMessage(""));
                    this.info(this.formatAttentionTitle("Liberty container port information:"));
                }
                if (this.containerHttpPort != null && this.httpPort != null && nonDefaultHttpPortUsed || this.containerHttpsPort != null && this.httpsPort != null && nonDefaultHttpsPortUsed || this.libertyDebug && nonDefaultDebugPortUsed) {
                    this.warn(this.formatAttentionMessage("The Liberty container is using non-default host ports to avoid port conflict errors."));
                }
                if (this.containerHttpPort != null) {
                    if (this.httpPort != null) {
                        if (!nonDefaultHttpPortUsed) {
                            this.info(this.formatAttentionMessage("Internal container HTTP port [ " + this.containerHttpPort + " ] is mapped to Docker host port [ " + this.httpPort + " ]"));
                        } else {
                            this.info(this.formatAttentionMessage("Internal container HTTP port [ " + this.containerHttpPort + " ] is mapped to Docker host port [ " + this.httpPort + " ] <"));
                        }
                    } else {
                        this.info(this.formatAttentionMessage("Internal container HTTP port: [ " + this.containerHttpPort + " ]"));
                    }
                }
                if (this.containerHttpsPort != null) {
                    if (this.httpsPort != null) {
                        if (!nonDefaultHttpsPortUsed) {
                            this.info(this.formatAttentionMessage("Internal container HTTPS port [ " + this.containerHttpsPort + " ] is mapped to Docker host port [ " + this.httpsPort + " ]"));
                        } else {
                            this.info(this.formatAttentionMessage("Internal container HTTPS port [ " + this.containerHttpsPort + " ] is mapped to Docker host port [ " + this.httpsPort + " ] <"));
                        }
                    } else {
                        this.info(this.formatAttentionMessage("Internal container HTTPS port: [ " + this.containerHttpsPort + " ]"));
                    }
                }
                if (this.libertyDebug) {
                    int debugPort;
                    int n = debugPort = this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort;
                    if (!nonDefaultDebugPortUsed) {
                        this.info(this.formatAttentionMessage("Liberty debug port mapped to Docker host port: [ " + debugPort + " ]"));
                    } else {
                        this.info(this.formatAttentionMessage("Liberty debug port mapped to Docker host port: [ " + debugPort + " ] <"));
                    }
                }
                this.info(this.formatAttentionMessage(""));
                this.info(this.formatAttentionTitle("Docker network information:"));
                this.info(this.formatAttentionMessage("Container name: [ " + this.containerName + " ]"));
                String[] networks = this.getContainerNetworks(this.containerName);
                if (networks != null) {
                    for (String network : networks) {
                        this.info(this.formatAttentionMessage("IP address [ " + this.getContainerIPAddress(this.containerName, network) + " ] on Docker network [ " + network + " ]"));
                    }
                }
            } else {
                if (this.httpPort != null || this.httpsPort != null || this.libertyDebug) {
                    this.info(this.formatAttentionMessage(""));
                    this.info(this.formatAttentionTitle("Liberty server port information:"));
                }
                if (this.httpPort != null) {
                    this.info(this.formatAttentionMessage("Liberty server HTTP port: [ " + this.httpPort + " ]"));
                }
                if (this.httpsPort != null) {
                    this.info(this.formatAttentionMessage("Liberty server HTTPS port: [ " + this.httpsPort + " ]"));
                }
                if (this.libertyDebug) {
                    int debugPort = this.alternativeDebugPort == -1 ? this.libertyDebugPort : this.alternativeDebugPort;
                    this.info(this.formatAttentionMessage("Liberty debug port: [ " + debugPort + " ]"));
                }
            }
            this.info(this.formatAttentionBarrier());
        }
    }

    private String formatAttentionBarrier() {
        return "************************************************************************";
    }

    private String formatAttentionTitle(String message) {
        return "*    " + message;
    }

    private String formatAttentionMessage(String message) {
        return "*        " + message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchFiles(File buildFile, File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, List<String> artifactPaths, File serverXmlFile, File bootstrapPropertiesFile, File jvmOptionsFile) throws Exception {
        this.buildFile = buildFile;
        this.outputDirectory = outputDirectory;
        this.serverXmlFile = serverXmlFile;
        this.bootstrapPropertiesFile = bootstrapPropertiesFile;
        this.jvmOptionsFile = jvmOptionsFile;
        this.artifactPaths = artifactPaths;
        this.dockerfileUsed = null;
        try {
            this.watcher = FileSystems.getDefault().newWatchService();
            this.serverXmlFileParent = null;
            if (serverXmlFile != null && serverXmlFile.exists()) {
                this.serverXmlFileParent = serverXmlFile.getParentFile();
            }
            this.bootstrapPropertiesFileParent = null;
            if (bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists()) {
                this.bootstrapPropertiesFileParent = bootstrapPropertiesFile.getParentFile();
            }
            this.jvmOptionsFileParent = null;
            if (jvmOptionsFile != null && jvmOptionsFile.exists()) {
                this.jvmOptionsFileParent = jvmOptionsFile.getParentFile();
            }
            Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
            Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
            Path configPath = this.configDirectory.getCanonicalFile().toPath();
            boolean sourceDirRegistered = false;
            boolean testSourceDirRegistered = false;
            boolean configDirRegistered = false;
            boolean serverXmlFileRegistered = false;
            boolean bootstrapPropertiesFileRegistered = false;
            boolean jvmOptionsFileRegistered = false;
            if (this.sourceDirectory.exists()) {
                this.registerAll(srcPath, executor);
                sourceDirRegistered = true;
            }
            if (this.testSourceDirectory.exists()) {
                this.registerAll(testSrcPath, executor);
                testSourceDirRegistered = true;
            }
            if (this.configDirectory.exists()) {
                this.registerAll(configPath, executor);
                configDirRegistered = true;
            }
            if (serverXmlFile != null && serverXmlFile.exists() && this.serverXmlFileParent.exists()) {
                Path serverXmlFilePath = this.serverXmlFileParent.getCanonicalFile().toPath();
                this.registerAll(serverXmlFilePath, executor);
                serverXmlFileRegistered = true;
            }
            if (bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists() && this.bootstrapPropertiesFileParent.exists()) {
                Path bootstrapPropertiesFilePath = this.bootstrapPropertiesFileParent.getCanonicalFile().toPath();
                this.registerAll(bootstrapPropertiesFilePath, executor);
                bootstrapPropertiesFileRegistered = true;
            }
            if (jvmOptionsFile != null && jvmOptionsFile.exists() && this.jvmOptionsFileParent.exists()) {
                Path jvmOptionsFilePath = this.jvmOptionsFileParent.getCanonicalFile().toPath();
                this.registerAll(jvmOptionsFilePath, executor);
                jvmOptionsFileRegistered = true;
            }
            if (this.container) {
                this.dockerfileUsed = this.getDockerfile();
                this.registerSingleFile(this.dockerfileUsed, executor);
            }
            HashMap<File, Boolean> resourceMap = new HashMap<File, Boolean>();
            for (File file : this.resourceDirs) {
                resourceMap.put(file, false);
                if (!file.exists()) continue;
                this.registerAll(file.getCanonicalFile().toPath(), executor);
                resourceMap.put(file, true);
            }
            this.registerSingleFile(buildFile, executor);
            if (this.propertyFilesMap != null) {
                for (File file : this.propertyFilesMap.keySet()) {
                    this.registerSingleFile(file, executor);
                }
            }
            this.initWatchLoop();
            while (true) {
                Object object;
                this.checkStopDevMode(true);
                if (this.container) {
                    object = this.dockerfileDirectoriesToWatch;
                    synchronized (object) {
                        if (!this.dockerfileDirectoriesToWatch.isEmpty()) {
                            for (Path path : this.dockerfileDirectoriesToWatch) {
                                File f = path.toFile();
                                if (f.isDirectory()) {
                                    this.debug("Registering path from dockerfileDirectoriesToWatch: " + path);
                                    this.registerAll(path, executor, true);
                                } else {
                                    this.debug("Registering file path from dockerfileDirectoriesToWatch: " + path);
                                    this.registerSingleFile(f, executor, true);
                                }
                                this.dockerfileDirectoriesTracked.add(path);
                            }
                            this.dockerfileDirectoriesToWatch.clear();
                        }
                    }
                }
                this.processJavaCompilation(outputDirectory, testOutputDirectory, executor, artifactPaths);
                if (!sourceDirRegistered && this.sourceDirectory.exists() && this.sourceDirectory.listFiles().length > 0) {
                    this.compile(this.sourceDirectory);
                    this.registerAll(srcPath, executor);
                    this.debug("Registering Java source directory: " + this.sourceDirectory);
                    sourceDirRegistered = true;
                } else if (sourceDirRegistered && !this.sourceDirectory.exists()) {
                    this.cleanTargetDir(outputDirectory);
                    sourceDirRegistered = false;
                }
                if (!testSourceDirRegistered && this.testSourceDirectory.exists() && this.testSourceDirectory.listFiles().length > 0) {
                    this.compile(this.testSourceDirectory);
                    this.registerAll(testSrcPath, executor);
                    this.debug("Registering Java test directory: " + this.testSourceDirectory);
                    this.runTestThread(false, executor, -1, false, false);
                    testSourceDirRegistered = true;
                } else if (testSourceDirRegistered && !this.testSourceDirectory.exists()) {
                    this.cleanTargetDir(testOutputDirectory);
                    testSourceDirRegistered = false;
                }
                if (!configDirRegistered && this.configDirectory.exists()) {
                    configDirRegistered = true;
                    if (serverXmlFile != null && !serverXmlFile.exists()) {
                        this.registerAll(configPath, executor);
                        this.debug("Registering configuration directory: " + this.configDirectory);
                    } else {
                        this.warn("The server configuration directory " + this.configDirectory + " has been added. Restart dev mode for it to take effect.");
                    }
                }
                if (!serverXmlFileRegistered && serverXmlFile != null && serverXmlFile.exists()) {
                    serverXmlFileRegistered = true;
                    this.debug("Server configuration file has been added: " + serverXmlFile);
                    this.warn("The server configuration file " + serverXmlFile + " has been added. Restart dev mode for it to take effect.");
                }
                if (!bootstrapPropertiesFileRegistered && bootstrapPropertiesFile != null && bootstrapPropertiesFile.exists()) {
                    bootstrapPropertiesFileRegistered = true;
                    this.debug("Bootstrap properties file has been added: " + bootstrapPropertiesFile);
                    this.warn("The bootstrap properties file " + bootstrapPropertiesFile + " has been added. Restart dev mode for it to take effect.");
                }
                if (!jvmOptionsFileRegistered && jvmOptionsFile != null && jvmOptionsFile.exists()) {
                    jvmOptionsFileRegistered = true;
                    this.debug("JVM Options file has been added: " + jvmOptionsFile);
                    this.warn("The JVM Options file " + jvmOptionsFile + " has been added. Restart dev mode for it to take effect.");
                }
                for (File file : this.resourceDirs) {
                    if (!((Boolean)resourceMap.get(file)).booleanValue() && file.exists()) {
                        this.registerAll(file.getCanonicalFile().toPath(), executor);
                        resourceMap.put(file, true);
                        continue;
                    }
                    if (!((Boolean)resourceMap.get(file)).booleanValue() || file.exists()) continue;
                    this.warn("The resource directory " + file + " was deleted.  Restart liberty:dev mode for it to take effect.");
                    resourceMap.put(file, false);
                }
                if (this.trackingMode == FileTrackMode.FILE_WATCHER || this.trackingMode == FileTrackMode.NOT_SET) {
                    try {
                        WatchKey wk = this.watcher.poll(100L, TimeUnit.MILLISECONDS);
                        Watchable watchable = wk.watchable();
                        Path directory = (Path)watchable;
                        List<WatchEvent<?>> events = wk.pollEvents();
                        for (WatchEvent<?> event : events) {
                            if (this.trackingMode == FileTrackMode.NOT_SET) {
                                this.trackingMode = FileTrackMode.FILE_WATCHER;
                                this.disablePolling();
                            }
                            Path changed = (Path)event.context();
                            this.debug("Processing events for watched directory: " + directory);
                            File fileChanged = new File(directory.toString(), changed.toString());
                            if (this.ignoreFileOrDir(fileChanged)) continue;
                            this.debug("Changed: " + changed + "; " + event.kind());
                            ChangeType changeType = null;
                            if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                                changeType = ChangeType.CREATE;
                            } else if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                                changeType = ChangeType.MODIFY;
                            } else if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                                changeType = ChangeType.DELETE;
                            }
                            this.processFileChanges(executor, fileChanged, outputDirectory, false, changeType);
                        }
                        boolean valid = wk.reset();
                        if (!valid) {
                            this.debug("WatchService key has been unregistered for " + directory);
                        }
                    }
                    catch (InterruptedException | NullPointerException exception) {
                        // empty catch block
                    }
                }
                if (this.trackingMode != FileTrackMode.POLLING && this.trackingMode != FileTrackMode.NOT_SET) continue;
                object = this.newFileObservers;
                synchronized (object) {
                    this.consolidateFileObservers();
                }
                for (FileAlterationObserver fileAlterationObserver : this.fileObservers) {
                    if (this.cancelledFileObservers.contains(fileAlterationObserver)) continue;
                    fileAlterationObserver.checkAndNotify();
                }
                object = this.cancelledFileObservers;
                synchronized (object) {
                    this.removeCancelledFileObservers();
                }
                Thread.sleep(this.pollingInterval);
            }
        }
        catch (Throwable throwable) {
            if (this.watcher != null) {
                try {
                    this.watcher.close();
                }
                catch (IOException e) {
                    this.error("An error occurred attempting to close the file watcher. " + e.getMessage(), e);
                }
            }
            throw throwable;
        }
    }

    private void consolidateFileObservers() {
        this.fileObservers.addAll(this.newFileObservers);
        this.newFileObservers.clear();
    }

    private void removeCancelledFileObservers() {
        this.fileObservers.removeAll(this.cancelledFileObservers);
        this.cancelledFileObservers.clear();
    }

    private void registerSingleFile(File registerFile, ThreadPoolExecutor executor) throws IOException {
        this.registerSingleFile(registerFile, executor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSingleFile(final File registerFile, ThreadPoolExecutor executor, boolean removeOnContainerRebuild) throws IOException {
        if (this.trackingMode == FileTrackMode.POLLING || this.trackingMode == FileTrackMode.NOT_SET) {
            String parentPath = registerFile.getParentFile().getCanonicalPath();
            this.debug("Registering single file polling for " + registerFile.toString());
            Set<FileAlterationObserver> set = this.newFileObservers;
            synchronized (set) {
                HashSet<FileAlterationObserver> tempCombinedObservers = new HashSet<FileAlterationObserver>();
                tempCombinedObservers.addAll(this.fileObservers);
                tempCombinedObservers.addAll(this.newFileObservers);
                for (FileAlterationObserver observer : tempCombinedObservers) {
                    if (!parentPath.equals(observer.getDirectory().getCanonicalPath())) continue;
                    this.debug("Skipping single file polling for " + registerFile.toString() + " since its parent directory is already being observed");
                    return;
                }
                FileFilter singleFileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        block3: {
                            try {
                                if (file.getCanonicalFile().equals(registerFile.getCanonicalFile())) {
                                    return true;
                                }
                            }
                            catch (IOException e) {
                                if (!file.equals(registerFile)) break block3;
                                return true;
                            }
                        }
                        return false;
                    }
                };
                try {
                    FileAlterationObserver observer;
                    this.debug("Adding single file observer for: " + registerFile.toString());
                    observer = this.addFileAlterationObserver(executor, parentPath, singleFileFilter);
                    if (removeOnContainerRebuild) {
                        this.debug("Adding file to dockerfileDirectoriesFileObservers: " + registerFile.toString());
                        this.dockerfileDirectoriesFileObservers.add(observer);
                    }
                }
                catch (Exception e) {
                    this.error("Could not observe single file " + registerFile.toString(), e);
                }
            }
        }
        if (this.trackingMode == FileTrackMode.FILE_WATCHER || this.trackingMode == FileTrackMode.NOT_SET) {
            this.debug("Adding directory to WatchService " + registerFile.getParentFile().toPath() + " for single file " + registerFile.getName());
            WatchKey key = registerFile.getParentFile().toPath().register(this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
            if (removeOnContainerRebuild) {
                this.debug("Adding file to dockerfileDirectoriesWatchKeys: " + registerFile.getName());
                this.dockerfileDirectoriesWatchKeys.add(key);
            }
        }
    }

    private FileAlterationObserver addFileAlterationObserver(ThreadPoolExecutor executor, String parentPath, FileFilter filter) throws Exception {
        FileAlterationObserver observer = this.getFileAlterationObserver(executor, parentPath, filter);
        observer.initialize();
        this.newFileObservers.add(observer);
        return observer;
    }

    private FileAlterationObserver getFileAlterationObserver(final ThreadPoolExecutor executor, final String parentPath, FileFilter filter) {
        FileAlterationObserver observer = new FileAlterationObserver(parentPath, filter);
        observer.addListener((FileAlterationListener)new FileAlterationListenerAdaptor(){

            public void onDirectoryCreate(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.CREATE);
            }

            public void onDirectoryDelete(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.DELETE);
            }

            public void onDirectoryChange(File file) {
                this.onAlteration(executor, parentPath, file, true, ChangeType.MODIFY);
            }

            public void onFileCreate(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.CREATE);
            }

            public void onFileDelete(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.DELETE);
            }

            public void onFileChange(File file) {
                this.onAlteration(executor, parentPath, file, false, ChangeType.MODIFY);
            }

            private void onAlteration(ThreadPoolExecutor executor2, String parentPath2, File file, boolean isDirectory, ChangeType changeType) {
                if (DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    try {
                        WatchKey wk = null;
                        if (DevUtil.this.watcher != null) {
                            wk = DevUtil.this.watcher.poll(100L, TimeUnit.MILLISECONDS);
                        }
                        List<WatchEvent<?>> events = null;
                        if (wk != null) {
                            events = wk.pollEvents();
                        }
                        if (events == null || events.isEmpty()) {
                            DevUtil.this.trackingMode = FileTrackMode.POLLING;
                            if (DevUtil.this.watcher != null) {
                                DevUtil.this.watcher.close();
                            }
                        } else {
                            DevUtil.this.trackingMode = FileTrackMode.FILE_WATCHER;
                            DevUtil.this.disablePolling();
                        }
                    }
                    catch (Exception e) {
                        DevUtil.this.error("An error occured attempting to retrieve the watch key or close the file watcher. " + e.getMessage(), e);
                    }
                }
                try {
                    DevUtil.this.processFileChanges(executor2, file, DevUtil.this.outputDirectory, isDirectory, changeType);
                }
                catch (Exception e) {
                    DevUtil.this.debug(e);
                    DevUtil.this.error("Could not file process changes for " + file.getAbsolutePath() + ": " + e.getMessage());
                }
            }
        });
        return observer;
    }

    private void processJavaCompilation(File outputDirectory, File testOutputDirectory, ThreadPoolExecutor executor, List<String> artifactPaths) throws IOException, PluginExecutionException {
        boolean processTests;
        boolean processSources = System.currentTimeMillis() > this.lastJavaSourceChange + this.compileWaitMillis;
        boolean bl = processTests = System.currentTimeMillis() > this.lastJavaTestChange + this.compileWaitMillis;
        if (processSources) {
            if (!this.deleteJavaSources.isEmpty()) {
                this.debug("Deleting Java source files: " + this.deleteJavaSources);
                for (File file : this.deleteJavaSources) {
                    this.deleteJavaFile(file, outputDirectory, this.sourceDirectory);
                }
            }
            if (!this.recompileJavaSources.isEmpty() || this.triggerJavaSourceRecompile) {
                if (!this.failedCompilationJavaSources.isEmpty()) {
                    this.recompileJavaSources.addAll(this.failedCompilationJavaSources);
                }
                if (this.recompileJavaSource(this.recompileJavaSources, artifactPaths, executor, outputDirectory, testOutputDirectory)) {
                    this.failedCompilationJavaSources.clear();
                } else {
                    this.failedCompilationJavaSources.addAll(this.recompileJavaSources);
                }
            }
            if (processTests) {
                if (!this.deleteJavaTests.isEmpty()) {
                    this.debug("Deleting Java test files: " + this.deleteJavaTests);
                    for (File file : this.deleteJavaTests) {
                        this.deleteJavaFile(file, testOutputDirectory, this.testSourceDirectory);
                    }
                }
                if (!this.recompileJavaTests.isEmpty() || this.triggerJavaTestRecompile) {
                    this.debug("Recompiling Java test files: " + this.recompileJavaTests);
                    if (!this.failedCompilationJavaTests.isEmpty()) {
                        this.recompileJavaTests.addAll(this.failedCompilationJavaTests);
                    }
                    if (this.recompileJavaTest(this.recompileJavaTests, artifactPaths, executor, outputDirectory, testOutputDirectory)) {
                        this.failedCompilationJavaTests.clear();
                    } else {
                        this.failedCompilationJavaTests.addAll(this.recompileJavaTests);
                    }
                }
            }
            if (!this.deleteJavaSources.isEmpty() && this.recompileJavaSources.isEmpty()) {
                int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            } else if (processTests && !this.deleteJavaTests.isEmpty() && this.recompileJavaTests.isEmpty()) {
                this.runTestThread(false, executor, -1, false, false);
            }
            this.deleteJavaSources.clear();
            this.recompileJavaSources.clear();
            this.triggerJavaTestRecompile = false;
            this.triggerJavaSourceRecompile = false;
            if (processTests) {
                this.deleteJavaTests.clear();
                this.recompileJavaTests.clear();
            }
        }
    }

    private void checkStopDevMode(boolean skipOnRestart) throws PluginScenarioException {
        if (this.serverThread == null || this.serverThread.getState().equals((Object)Thread.State.TERMINATED)) {
            boolean restarting;
            boolean bl = restarting = this.devStop.get() && !this.calledShutdownHook.get();
            if (skipOnRestart && restarting && !this.externalContainerShutdown.get()) {
                this.debug("Server is restarting. Allowing dev mode to continue.");
                return;
            }
            if (!this.devStop.get()) {
                if (this.container) {
                    throw new PluginScenarioException("The container has stopped. Exiting dev mode.");
                }
                throw new PluginScenarioException("The server has stopped. Exiting dev mode.");
            }
            throw new PluginScenarioException();
        }
    }

    private void initWatchLoop() throws IOException {
        this.recompileJavaSources = new HashSet<File>();
        this.recompileJavaTests = new HashSet<File>();
        this.deleteJavaSources = new HashSet<File>();
        this.deleteJavaTests = new HashSet<File>();
        this.failedCompilationJavaSources = new HashSet<File>();
        this.failedCompilationJavaTests = new HashSet<File>();
        this.lastJavaSourceChange = System.currentTimeMillis();
        this.lastJavaTestChange = System.currentTimeMillis();
        this.triggerJavaSourceRecompile = false;
        this.triggerJavaTestRecompile = false;
        if (this.sourceDirectory.exists()) {
            Collection allJavaSources = FileUtils.listFiles((File)this.sourceDirectory.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            this.recompileJavaSources.addAll(allJavaSources);
        }
        if (this.testSourceDirectory.exists()) {
            Collection allJavaTestSources = FileUtils.listFiles((File)this.testSourceDirectory.getCanonicalFile(), (String[])new String[]{"java"}, (boolean)true);
            this.recompileJavaTests.addAll(allJavaTestSources);
        }
    }

    private void processFileChanges(ThreadPoolExecutor executor, File fileChanged, File outputDirectory, boolean isDirectory, ChangeType changeType) throws IOException, PluginExecutionException {
        ArrayList<File> javaFilesChanged;
        if (this.ignoreFileOrDir(fileChanged)) {
            return;
        }
        this.debug("Processing file changes for " + fileChanged + ", change type " + (Object)((Object)changeType));
        Path srcPath = this.sourceDirectory.getCanonicalFile().toPath();
        Path testSrcPath = this.testSourceDirectory.getCanonicalFile().toPath();
        Path configPath = this.configDirectory.getCanonicalFile().toPath();
        Path directory = fileChanged.getParentFile().toPath();
        File resourceParent = null;
        for (File resourceDir : this.resourceDirs) {
            if (!directory.startsWith(resourceDir.getCanonicalFile().toPath())) continue;
            resourceParent = resourceDir;
            break;
        }
        if (fileChanged.isDirectory()) {
            if (changeType == ChangeType.CREATE) {
                this.registerAll(fileChanged.toPath(), executor);
            }
            return;
        }
        int numApplicationUpdatedMessages = this.countApplicationUpdatedMessages();
        System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.FALSE.toString());
        if (directory.startsWith(srcPath)) {
            javaFilesChanged = new ArrayList<File>();
            javaFilesChanged.add(fileChanged);
            if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java source file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaSourceChange = System.currentTimeMillis();
                this.recompileJavaSources.add(fileChanged);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaSourceChange = System.currentTimeMillis();
                this.deleteJavaSources.add(fileChanged);
            }
        } else if (directory.startsWith(testSrcPath)) {
            javaFilesChanged = new ArrayList();
            javaFilesChanged.add(fileChanged);
            if (fileChanged.exists() && fileChanged.getName().endsWith(".java") && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.debug("Java test file modified: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaTestChange = System.currentTimeMillis();
                this.recompileJavaTests.add(fileChanged);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Java test file deleted: " + fileChanged.getName() + ". Adding to list for processing.");
                this.lastJavaTestChange = System.currentTimeMillis();
                this.deleteJavaTests.add(fileChanged);
            }
        } else if (directory.startsWith(configPath) && !this.isGeneratedConfigFile(fileChanged, this.configDirectory, this.serverDirectory)) {
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.TRUE.toString());
                this.copyConfigFolder(fileChanged, this.configDirectory, null);
                this.copyFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                if (this.isDockerfileDirectoryChanged(this.serverDirectory, fileChanged)) {
                    this.untrackDockerfileDirectoriesAndRestart();
                } else {
                    if (changeType == ChangeType.CREATE) {
                        this.redeployApp();
                    }
                    if (fileChanged.getName().equals("server.env")) {
                        this.enableServerDebug(false);
                    } else if (fileChanged.getName().equals("bootstrap.properties") && this.bootstrapPropertiesFileParent == null || fileChanged.getName().equals("jvm.options") && this.jvmOptionsFileParent == null) {
                        this.restartServer(false);
                    }
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            } else if (changeType == ChangeType.DELETE) {
                this.info("Config file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, null);
                if (this.isDockerfileDirectoryChanged(this.serverDirectory, fileChanged)) {
                    this.untrackDockerfileDirectoriesAndRestart();
                } else {
                    if (fileChanged.getName().equals("server.env")) {
                        this.enableServerDebug(false);
                    }
                    if (this.container && OSUtil.isLinux()) {
                        this.info("Restarting the container for this change to take effect.");
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            this.debug("Unexpected InterruptedException handling config file deletion.", e);
                        }
                        this.restartServer(false);
                    }
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            }
        } else if (this.serverXmlFileParent != null && directory.equals(this.serverXmlFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.serverXmlFile.getName())) {
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                System.setProperty(SKIP_BETA_INSTALL_WARNING, Boolean.TRUE.toString());
                this.copyConfigFolder(fileChanged, this.serverXmlFileParent, "server.xml");
                this.copyFile(fileChanged, this.serverXmlFileParent, this.serverDirectory, "server.xml");
                if (this.isDockerfileDirectoryChanged(this.serverDirectory, fileChanged)) {
                    this.untrackDockerfileDirectoriesAndRestart();
                } else if (changeType == ChangeType.CREATE) {
                    this.redeployApp();
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            } else if (changeType == ChangeType.DELETE) {
                this.info("Config file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, this.configDirectory, this.serverDirectory, "server.xml");
                if (this.isDockerfileDirectoryChanged(this.serverDirectory, fileChanged)) {
                    this.untrackDockerfileDirectoriesAndRestart();
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, true, false);
            }
        } else if (this.bootstrapPropertiesFileParent != null && directory.equals(this.bootstrapPropertiesFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.bootstrapPropertiesFile.getName())) {
            if (this.isDockerfileDirectoryChanged(fileChanged)) {
                this.untrackDockerfileDirectoriesAndRestart();
            } else {
                this.restartServer(false);
            }
        } else if (this.jvmOptionsFileParent != null && directory.equals(this.jvmOptionsFileParent.getCanonicalFile().toPath()) && fileChanged.getCanonicalPath().endsWith(this.jvmOptionsFile.getName())) {
            if (this.isDockerfileDirectoryChanged(fileChanged)) {
                this.untrackDockerfileDirectoriesAndRestart();
            } else {
                this.restartServer(false);
            }
        } else if (resourceParent != null && directory.startsWith(resourceParent.getCanonicalFile().toPath())) {
            this.debug("Resource dir: " + resourceParent.toString());
            if (fileChanged.exists() && (changeType == ChangeType.MODIFY || changeType == ChangeType.CREATE)) {
                this.copyFile(fileChanged, resourceParent, outputDirectory, null);
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            } else if (changeType == ChangeType.DELETE) {
                this.debug("Resource file deleted: " + fileChanged.getName());
                this.deleteFile(fileChanged, resourceParent, outputDirectory, null);
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            }
        } else if (fileChanged.equals(this.buildFile) && directory.startsWith(this.buildFile.getParentFile().getCanonicalFile().toPath()) && changeType == ChangeType.MODIFY) {
            boolean recompiledBuild = this.recompileBuildFile(this.buildFile, this.artifactPaths, executor);
            if (recompiledBuild) {
                if (!this.failedCompilationJavaSources.isEmpty()) {
                    this.triggerJavaSourceRecompile = true;
                }
                if (!this.failedCompilationJavaTests.isEmpty()) {
                    this.triggerJavaTestRecompile = true;
                }
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            }
        } else if (fileChanged.equals(this.dockerfileUsed) && directory.startsWith(this.dockerfileUsed.getParentFile().getCanonicalFile().toPath()) && changeType == ChangeType.MODIFY) {
            this.untrackDockerfileDirectoriesAndRestart();
        } else if (this.propertyFilesMap != null && this.propertyFilesMap.keySet().contains(fileChanged)) {
            boolean reloadedPropertyFile = this.reloadPropertyFile(fileChanged);
            if (reloadedPropertyFile) {
                this.runTestThread(true, executor, numApplicationUpdatedMessages, false, false);
            }
        } else if (this.isDockerfileDirectoryChanged(fileChanged)) {
            this.untrackDockerfileDirectoriesAndRestart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void untrackDockerfileDirectoriesAndRestart() throws PluginExecutionException {
        for (WatchKey key : this.dockerfileDirectoriesWatchKeys) {
            key.cancel();
        }
        this.dockerfileDirectoriesWatchKeys.clear();
        Set<FileAlterationObserver> set = this.cancelledFileObservers;
        synchronized (set) {
            for (FileAlterationObserver observer : this.dockerfileDirectoriesFileObservers) {
                this.cancelledFileObservers.add(observer);
                try {
                    observer.destroy();
                }
                catch (Exception e) {
                    this.debug("Could not destroy file observer", e);
                }
            }
        }
        this.dockerfileDirectoriesFileObservers.clear();
        this.dockerfileDirectoriesTracked.clear();
        this.restartServer(true);
    }

    private boolean isDockerfileDirectoryChanged(File ... files) throws IOException {
        if (this.container && !this.dockerfileDirectoriesTracked.isEmpty()) {
            for (Path trackedPath : this.dockerfileDirectoriesTracked) {
                Path logsPath = new File(this.serverDirectory, "logs").getCanonicalFile().toPath();
                for (File file : files) {
                    Path filePath = file.getCanonicalFile().toPath();
                    if (!filePath.startsWith(trackedPath) || filePath.startsWith(logsPath) || filePath.toString().endsWith(".war.xml")) continue;
                    this.debug("isDockerfileDirectoryChanged=true for directory " + trackedPath + " with file " + file);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isGeneratedConfigFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        return (fileChanged.getName().equals("bootstrap.properties") || fileChanged.getName().equals("jvm.options")) && this.isGeneratedTargetFile(fileChanged, srcDir, targetDir);
    }

    /*
     * Exception decompiling
     */
    private boolean isGeneratedTargetFile(File fileChanged, File srcDir, File targetDir) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String readFile(File file) throws IOException {
        return FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
    }

    public void copyConfigFolder(File fileChanged, File srcDir, String targetFileName) throws IOException {
        this.tempConfigPath = Files.createTempDirectory("tempConfig", new FileAttribute[0]);
        File tempConfig = this.tempConfigPath.toFile();
        this.debug("Temporary configuration folder created: " + tempConfig);
        FileUtils.copyDirectory((File)this.serverDirectory, (File)tempConfig, (FileFilter)new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                String name = pathname.getName();
                boolean skip = DevUtil.this.ignoreFileOrDir(pathname) || pathname.isDirectory() && (name.equals("workarea") || name.equals("logs"));
                return !skip;
            }
        }, (boolean)true);
        this.copyFile(fileChanged, srcDir, tempConfig, targetFileName);
        this.checkConfigFile(fileChanged, tempConfig);
        this.cleanUpTempConfig();
    }

    private boolean ignoreFileOrDir(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            for (String prefix : IGNORE_DIRECTORY_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        } else {
            for (String prefix : IGNORE_FILE_PREFIXES) {
                if (!name.startsWith(prefix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
            for (String postfix : IGNORE_FILE_POSTFIXES) {
                if (!name.endsWith(postfix)) continue;
                this.debug("Ignoring " + name);
                return true;
            }
        }
        return false;
    }

    public void copyFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        File targetResource = this.getTargetFile(fileChanged, srcDir, targetDir, targetFileName);
        try {
            FileUtils.copyFile((File)fileChanged, (File)targetResource);
            this.info("Copied file: " + fileChanged.getCanonicalPath() + " to: " + targetResource.getCanonicalPath());
        }
        catch (FileNotFoundException ex) {
            this.debug("Failed to copy file: " + fileChanged.getCanonicalPath());
        }
        catch (Exception ex) {
            this.debug(ex);
        }
    }

    private File getTargetFile(File fileChanged, File srcDir, File targetDir, String targetFileName) throws IOException {
        String relPath = fileChanged.getCanonicalPath().substring(fileChanged.getCanonicalPath().indexOf(srcDir.getCanonicalPath()) + srcDir.getCanonicalPath().length());
        if (targetFileName != null) {
            relPath = relPath.substring(0, relPath.indexOf(fileChanged.getName())) + targetFileName;
        }
        File targetResource = new File(targetDir.getCanonicalPath() + relPath);
        return targetResource;
    }

    protected void deleteFile(File deletedFile, File dir, File targetDir, String targetFileName) throws IOException {
        File targetFile = this.getTargetFile(deletedFile, dir, targetDir, targetFileName);
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)targetFile);
                    this.info("The directory " + targetFile.getCanonicalPath() + " was deleted.");
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not delete the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
                catch (IOException e) {
                    this.error("An error encountered while deleting the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
            } else if (targetFile.delete()) {
                this.info("The file " + targetFile.getCanonicalPath() + " was deleted.");
            } else {
                this.error("Could not delete the file " + targetFile.getCanonicalPath() + ".");
            }
        }
    }

    protected void cleanTargetDir(File outputDirectory) {
        File[] fList = outputDirectory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile() && file.getName().toLowerCase().endsWith(".class")) {
                    file.delete();
                    this.info("Deleted Java class file: " + file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.cleanTargetDir(file);
            }
        }
        if (outputDirectory.listFiles().length == 0) {
            outputDirectory.delete();
        }
    }

    protected void registerAll(Path start, ThreadPoolExecutor executor) throws IOException {
        this.registerAll(start, executor, false);
    }

    protected void registerAll(Path start, final ThreadPoolExecutor executor, final boolean removeOnContainerRebuild) throws IOException {
        this.debug("Registering all files in directory: " + start.toString());
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public FileVisitResult preVisitDirectory(final Path dir, BasicFileAttributes attrs) throws IOException {
                if (DevUtil.this.trackingMode == FileTrackMode.POLLING || DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    Set set = DevUtil.this.newFileObservers;
                    synchronized (set) {
                        HashSet tempCombinedObservers = new HashSet();
                        tempCombinedObservers.addAll(DevUtil.this.fileObservers);
                        tempCombinedObservers.addAll(DevUtil.this.newFileObservers);
                        for (FileAlterationObserver observer : tempCombinedObservers) {
                            if (!dir.equals(observer.getDirectory().getCanonicalFile().toPath())) continue;
                            DevUtil.this.debug("Skipping subdirectory " + dir.toString() + " since it already being observed");
                            return FileVisitResult.CONTINUE;
                        }
                        FileFilter singleDirectoryFilter = new FileFilter(){

                            @Override
                            public boolean accept(File file) {
                                try {
                                    if (dir.equals(file.getParentFile().getCanonicalFile().toPath())) {
                                        return true;
                                    }
                                }
                                catch (IOException e) {
                                    return false;
                                }
                                return false;
                            }
                        };
                        try {
                            FileAlterationObserver observer;
                            DevUtil.this.debug("Adding subdirectory to file observers: " + dir.toString());
                            observer = DevUtil.this.addFileAlterationObserver(executor, dir.toString(), singleDirectoryFilter);
                            if (removeOnContainerRebuild) {
                                DevUtil.this.debug("Adding to dockerfileDirectoriesFileObservers: " + dir);
                                DevUtil.this.dockerfileDirectoriesFileObservers.add(observer);
                            }
                        }
                        catch (Exception e) {
                            DevUtil.this.error("Could not observe directory " + dir.toString(), e);
                        }
                    }
                }
                if (DevUtil.this.trackingMode == FileTrackMode.FILE_WATCHER || DevUtil.this.trackingMode == FileTrackMode.NOT_SET) {
                    DevUtil.this.debug("Adding subdirectory to WatchService: " + dir.toString());
                    WatchKey key = dir.register(DevUtil.this.watcher, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE}, SensitivityWatchEventModifier.HIGH);
                    if (removeOnContainerRebuild) {
                        DevUtil.this.debug("Adding to dockerfileDirectoriesWatchKeys: " + dir);
                        DevUtil.this.dockerfileDirectoriesWatchKeys.add(key);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected File getFileFromConfigDirectory(String file) {
        File f = new File(this.configDirectory, file);
        if (this.configDirectory != null && f.exists()) {
            return f;
        }
        return null;
    }

    protected void deleteJavaFile(File fileChanged, File classesDir, File compileSourceRoot) throws IOException {
        String relPath;
        String fileName = fileChanged.getName();
        File parentFile = fileChanged.getParentFile();
        boolean javaFile = fileName.endsWith(".java");
        if (javaFile) {
            fileName = fileName.substring(0, fileChanged.getName().indexOf(".java"));
            relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName + ".class";
        } else {
            relPath = parentFile.getCanonicalPath().substring(parentFile.getCanonicalPath().indexOf(compileSourceRoot.getCanonicalPath()) + compileSourceRoot.getCanonicalPath().length()) + "/" + fileName;
        }
        File targetFile = new File(classesDir.getCanonicalPath() + relPath);
        if (targetFile.exists()) {
            if (targetFile.isDirectory()) {
                try {
                    FileUtils.deleteDirectory((File)targetFile);
                    this.info("The target directory " + targetFile.getCanonicalPath() + " was deleted.");
                }
                catch (IllegalArgumentException e) {
                    this.debug("Could not delete directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
                catch (IOException e) {
                    this.error("There was an error encountered while deleting the directory " + targetFile.getCanonicalPath() + ". " + e.getMessage());
                }
            } else if (targetFile.delete()) {
                this.info("The java class " + targetFile.getCanonicalPath() + " was deleted.");
            } else {
                this.error("Could not delete the file " + targetFile.getCanonicalPath() + ". ");
            }
        } else {
            this.warn("File deleted but could not find corresponding file or folder in the target directory: " + fileChanged.getCanonicalPath() + ".");
        }
    }

    protected boolean recompileJavaSource(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        return this.recompileJava(javaFilesChanged, artifactPaths, executor, false, outputDirectory, testOutputDirectory);
    }

    protected boolean recompileJavaTest(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        return this.recompileJava(javaFilesChanged, artifactPaths, executor, true, outputDirectory, testOutputDirectory);
    }

    protected boolean recompileJava(Collection<File> javaFilesChanged, List<String> artifactPaths, ThreadPoolExecutor executor, boolean tests, File outputDirectory, File testOutputDirectory) throws PluginExecutionException {
        try {
            boolean compileResult;
            int messageOccurrences = this.countApplicationUpdatedMessages();
            if (this.useBuildRecompile) {
                compileResult = this.compile(tests ? this.testSourceDirectory : this.sourceDirectory);
            } else {
                File classesDir;
                File file = classesDir = tests ? testOutputDirectory : outputDirectory;
                if (!classesDir.exists()) {
                    if (!classesDir.mkdirs()) {
                        throw new PluginExecutionException("The classes output directory " + classesDir.getAbsolutePath() + " does not exist and cannot be created.");
                    }
                    if (classesDir.exists() && Objects.equals(classesDir.getCanonicalFile(), outputDirectory.getCanonicalFile())) {
                        this.redeployApp();
                    }
                }
                ArrayList<String> combinedCompilerOptions = new ArrayList<String>(Arrays.asList(DEFAULT_COMPILER_OPTIONS));
                if (this.compilerOptions != null) {
                    combinedCompilerOptions.addAll(this.compilerOptions.getOptions());
                }
                this.debug("Compiler options: " + combinedCompilerOptions);
                ArrayList<File> outputDirs = new ArrayList<File>();
                if (tests) {
                    outputDirs.add(outputDirectory);
                    outputDirs.add(testOutputDirectory);
                } else {
                    outputDirs.add(outputDirectory);
                }
                Set<File> classPathElems = this.getClassPath(artifactPaths, outputDirs);
                JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
                fileManager.setLocation(StandardLocation.CLASS_PATH, classPathElems);
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(classesDir));
                HashSet<JavaFileObject> compilationUnits = new HashSet<JavaFileObject>();
                for (File file2 : javaFilesChanged) {
                    if (file2.exists() && file2.isFile()) {
                        for (JavaFileObject javaFileObject : fileManager.getJavaFileObjects(file2)) {
                            compilationUnits.add(javaFileObject);
                        }
                        continue;
                    }
                    this.debug("The Java file " + file2 + " does not exist and will not be compiled.");
                }
                JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, combinedCompilerOptions, null, compilationUnits);
                compileResult = task.call();
            }
            if (compileResult) {
                if (tests) {
                    this.info("Tests compilation was successful.");
                } else {
                    if (!this.isLooseApplication()) {
                        this.redeployApp();
                    }
                    this.info("Source compilation was successful.");
                }
                if (tests) {
                    this.runTestThread(false, executor, -1, false, false);
                } else {
                    this.runTestThread(true, executor, messageOccurrences, false, false);
                }
                return true;
            }
            if (tests) {
                this.info("Tests compilation had errors.");
            } else {
                this.info("Source compilation had errors.");
            }
            return false;
        }
        catch (Exception e) {
            this.error("Error compiling Java files: " + e.getMessage());
            this.debug(e);
            return false;
        }
    }

    protected Set<File> getClassPath(List<String> artifactPaths, List<File> outputDirs) throws IOException {
        HashSet<String> parsedFiles = new HashSet<String>();
        ArrayDeque<String> toParse = new ArrayDeque<String>();
        for (String artifactPath : artifactPaths) {
            toParse.add(new File(artifactPath).getCanonicalPath());
        }
        HashSet<File> classPathElements = new HashSet<File>();
        classPathElements.addAll(outputDirs);
        while (!toParse.isEmpty()) {
            String s = (String)toParse.poll();
            if (parsedFiles.contains(s)) continue;
            parsedFiles.add(s);
            File file = new File(s);
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            classPathElements.add(file);
            if (file.isDirectory()) continue;
            try {
                JarFile jar = new JarFile(file);
                Throwable throwable = null;
                try {
                    Object classPath;
                    Manifest mf = jar.getManifest();
                    if (mf == null || mf.getMainAttributes() == null || (classPath = mf.getMainAttributes().get(Attributes.Name.CLASS_PATH)) == null) continue;
                    for (String i : classPath.toString().split(" ")) {
                        File f;
                        try {
                            URL u = new URL(i);
                            f = new File(u.getPath());
                        }
                        catch (MalformedURLException e) {
                            f = new File(file.getParentFile(), i);
                        }
                        if (!f.exists()) continue;
                        toParse.add(f.getCanonicalPath());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (jar == null) continue;
                    if (throwable != null) {
                        try {
                            jar.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    jar.close();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to open class path file " + file, e);
            }
        }
        return classPathElements;
    }

    public void runTestThread(boolean waitForApplicationUpdate, ThreadPoolExecutor executor, int messageOccurrences, boolean forceSkipUTs, boolean manualInvocation) {
        try {
            if (manualInvocation || this.hotTests) {
                executor.execute(new TestJob(waitForApplicationUpdate, messageOccurrences, executor, forceSkipUTs, manualInvocation));
            }
        }
        catch (RejectedExecutionException e) {
            this.debug("Cannot add thread since max threads reached", e);
        }
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public String getHttpsPort() {
        return this.httpsPort;
    }

    public void setLibertyDebugPort(int libertyDebugPort) {
        this.libertyDebugPort = libertyDebugPort;
    }

    private boolean reloadPropertyFile(File propertyFile) throws PluginExecutionException {
        Properties properties = this.readPropertiesFromFile(propertyFile);
        if (!Objects.equals(properties, this.propertyFilesMap.get(propertyFile))) {
            this.debug("Properties file " + propertyFile.getAbsolutePath() + " has changed. Restarting server...");
            this.propertyFilesMap.put(propertyFile, properties);
            this.restartServer();
            return true;
        }
        this.debug("No changes detected in properties file " + propertyFile.getAbsolutePath());
        return false;
    }

    public void setPropertyFiles(List<File> propertyFiles) {
        if (propertyFiles == null) {
            return;
        }
        if (this.propertyFilesMap == null) {
            this.propertyFilesMap = new HashMap<File, Properties>(propertyFiles.size());
        }
        for (File propertyFile : propertyFiles) {
            Properties properties = this.readPropertiesFromFile(propertyFile);
            this.propertyFilesMap.put(propertyFile, properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readPropertiesFromFile(File propertyFile) {
        Properties properties = null;
        if (propertyFile.exists()) {
            InputStream inputStream = null;
            try {
                this.debug("Loading properties from file: " + propertyFile);
                inputStream = new FileInputStream(propertyFile);
                properties = new Properties();
                properties.load(inputStream);
            }
            catch (IOException e) {
                this.error("Could not read properties file " + propertyFile.getAbsolutePath(), e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public class TestJob
    implements Runnable {
        private boolean waitForApplicationUpdate;
        private int messageOccurrences;
        private ThreadPoolExecutor executor;
        private boolean forceSkipUTs;
        private boolean manualInvocation;

        public TestJob(boolean waitForApplicationUpdate, int messageOccurrences, ThreadPoolExecutor executor, boolean forceSkipUTs, boolean manualInvocation) {
            this.waitForApplicationUpdate = waitForApplicationUpdate;
            this.messageOccurrences = messageOccurrences;
            this.executor = executor;
            this.forceSkipUTs = forceSkipUTs;
            this.manualInvocation = manualInvocation;
        }

        @Override
        public void run() {
            try {
                DevUtil.this.runTests(this.waitForApplicationUpdate, this.messageOccurrences, this.executor, this.forceSkipUTs);
            }
            finally {
                DevUtil.this.runHotkeyReaderThread(this.executor);
            }
        }

        public boolean isManualInvocation() {
            return this.manualInvocation;
        }
    }

    private static enum ChangeType {
        CREATE,
        DELETE,
        MODIFY;

    }

    private class HotkeyReader
    implements Runnable {
        private Scanner scanner;
        private ThreadPoolExecutor executor;
        private boolean shutdown = false;

        public HotkeyReader(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        @Override
        public void run() {
            DevUtil.this.debug("Running hotkey reader thread");
            this.scanner = new Scanner((InputStream)new CloseShieldInputStream(System.in));
            try {
                this.readInput();
            }
            finally {
                this.scanner.close();
            }
        }

        public void shutdown() {
            this.shutdown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readInput() {
            if (this.scanner.hasNextLine()) {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.notify();
                }
                while (!this.shutdown) {
                    DevUtil.this.debug("Waiting for Enter key to run tests");
                    if (this.scanner.hasNextLine()) {
                        String line = this.scanner.nextLine();
                        if (line != null && (line.trim().equalsIgnoreCase("q") || line.trim().equalsIgnoreCase("quit") || line.trim().equalsIgnoreCase("exit"))) {
                            DevUtil.this.debug("Detected exit command");
                            DevUtil.this.runShutdownHook(this.executor);
                            continue;
                        }
                        if (line != null && line.trim().equalsIgnoreCase("r")) {
                            DevUtil.this.debug("Detected restart command");
                            try {
                                DevUtil.this.restartServer(true);
                            }
                            catch (PluginExecutionException e) {
                                DevUtil.this.debug("Exiting dev mode due to server restart failure");
                                DevUtil.this.error("Could not restart the server.", e);
                                DevUtil.this.runShutdownHook(this.executor);
                            }
                            continue;
                        }
                        DevUtil.this.debug("Detected Enter key. Running tests...");
                        DevUtil.this.runTestThread(false, this.executor, -1, false, true);
                        continue;
                    }
                    break;
                }
            } else {
                AtomicBoolean atomicBoolean = DevUtil.this.inputUnavailable;
                synchronized (atomicBoolean) {
                    DevUtil.this.inputUnavailable.set(true);
                    DevUtil.this.inputUnavailable.notify();
                }
            }
        }
    }

    private static enum FileTrackMode {
        NOT_SET,
        FILE_WATCHER,
        POLLING;

    }
}

