/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.tools.common.arquillian.util;

import io.openliberty.tools.common.arquillian.util.ArquillianConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HttpPortUtil {
    public static final int DEFAULT_PORT = 9080;
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static Integer getHttpPort(File serverXML, File bootstrapProperties) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, XPathExpressionException, ArquillianConfigurationException {
        return HttpPortUtil.getHttpPort(serverXML, bootstrapProperties, null);
    }

    public static Integer getHttpPort(File serverXML, File bootstrapProperties, File configVariableXML) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException, XPathExpressionException, ArquillianConfigurationException {
        if (serverXML != null && serverXML.exists() && serverXML.isFile()) {
            byte[] encoded = Files.readAllBytes(Paths.get(serverXML.getCanonicalPath(), new String[0]));
            String serverXMLAsString = new String(encoded, StandardCharsets.UTF_8);
            Properties prop = new Properties();
            if (bootstrapProperties != null && bootstrapProperties.exists()) {
                prop.load(new FileInputStream(bootstrapProperties));
            }
            String configVariableXMLAsString = null;
            if (configVariableXML != null && configVariableXML.exists() && configVariableXML.isFile()) {
                byte[] configVarBytes = Files.readAllBytes(Paths.get(configVariableXML.getCanonicalPath(), new String[0]));
                configVariableXMLAsString = new String(configVarBytes, StandardCharsets.UTF_8);
            }
            return HttpPortUtil.getHttpPortForServerXML(serverXMLAsString, prop, configVariableXMLAsString);
        }
        throw new FileNotFoundException("The given server.xml file at " + serverXML.getCanonicalPath() + " was not found.");
    }

    protected static Integer getHttpPortForServerXML(String serverXML, Properties bootstrapProperties, String configVariableXML) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, ArquillianConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(serverXML.getBytes()));
        XPathExpression httpEndpointExpr = XPATH.compile("/server/httpEndpoint");
        Object httpEndpointObj = httpEndpointExpr.evaluate(doc, XPathConstants.NODE);
        if (httpEndpointObj == null) {
            return 9080;
        }
        Element httpEndpointElement = (Element)httpEndpointObj;
        String portString = httpEndpointElement.getAttribute("httpPort");
        try {
            return Integer.parseInt(portString);
        }
        catch (NumberFormatException e) {
            Pattern p = Pattern.compile("^\\$\\{(.*)\\}$");
            Matcher m = p.matcher(portString);
            if (m.find()) {
                String variable = m.group(1);
                String variableValue = HttpPortUtil.getHttpPortFromConfigVariableXML(configVariableXML, variable);
                if (variableValue != null) {
                    try {
                        return Integer.parseInt(variableValue);
                    }
                    catch (NumberFormatException ex) {
                        throw new ArquillianConfigurationException("liberty-plugin-variable-config.xml variable " + variable + " is not in the correct format.");
                    }
                }
                return HttpPortUtil.getHttpPortFromBootstrapProperties(variable, bootstrapProperties);
            }
            throw new ArquillianConfigurationException("Bootstrap properties variable " + portString + " is not in the correct format.");
        }
    }

    private static String getHttpPortFromConfigVariableXML(String configVariableXML, String variableName) throws ParserConfigurationException, SAXException, XPathExpressionException, IOException {
        if (configVariableXML == null || configVariableXML.length() == 0) {
            return null;
        }
        DocumentBuilderFactory inputBuilderFactory = DocumentBuilderFactory.newInstance();
        inputBuilderFactory.setIgnoringComments(true);
        inputBuilderFactory.setCoalescing(true);
        inputBuilderFactory.setIgnoringElementContentWhitespace(true);
        inputBuilderFactory.setValidating(false);
        DocumentBuilder inputBuilder = inputBuilderFactory.newDocumentBuilder();
        Document inputDoc = inputBuilder.parse(new ByteArrayInputStream(configVariableXML.getBytes()));
        String expression = "/server/variable";
        NodeList nodes = (NodeList)XPATH.compile(expression).evaluate(inputDoc, XPathConstants.NODESET);
        String variableValue = null;
        String variableDefaultValue = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            String varDefaultValue;
            Element el = (Element)nodes.item(i);
            String varName = el.getAttribute("name");
            if (varName == null || !varName.equals(variableName)) continue;
            String varValue = el.getAttribute("value");
            if (varValue != null && !varValue.isEmpty() && variableValue == null) {
                variableValue = varValue;
            }
            if ((varDefaultValue = el.getAttribute("defaultValue")) == null || varDefaultValue.isEmpty() || variableDefaultValue != null) continue;
            variableDefaultValue = varDefaultValue;
        }
        return variableValue != null ? variableValue : variableDefaultValue;
    }

    private static Integer getHttpPortFromBootstrapProperties(String variable, Properties bootstrapProperties) throws ArquillianConfigurationException {
        String value;
        if (bootstrapProperties != null && (value = bootstrapProperties.getProperty(variable)) != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ArquillianConfigurationException("Unable to find variable \"" + variable + "\" in bootstrap properties.");
    }

    static {
        factory.setNamespaceAware(true);
    }
}

