/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.resolver.internal;

import com.ibm.ws.repository.resolver.internal.LibertyVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibertyVersionRange {
    private final LibertyVersion minVersion;
    private final LibertyVersion maxVersion;
    private static final Pattern VERSION_RANGE_PATTERN = Pattern.compile("[\\[\\(]([^,]*),(.*)[\\]\\)]");

    public static LibertyVersionRange valueOf(String versionRangeString) {
        if (versionRangeString == null) {
            return null;
        }
        Matcher versionRangeMatcher = VERSION_RANGE_PATTERN.matcher(versionRangeString);
        if (versionRangeMatcher.matches()) {
            LibertyVersion minVersion = LibertyVersion.valueOf(versionRangeMatcher.group(1));
            LibertyVersion maxVersion = LibertyVersion.valueOf(versionRangeMatcher.group(2));
            if (minVersion != null && maxVersion != null) {
                return new LibertyVersionRange(minVersion, maxVersion);
            }
            return null;
        }
        LibertyVersion minVersion = LibertyVersion.valueOf(versionRangeString);
        if (minVersion != null) {
            return new LibertyVersionRange(minVersion, null);
        }
        return null;
    }

    public LibertyVersionRange(LibertyVersion minVersion, LibertyVersion maxVersion) {
        this.minVersion = minVersion;
        this.maxVersion = maxVersion;
    }

    public LibertyVersion getMinVersion() {
        return this.minVersion;
    }

    public LibertyVersion getMaxVersion() {
        return this.maxVersion;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.maxVersion == null ? 0 : this.maxVersion.hashCode());
        result = 31 * result + (this.minVersion == null ? 0 : this.minVersion.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LibertyVersionRange other = (LibertyVersionRange)obj;
        if (this.maxVersion == null ? other.maxVersion != null : !this.maxVersion.equals(other.maxVersion)) {
            return false;
        }
        return !(this.minVersion == null ? other.minVersion != null : !this.minVersion.equals(other.minVersion));
    }

    public String toString() {
        if (this.maxVersion != null) {
            return "[" + this.minVersion.toString() + "," + this.maxVersion.toString() + "]";
        }
        return this.minVersion.toString();
    }
}

