/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheRequestHeader;
import io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.FullBinaryMemcacheRequest;

public class DefaultFullBinaryMemcacheRequest
extends DefaultBinaryMemcacheRequest
implements FullBinaryMemcacheRequest {
    private final ByteBuf content;

    public DefaultFullBinaryMemcacheRequest(BinaryMemcacheRequestHeader header, String key, ByteBuf extras) {
        this(header, key, extras, Unpooled.buffer(0));
    }

    public DefaultFullBinaryMemcacheRequest(BinaryMemcacheRequestHeader header, String key, ByteBuf extras, ByteBuf content) {
        super(header, key, extras);
        if (content == null) {
            throw new NullPointerException("Supplied content is null.");
        }
        this.content = content;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullBinaryMemcacheRequest retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullBinaryMemcacheRequest retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    @Override
    public FullBinaryMemcacheRequest copy() {
        return new DefaultFullBinaryMemcacheRequest((BinaryMemcacheRequestHeader)this.getHeader(), this.getKey(), this.getExtras(), this.content().copy());
    }

    @Override
    public FullBinaryMemcacheRequest duplicate() {
        return new DefaultFullBinaryMemcacheRequest((BinaryMemcacheRequestHeader)this.getHeader(), this.getKey(), this.getExtras(), this.content().duplicate());
    }
}

