/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.memcache.binary;

import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.memcache.AbstractMemcacheObjectAggregator;
import io.netty.handler.codec.memcache.FullMemcacheMessage;
import io.netty.handler.codec.memcache.LastMemcacheContent;
import io.netty.handler.codec.memcache.MemcacheContent;
import io.netty.handler.codec.memcache.MemcacheMessage;
import io.netty.handler.codec.memcache.MemcacheObject;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.BinaryMemcacheResponse;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheRequest;
import io.netty.handler.codec.memcache.binary.DefaultFullBinaryMemcacheResponse;
import io.netty.util.ReferenceCountUtil;
import java.util.List;

public class BinaryMemcacheObjectAggregator
extends AbstractMemcacheObjectAggregator {
    private boolean tooLongFrameFound;

    public BinaryMemcacheObjectAggregator(int maxContentLength) {
        super(maxContentLength);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, MemcacheObject msg, List<Object> out) throws Exception {
        FullMemcacheMessage currentMessage = this.currentMessage;
        if (msg instanceof MemcacheMessage) {
            this.tooLongFrameFound = false;
            MemcacheMessage m = (MemcacheMessage)msg;
            if (!m.getDecoderResult().isSuccess()) {
                this.currentMessage = null;
                out.add(ReferenceCountUtil.retain(m));
                return;
            }
            if (msg instanceof BinaryMemcacheRequest) {
                BinaryMemcacheRequest request = (BinaryMemcacheRequest)msg;
                this.currentMessage = new DefaultFullBinaryMemcacheRequest(request.getHeader(), request.getKey(), request.getExtras(), Unpooled.compositeBuffer(this.getMaxCumulationBufferComponents()));
                return;
            } else {
                if (!(msg instanceof BinaryMemcacheResponse)) throw new Error();
                BinaryMemcacheResponse response = (BinaryMemcacheResponse)msg;
                this.currentMessage = new DefaultFullBinaryMemcacheResponse(response.getHeader(), response.getKey(), response.getExtras(), Unpooled.compositeBuffer(this.getMaxCumulationBufferComponents()));
            }
            return;
        } else {
            boolean last;
            if (!(msg instanceof MemcacheContent)) throw new Error();
            if (this.tooLongFrameFound) {
                if (!(msg instanceof LastMemcacheContent)) return;
                this.currentMessage = null;
                return;
            }
            MemcacheContent chunk = (MemcacheContent)msg;
            CompositeByteBuf content = (CompositeByteBuf)currentMessage.content();
            if (content.readableBytes() > this.getMaxContentLength() - chunk.content().readableBytes()) {
                this.tooLongFrameFound = true;
                currentMessage.release();
                this.currentMessage = null;
                throw new TooLongFrameException("Memcache content length exceeded " + this.getMaxContentLength() + " bytes.");
            }
            if (chunk.content().isReadable()) {
                chunk.retain();
                content.addComponent(chunk.content());
                content.writerIndex(content.writerIndex() + chunk.content().readableBytes());
            }
            if (!chunk.getDecoderResult().isSuccess()) {
                currentMessage.setDecoderResult(DecoderResult.failure(chunk.getDecoderResult().cause()));
                last = true;
            } else {
                last = chunk instanceof LastMemcacheContent;
            }
            if (!last) return;
            this.currentMessage = null;
            out.add(currentMessage);
        }
    }
}

