/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.Message;
import io.nats.client.Subscription;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SubscriptionImpl
implements Subscription {
    static final Logger logger = LoggerFactory.getLogger(SubscriptionImpl.class);
    static final int DEFAULT_MAX_PENDING_MSGS = 65536;
    static final int DEFAULT_MAX_PENDING_BYTES = 0x4000000;
    private final Lock mu = new ReentrantLock();
    private long sid;
    private final String subject;
    private final String queue;
    long delivered;
    long max;
    boolean closed;
    boolean connClosed;
    boolean sc;
    private ConnectionImpl conn;
    BlockingQueue<Message> mch;
    Condition pCond;
    int pMsgs;
    int pBytes;
    int pMsgsMax;
    int pBytesMax;
    int pMsgsLimit = 65536;
    int pBytesLimit = this.pMsgsLimit * 1024;
    int dropped;

    SubscriptionImpl(ConnectionImpl conn, String subject, String queue) {
        this(conn, subject, queue, 65536, 0x4000000);
    }

    SubscriptionImpl(ConnectionImpl conn, String subject, String queue, int pendingMsgsLimit, int pendingBytesLimit) {
        this.conn = conn;
        this.subject = subject;
        this.queue = queue;
        this.setPendingMsgsLimit(pendingMsgsLimit);
        this.setPendingBytesLimit(pendingBytesLimit);
        this.mch = new LinkedBlockingQueue<Message>();
        this.pCond = this.mu.newCondition();
    }

    void closeChannel() {
        this.mu.lock();
        try {
            if (this.mch != null) {
                this.mch.clear();
                this.mch = null;
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getQueue() {
        return this.queue;
    }

    public BlockingQueue<Message> getChannel() {
        return this.mch;
    }

    public void setChannel(BlockingQueue<Message> ch) {
        this.mch = ch;
    }

    boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isValid() {
        this.mu.lock();
        boolean valid = this.conn != null;
        this.mu.unlock();
        return valid;
    }

    @Override
    public void unsubscribe() throws IOException {
        this.unsubscribe(false);
    }

    public void unsubscribe(boolean ignoreInvalid) throws IOException {
        this.mu.lock();
        ConnectionImpl conn = this.conn;
        this.mu.unlock();
        if (conn == null) {
            if (!ignoreInvalid) {
                throw new IllegalStateException("nats: invalid subscription");
            }
        } else {
            conn.unsubscribe(this, 0);
        }
    }

    @Override
    public void autoUnsubscribe(int max) throws IOException {
        this.mu.lock();
        ConnectionImpl conn = this.conn;
        this.mu.unlock();
        if (conn == null) {
            throw new IllegalStateException("nats: invalid subscription");
        }
        conn.unsubscribe(this, max);
    }

    @Override
    public void close() {
        try {
            this.unsubscribe(true);
        }
        catch (Exception e) {
            logger.debug("Exception while calling unsubscribe from AutoCloseable.close()", (Throwable)e);
        }
    }

    long getSid() {
        return this.sid;
    }

    void setSid(long id) {
        this.sid = id;
    }

    @Override
    public int getDropped() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.dropped;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingMsgsMax() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pMsgsMax;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public long getPendingBytesMax() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pBytesMax;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public void setPendingLimits(int msgs, int bytes) {
        this.setPendingMsgsLimit(msgs);
        this.setPendingBytesLimit(bytes);
    }

    void setPendingMsgsLimit(int pendingMsgsLimit) {
        this.mu.lock();
        try {
            this.pMsgsLimit = pendingMsgsLimit;
            if (pendingMsgsLimit == 0) {
                throw new IllegalArgumentException("nats: pending message limit cannot be zero");
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void setPendingBytesLimit(int pendingBytesLimit) {
        this.mu.lock();
        try {
            this.pBytesLimit = pendingBytesLimit;
            if (pendingBytesLimit == 0) {
                throw new IllegalArgumentException("nats: pending message limit cannot be zero");
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void setPendingMsgsMax(int max) {
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            this.pMsgsMax = max <= 0 ? 0 : max;
        }
        finally {
            this.mu.unlock();
        }
    }

    void setPendingBytesMax(int max) {
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            this.pBytesMax = max <= 0 ? 0 : max;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void clearMaxPending() {
        this.setPendingMsgsMax(0);
        this.setPendingBytesMax(0);
    }

    Connection getConnection() {
        return this.conn;
    }

    void setConnection(ConnectionImpl conn) {
        this.conn = conn;
    }

    @Override
    public long getDelivered() {
        long rv = 0L;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.delivered;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingBytes() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pBytes;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingBytesLimit() {
        this.mu.lock();
        int rv = this.pBytesLimit;
        this.mu.unlock();
        return rv;
    }

    @Override
    public int getPendingMsgs() {
        int rv = 0;
        this.mu.lock();
        try {
            if (this.conn == null) {
                throw new IllegalStateException("nats: invalid subscription");
            }
            rv = this.pMsgs;
        }
        finally {
            this.mu.unlock();
        }
        return rv;
    }

    @Override
    public int getPendingMsgsLimit() {
        this.mu.lock();
        int rv = this.pMsgsLimit;
        this.mu.unlock();
        return rv;
    }

    @Override
    public int getQueuedMessageCount() {
        return this.getPendingMsgs();
    }

    public String toString() {
        return String.format("{subject=%s, queue=%s, sid=%d, max=%d, delivered=%d, pendingMsgsLimit=%d, pendingBytesLimit=%d, maxPendingMsgs=%d, maxPendingBytes=%d, valid=%b}", this.getSubject(), this.getQueue() == null ? "null" : this.getQueue(), this.getSid(), this.getMax(), this.delivered, this.getPendingMsgsLimit(), this.getPendingBytesLimit(), this.getPendingMsgsMax(), this.getPendingBytesMax(), this.isValid());
    }

    void setSlowConsumer(boolean sc) {
        this.sc = sc;
    }

    boolean isSlowConsumer() {
        return this.sc;
    }

    void setMax(long max) {
        this.max = max;
    }

    long getMax() {
        return this.max;
    }

    void lock() {
        this.mu.lock();
    }

    void unlock() {
        this.mu.unlock();
    }
}

