/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.ClosedCallback;
import io.nats.client.Connection;
import io.nats.client.ConnectionImpl;
import io.nats.client.DisconnectedCallback;
import io.nats.client.ExceptionHandler;
import io.nats.client.Options;
import io.nats.client.ReconnectedCallback;
import io.nats.client.TcpConnectionFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public class ConnectionFactory {
    private TcpConnectionFactory factory = null;
    private URI url = null;
    private String host = null;
    private int port = -1;
    private String username = null;
    private String password = null;
    private List<URI> servers = null;
    private boolean noRandomize = false;
    private String connectionName = null;
    private boolean verbose = false;
    private boolean pedantic = false;
    private boolean secure = false;
    private boolean reconnectAllowed = true;
    private int maxReconnect = 60;
    private long reconnectWait = 2000L;
    private int reconnectBufSize = 0x800000;
    private int connectionTimeout = 2000;
    private long pingInterval = 120000L;
    private int maxPingsOut = 2;
    private SSLContext sslContext;
    private ExceptionHandler exceptionHandler = null;
    private ClosedCallback closedCallback;
    private DisconnectedCallback disconnectedCallback;
    private ReconnectedCallback reconnectedCallback;
    private String urlString = null;
    private boolean tlsDebug;

    public ConnectionFactory(Properties props) {
        Options opts = new Options.Builder(props).build();
        if (props.containsKey("io.nats.client.host")) {
            this.host = props.getProperty("io.nats.client.host", "localhost");
        }
        if (props.containsKey("io.nats.client.port")) {
            this.port = Integer.parseInt(props.getProperty("io.nats.client.port", Integer.toString(4222)));
        }
        this.urlString = opts.url;
        this.url = URI.create(opts.url);
        this.username = opts.username;
        this.password = opts.password;
        if (opts.servers != null) {
            this.servers = new ArrayList<URI>(opts.servers);
        }
        this.noRandomize = opts.noRandomize;
        this.connectionName = opts.connectionName;
        this.verbose = opts.verbose;
        this.pedantic = opts.pedantic;
        this.secure = opts.secure;
        this.reconnectAllowed = opts.allowReconnect;
        this.maxReconnect = opts.maxReconnect;
        this.reconnectBufSize = opts.reconnectBufSize;
        this.reconnectWait = opts.reconnectWait;
        this.connectionTimeout = opts.connectionTimeout;
        this.pingInterval = opts.pingInterval;
        this.maxPingsOut = opts.maxPingsOut;
        this.sslContext = opts.sslContext;
        this.exceptionHandler = opts.asyncErrorCb;
        this.closedCallback = opts.closedCb;
        this.disconnectedCallback = opts.disconnectedCb;
        this.reconnectedCallback = opts.reconnectedCb;
        this.factory = opts.factory;
    }

    public ConnectionFactory() {
        this(null, null);
    }

    public ConnectionFactory(String url) {
        this(url, null);
    }

    public ConnectionFactory(String[] servers) {
        this(null, servers);
    }

    public ConnectionFactory(String url, String[] servers) {
        if (url != null && url.contains(",")) {
            this.setServers(url);
        } else {
            this.setUrl(url);
            this.setServers(servers);
        }
    }

    public ConnectionFactory(ConnectionFactory cf) {
        this.factory = cf.factory;
        this.url = cf.url;
        this.host = cf.host;
        this.port = cf.port;
        this.username = cf.username;
        this.password = cf.password;
        if (cf.servers != null) {
            this.servers = new ArrayList<URI>(cf.servers);
        }
        this.noRandomize = cf.noRandomize;
        this.connectionName = cf.connectionName;
        this.verbose = cf.verbose;
        this.pedantic = cf.pedantic;
        this.secure = cf.secure;
        this.reconnectAllowed = cf.reconnectAllowed;
        this.maxReconnect = cf.maxReconnect;
        this.reconnectBufSize = cf.reconnectBufSize;
        this.reconnectWait = cf.reconnectWait;
        this.connectionTimeout = cf.connectionTimeout;
        this.pingInterval = cf.pingInterval;
        this.maxPingsOut = cf.maxPingsOut;
        this.sslContext = cf.sslContext;
        this.exceptionHandler = cf.exceptionHandler;
        this.closedCallback = cf.closedCallback;
        this.disconnectedCallback = cf.disconnectedCallback;
        this.reconnectedCallback = cf.reconnectedCallback;
        this.urlString = cf.urlString;
        this.tlsDebug = cf.tlsDebug;
    }

    public final int hashCode() {
        return Objects.hash(this.factory, this.url, this.host, this.port, this.username, this.password, this.servers, this.noRandomize, this.connectionName, this.verbose, this.pedantic, this.secure, this.reconnectAllowed, this.maxReconnect, this.reconnectBufSize, this.reconnectWait, this.connectionTimeout, this.pingInterval, this.maxPingsOut, this.sslContext, this.exceptionHandler, this.closedCallback, this.disconnectedCallback, this.reconnectedCallback, this.urlString, this.tlsDebug);
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionFactory)) {
            return false;
        }
        return obj.hashCode() == this.hashCode();
    }

    public final Connection createConnection() throws IOException {
        return new ConnectionImpl(this.options()).connect();
    }

    protected final URI constructUri() {
        URI res = null;
        if (this.url != null) {
            res = this.url;
        } else if (this.getHost() != null) {
            String str = "nats://";
            if (this.getUsername() != null) {
                str = str.concat(this.getUsername());
                if (this.getPassword() != null) {
                    str = str.concat(":" + this.getPassword());
                }
                str = str.concat("@");
            }
            str = str.concat(this.getHost() + ":");
            str = this.getPort() > -1 ? str.concat(String.valueOf(this.getPort())) : str.concat(String.valueOf(4222));
            res = URI.create(str);
        }
        return res;
    }

    protected final Options options() {
        String urlString = null;
        if (this.url != null) {
            this.url = this.constructUri();
            urlString = this.url.toString();
        }
        Options.Builder result = new Options.Builder().userInfo(this.username, this.password);
        result.url = urlString;
        result.servers = this.servers;
        if (this.noRandomize) {
            result = result.dontRandomize();
        }
        if (this.verbose) {
            result = result.verbose();
        }
        if (this.pedantic) {
            result = result.pedantic();
        }
        if (this.secure) {
            result = result.secure();
        }
        if (this.tlsDebug) {
            result = result.tlsDebug();
        }
        if (!this.reconnectAllowed) {
            result = result.noReconnect();
        }
        result = result.factory(this.factory).maxReconnect(this.maxReconnect).reconnectWait(this.reconnectWait).reconnectBufSize(this.reconnectBufSize).name(this.connectionName).timeout(this.connectionTimeout).pingInterval(this.pingInterval).maxPingsOut(this.maxPingsOut).sslContext(this.sslContext).closedCb(this.closedCallback).disconnectedCb(this.disconnectedCallback).reconnectedCb(this.reconnectedCallback).errorCb(this.exceptionHandler);
        return result.build();
    }

    public final void setUri(URI uri) {
        String[] userpass;
        String userInfo;
        int port;
        this.url = uri;
        String scheme = uri.getScheme().toLowerCase();
        if (!("nats".equals(scheme) || "tcp".equals(scheme) || "tls".equals(scheme))) {
            throw new IllegalArgumentException("Wrong scheme in NATS URI: " + uri.getScheme());
        }
        String host = uri.getHost();
        if (host != null) {
            this.setHost(host);
        }
        if ((port = uri.getPort()) != -1) {
            this.setPort(port);
        }
        if ((userInfo = uri.getUserInfo()) != null && (userpass = userInfo.split(":"))[0].length() > 0) {
            this.setUsername(userpass[0]);
            switch (userpass.length) {
                case 1: {
                    break;
                }
                case 2: {
                    this.setPassword(userpass[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Bad user info in NATS URI: " + userInfo);
                }
            }
        }
    }

    final TcpConnectionFactory getTcpConnectionFactory() {
        return this.factory;
    }

    final void setTcpConnectionFactory(TcpConnectionFactory factory) {
        this.factory = factory;
    }

    public final String getUrlString() {
        return this.urlString;
    }

    public final void setUrl(String url) {
        if (url == null) {
            this.url = null;
        } else if (url.contains(",")) {
            this.setServers(url);
        } else {
            try {
                this.urlString = url;
                this.setUri(new URI(this.urlString));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    public final String getHost() {
        return this.host;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int port) {
        this.port = port;
    }

    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(String username) {
        this.username = username;
    }

    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final List<URI> getServers() {
        return this.servers;
    }

    public final void setServers(List<URI> servers) {
        this.servers = servers;
    }

    public final void setServers(String urlString) {
        String[] servers = urlString.trim().split("\\s*,\\s*");
        this.setServers(servers);
    }

    public final void setServers(String[] servers) {
        if (servers == null) {
            this.servers = null;
        } else {
            if (this.servers == null) {
                this.servers = new ArrayList<URI>();
            }
            this.servers.clear();
            for (String s : servers) {
                try {
                    this.servers.add(new URI(s.trim()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public final boolean isNoRandomize() {
        return this.noRandomize;
    }

    public final void setNoRandomize(boolean noRandomize) {
        this.noRandomize = noRandomize;
    }

    public final String getConnectionName() {
        return this.connectionName;
    }

    public final void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public final boolean isVerbose() {
        return this.verbose;
    }

    public final void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public final boolean isPedantic() {
        return this.pedantic;
    }

    public final void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public final boolean isSecure() {
        return this.secure;
    }

    public final void setSecure(boolean secure) {
        this.secure = secure;
    }

    public final boolean isTlsDebug() {
        return this.tlsDebug;
    }

    public final void setTlsDebug(boolean debug) {
        this.tlsDebug = debug;
    }

    public final boolean isReconnectAllowed() {
        return this.reconnectAllowed;
    }

    public final void setReconnectAllowed(boolean reconnectAllowed) {
        this.reconnectAllowed = reconnectAllowed;
    }

    public final int getMaxReconnect() {
        return this.maxReconnect;
    }

    public final void setMaxReconnect(int max) {
        this.maxReconnect = max;
    }

    public final long getReconnectWait() {
        return this.reconnectWait;
    }

    public final void setReconnectBufSize(int size) {
        this.reconnectBufSize = size <= 0 ? 0x800000 : size;
    }

    public final long getReconnectBufSize() {
        return this.reconnectBufSize;
    }

    public final void setReconnectWait(long interval) {
        this.reconnectWait = interval;
    }

    public final int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final void setConnectionTimeout(int timeout) {
        if (timeout < 0) {
            throw new IllegalArgumentException("TCP connection timeout cannot be negative");
        }
        this.connectionTimeout = timeout;
    }

    public final long getPingInterval() {
        return this.pingInterval;
    }

    public final void setPingInterval(long interval) {
        this.pingInterval = interval;
    }

    public final int getMaxPingsOut() {
        return this.maxPingsOut;
    }

    public final void setMaxPingsOut(int max) {
        this.maxPingsOut = max;
    }

    public final ClosedCallback getClosedCallback() {
        return this.closedCallback;
    }

    public final void setClosedCallback(ClosedCallback cb) {
        this.closedCallback = cb;
    }

    public final DisconnectedCallback getDisconnectedCallback() {
        return this.disconnectedCallback;
    }

    public final void setDisconnectedCallback(DisconnectedCallback cb) {
        this.disconnectedCallback = cb;
    }

    public final ReconnectedCallback getReconnectedCallback() {
        return this.reconnectedCallback;
    }

    public final void setReconnectedCallback(ReconnectedCallback cb) {
        this.reconnectedCallback = cb;
    }

    public final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public final void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == null) {
            throw new IllegalArgumentException("ExceptionHandler cannot be null!");
        }
        this.exceptionHandler = exceptionHandler;
    }

    @Deprecated
    public final SSLContext getSslContext() {
        return this.sslContext;
    }

    public final SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Deprecated
    public final void setSslContext(SSLContext ctx) {
        this.setSSLContext(ctx);
    }

    public final void setSSLContext(SSLContext ctx) {
        this.sslContext = ctx;
    }
}

