/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityColumnFactory;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;
import java.util.List;
import java.util.Optional;

public class DefaultEntityColumnFactoryChain
implements EntityColumnFactory.Chain {
    private final List<EntityColumnFactory> factories;
    private final DefaultEntityColumnFactoryChain next;
    private final int index;

    public DefaultEntityColumnFactoryChain(List<EntityColumnFactory> factories) {
        this(factories, 0);
    }

    private DefaultEntityColumnFactoryChain(List<EntityColumnFactory> factories, int index) {
        this.factories = factories;
        this.index = index;
        this.next = this.index < this.factories.size() ? new DefaultEntityColumnFactoryChain(factories, this.index + 1) : null;
    }

    @Override
    public Optional<List<EntityColumn>> createEntityColumn(EntityTable entityTable, EntityField field) {
        if (this.index < this.factories.size()) {
            return this.factories.get(this.index).createEntityColumn(entityTable, field, this.next);
        }
        return null;
    }
}

