/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.Entity;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityColumnFactory;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class DefaultEntityColumnFactory
implements EntityColumnFactory {
    @Override
    public Optional<List<EntityColumn>> createEntityColumn(EntityTable entityTable, EntityField field, EntityColumnFactory.Chain chain) {
        if (field.isAnnotationPresent(Entity.Column.class)) {
            Entity.Column column = field.getAnnotation(Entity.Column.class);
            String columnName = column.value();
            if (columnName.isEmpty()) {
                columnName = field.getName();
            }
            EntityColumn entityColumn = EntityColumn.of(field).column(columnName).id(column.id()).orderBy(column.orderBy()).orderByPriority(column.orderByPriority()).selectable(column.selectable()).insertable(column.insertable()).updatable(column.updatable()).jdbcType(column.jdbcType()).typeHandler(column.typeHandler()).numericScale(column.numericScale());
            for (Entity.Prop prop : column.props()) {
                entityColumn.setProp(prop);
            }
            return Optional.of(Arrays.asList(entityColumn));
        }
        return Optional.empty();
    }
}

