/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider.defaults;

import io.mybatis.provider.SqlScriptWrapper;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.ibatis.annotations.Param;

public abstract class AnnotationSqlWrapper
implements SqlScriptWrapper {
    protected final ElementType type;
    protected final Object target;
    protected final Annotation[] annotations;

    public AnnotationSqlWrapper(Object target, ElementType type, Annotation[] annotations) {
        this.type = type;
        this.target = target;
        this.annotations = annotations;
    }

    public ElementType getType() {
        return this.type;
    }

    public Object getTarget() {
        return this.target;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public String getParameterName(Parameter parameter) {
        int index;
        Optional<Annotation> paramOptional = Stream.of(this.annotations).filter(a -> a.annotationType() == Param.class).findFirst();
        if (paramOptional.isPresent()) {
            return ((Param)paramOptional.get()).value();
        }
        Executable executable = parameter.getDeclaringExecutable();
        if (executable.getParameterCount() == 1) {
            return "_parameter";
        }
        String name = parameter.getName();
        if (!name.startsWith("arg")) {
            return name;
        }
        Parameter[] parameters = executable.getParameters();
        for (index = 0; index < parameters.length && parameters[index] != parameter; ++index) {
        }
        if (!name.equals("arg" + index)) {
            return name;
        }
        return "param" + (index + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationSqlWrapper that = (AnnotationSqlWrapper)o;
        return this.type == that.type && this.target.equals(that.target);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.target});
    }
}

