/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.Entity;
import io.mybatis.provider.util.Utils;
import java.util.Map;
import java.util.Properties;

public class EntityProps<T extends EntityProps> {
    protected Properties props;

    public <V> V getProp(String prop) {
        return (V)(this.props != null ? this.props.get(prop) : null);
    }

    public <V> V getProp(String prop, V def) {
        V val = this.getProp(prop);
        return val != null ? val : def;
    }

    public T setProp(String prop, Object value) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(prop, value);
        return (T)this;
    }

    public T setProp(Entity.Prop prop) {
        if (this.props == null) {
            this.props = new Properties();
        }
        this.props.put(prop.name(), EntityProps.getEntityPropValue(prop));
        return (T)this;
    }

    public <K, V> T setProps(Map<K, V> props) {
        if (this.props == null) {
            this.props = new Properties();
        }
        if (Utils.isNotEmpty(props)) {
            this.props.putAll(props);
        }
        return (T)this;
    }

    public <V> V removeProp(String prop) {
        if (this.props != null) {
            V value = this.getProp(prop);
            this.props.remove(prop);
            return value;
        }
        return null;
    }

    public static Object getEntityPropValue(Entity.Prop prop) {
        Class type = prop.type();
        if (type == Boolean.class) {
            return Boolean.parseBoolean(prop.value());
        }
        if (type == Integer.class) {
            return Integer.parseInt(prop.value());
        }
        if (type == Long.class) {
            return Long.parseLong(prop.value());
        }
        if (type == Double.class) {
            return Double.parseDouble(prop.value());
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(prop.value()));
        }
        return prop.value();
    }

    public Properties props() {
        return this.props;
    }
}

