/*
 * Decompiled with CFR 0.152.
 */
package io.mybatis.provider;

import io.mybatis.provider.EntityClassFinder;
import io.mybatis.provider.EntityColumn;
import io.mybatis.provider.EntityColumnFactory;
import io.mybatis.provider.EntityField;
import io.mybatis.provider.EntityTable;
import io.mybatis.provider.EntityTableFactory;
import io.mybatis.provider.defaults.DefaultEntityColumnFactoryChain;
import io.mybatis.provider.defaults.DefaultEntityTableFactoryChain;
import io.mybatis.provider.util.ServiceLoaderUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;

public abstract class EntityFactory {
    public static EntityTable create(Class<?> mapperType, Method mapperMethod) {
        Optional<Class<?>> optionalClass = EntityClassFinder.find(mapperType, mapperMethod);
        if (optionalClass.isPresent()) {
            return EntityFactory.create(optionalClass.get());
        }
        throw new RuntimeException("Can't obtain " + (mapperMethod != null ? mapperMethod.getName() + " method" : mapperType.getSimpleName() + " interface") + " corresponding entity class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntityTable create(Class<?> entityClass) {
        EntityTableFactory.Chain entityTableFactoryChain = Instance.getEntityTableFactoryChain();
        EntityTable entityTable = entityTableFactoryChain.createEntityTable(entityClass);
        if (entityTable == null) {
            throw new NullPointerException("Unable to get " + entityClass.getName() + " entity class information");
        }
        if (!entityTable.ready()) {
            Class<?> clazz = entityClass;
            synchronized (clazz) {
                if (!entityTable.ready()) {
                    EntityColumnFactory.Chain entityColumnFactoryChain = Instance.getEntityColumnFactoryChain();
                    boolean isSuperclass = false;
                    for (Class<?> declaredClass = entityClass; declaredClass != null && declaredClass != Object.class; declaredClass = declaredClass.getSuperclass()) {
                        Object[] declaredFields = declaredClass.getDeclaredFields();
                        if (isSuperclass) {
                            EntityFactory.reverse(declaredFields);
                        }
                        for (Object field : declaredFields) {
                            int modifiers = ((Field)field).getModifiers();
                            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                            EntityField entityField = new EntityField(entityClass, (Field)field);
                            Optional<List<EntityColumn>> optionalEntityColumns = entityColumnFactoryChain.createEntityColumn(entityTable, entityField);
                            optionalEntityColumns.ifPresent(columns -> columns.forEach(entityTable::addColumn));
                        }
                        isSuperclass = true;
                    }
                    entityTable.ready(true);
                }
            }
        }
        return entityTable;
    }

    protected static void reverse(Object[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            Object temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }

    static class Instance {
        private static volatile EntityTableFactory.Chain entityTableFactoryChain;
        private static volatile EntityColumnFactory.Chain entityColumnFactoryChain;

        Instance() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static EntityTableFactory.Chain getEntityTableFactoryChain() {
            if (entityTableFactoryChain != null) return entityTableFactoryChain;
            Class<EntityFactory> clazz = EntityFactory.class;
            synchronized (EntityFactory.class) {
                if (entityTableFactoryChain != null) return entityTableFactoryChain;
                List<EntityTableFactory> entityTableFactories = ServiceLoaderUtil.getInstances(EntityTableFactory.class);
                entityTableFactoryChain = new DefaultEntityTableFactoryChain(entityTableFactories);
                // ** MonitorExit[var0] (shouldn't be in output)
                return entityTableFactoryChain;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static EntityColumnFactory.Chain getEntityColumnFactoryChain() {
            if (entityColumnFactoryChain != null) return entityColumnFactoryChain;
            Class<EntityFactory> clazz = EntityFactory.class;
            synchronized (EntityFactory.class) {
                if (entityColumnFactoryChain != null) return entityColumnFactoryChain;
                List<EntityColumnFactory> entityColumnFactories = ServiceLoaderUtil.getInstances(EntityColumnFactory.class);
                entityColumnFactoryChain = new DefaultEntityColumnFactoryChain(entityColumnFactories);
                // ** MonitorExit[var0] (shouldn't be in output)
                return entityColumnFactoryChain;
            }
        }
    }
}

