/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.role;

import io.milvus.exception.ParamException;
import io.milvus.param.ParamUtils;
import lombok.NonNull;

public class GrantRolePrivilegeParam {
    private final String roleName;
    private final String object;
    private final String objectName;
    private final String privilege;

    private GrantRolePrivilegeParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.roleName = builder.roleName;
        this.object = builder.object;
        this.objectName = builder.objectName;
        this.privilege = builder.privilege;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getRoleName() {
        return this.roleName;
    }

    public String getObject() {
        return this.object;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getPrivilege() {
        return this.privilege;
    }

    public String toString() {
        return "GrantRolePrivilegeParam(roleName=" + this.getRoleName() + ", object=" + this.getObject() + ", objectName=" + this.getObjectName() + ", privilege=" + this.getPrivilege() + ")";
    }

    public static final class Builder {
        private String roleName;
        private String object;
        private String objectName;
        private String privilege;

        private Builder() {
        }

        public Builder withRoleName(@NonNull String roleName) {
            if (roleName == null) {
                throw new NullPointerException("roleName is marked non-null but is null");
            }
            this.roleName = roleName;
            return this;
        }

        public Builder withObject(@NonNull String object) {
            if (object == null) {
                throw new NullPointerException("object is marked non-null but is null");
            }
            this.object = object;
            return this;
        }

        public Builder withObjectName(@NonNull String objectName) {
            if (objectName == null) {
                throw new NullPointerException("objectName is marked non-null but is null");
            }
            this.objectName = objectName;
            return this;
        }

        public Builder withPrivilege(@NonNull String privilege) {
            if (privilege == null) {
                throw new NullPointerException("privilege is marked non-null but is null");
            }
            this.privilege = privilege;
            return this;
        }

        public GrantRolePrivilegeParam build() throws ParamException {
            ParamUtils.CheckNullEmptyString(this.roleName, "RoleName");
            ParamUtils.CheckNullEmptyString(this.object, "Object");
            ParamUtils.CheckNullEmptyString(this.objectName, "ObjectName");
            ParamUtils.CheckNullEmptyString(this.privilege, "Privilege");
            return new GrantRolePrivilegeParam(this);
        }
    }
}

