/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.param.control;

import io.milvus.exception.ParamException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class GetFlushStateParam {
    private final List<Long> segmentIDs;

    private GetFlushStateParam(@NonNull Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.segmentIDs = builder.segmentIDs;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String toString() {
        return "GetFlushStateParam{segmentIDs=" + this.segmentIDs.toString() + '}';
    }

    public List<Long> getSegmentIDs() {
        return this.segmentIDs;
    }

    public static final class Builder {
        private final List<Long> segmentIDs = new ArrayList<Long>();

        private Builder() {
        }

        public Builder withSegmentIDs(@NonNull List<Long> segmentIDs) {
            if (segmentIDs == null) {
                throw new NullPointerException("segmentIDs is marked non-null but is null");
            }
            this.segmentIDs.addAll(segmentIDs);
            return this;
        }

        public Builder addSegmentID(@NonNull Long segmentID) {
            if (segmentID == null) {
                throw new NullPointerException("segmentID is marked non-null but is null");
            }
            this.segmentIDs.add(segmentID);
            return this;
        }

        public GetFlushStateParam build() throws ParamException {
            if (this.segmentIDs.isEmpty()) {
                throw new ParamException("Segment id array cannot be empty");
            }
            return new GetFlushStateParam(this);
        }
    }
}

