/*
 * Decompiled with CFR 0.152.
 */
package io.milvus.client;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class InsertParam {
    private final String collectionName;
    private final List<List<Float>> floatVectors;
    private final List<ByteBuffer> binaryVectors;
    private final List<Long> vectorIds;
    private final String partitionTag;

    private InsertParam(@Nonnull Builder builder) {
        this.collectionName = builder.collectionName;
        this.floatVectors = builder.floatVectors;
        this.binaryVectors = builder.binaryVectors;
        this.vectorIds = builder.vectorIds;
        this.partitionTag = builder.partitionTag;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<List<Float>> getFloatVectors() {
        return this.floatVectors;
    }

    public List<ByteBuffer> getBinaryVectors() {
        return this.binaryVectors;
    }

    public List<Long> getVectorIds() {
        return this.vectorIds;
    }

    public String getPartitionTag() {
        return this.partitionTag;
    }

    public static class Builder {
        private final String collectionName;
        private List<List<Float>> floatVectors = new ArrayList<List<Float>>();
        private List<ByteBuffer> binaryVectors = new ArrayList<ByteBuffer>();
        private List<Long> vectorIds = new ArrayList<Long>();
        private String partitionTag = "";

        public Builder(@Nonnull String collectionName) {
            this.collectionName = collectionName;
        }

        public Builder withFloatVectors(@Nonnull List<List<Float>> floatVectors) {
            this.floatVectors = floatVectors;
            return this;
        }

        public Builder withBinaryVectors(@Nonnull List<ByteBuffer> binaryVectors) {
            this.binaryVectors = binaryVectors;
            return this;
        }

        public Builder withVectorIds(@Nonnull List<Long> vectorIds) {
            this.vectorIds = vectorIds;
            return this;
        }

        public Builder withPartitionTag(@Nonnull String partitionTag) {
            this.partitionTag = partitionTag;
            return this;
        }

        public InsertParam build() {
            return new InsertParam(this);
        }
    }
}

