/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.writer;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.MutableHttpRequest;
import io.micronaut.multitenancy.writer.HttpHeaderTenantWriterConfiguration;
import io.micronaut.multitenancy.writer.TenantWriter;
import jakarta.inject.Singleton;
import java.io.Serializable;

@Singleton
@Requirements(value={@Requires(property="micronaut.multitenancy.tenantwriter.httpheader.enabled"), @Requires(beans={HttpHeaderTenantWriterConfiguration.class})})
public class HttpHeaderTenantWriter
implements TenantWriter {
    protected final HttpHeaderTenantWriterConfiguration httpHeaderTenantWriterConfiguration;

    public HttpHeaderTenantWriter(HttpHeaderTenantWriterConfiguration httpHeaderTenantWriterConfiguration) {
        this.httpHeaderTenantWriterConfiguration = httpHeaderTenantWriterConfiguration;
    }

    protected String getHeaderName() {
        return this.httpHeaderTenantWriterConfiguration.getHeaderName();
    }

    @Override
    public void writeTenant(MutableHttpRequest<?> request, Serializable tenant) {
        if (tenant instanceof CharSequence) {
            request.header((CharSequence)this.getHeaderName(), (CharSequence)((Object)tenant));
        }
    }
}

