/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixList;
import de.malkusch.whoisServerList.publicSuffixList.PublicSuffixListFactory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.server.util.HttpHostResolver;
import io.micronaut.multitenancy.tenantresolver.AbstractSubdomainTenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;

@Singleton
@Requirements(value={@Requires(classes={PublicSuffixList.class}), @Requires(bean=HttpHostResolver.class), @Requires(property="micronaut.multitenancy.tenantresolver.subdomain.publicsuffixlist.enabled", value="true", defaultValue="true"), @Requires(property="micronaut.multitenancy.tenantresolver.subdomain.enabled", value="true", defaultValue="false")})
public class PublicSuffixListSubdomainTenantResolver
extends AbstractSubdomainTenantResolver {
    private final PublicSuffixList suffixList;

    PublicSuffixListSubdomainTenantResolver(HttpHostResolver httpHostResolver) {
        super(httpHostResolver);
        PublicSuffixListFactory factory = new PublicSuffixListFactory();
        this.suffixList = factory.build();
    }

    @Override
    @NonNull
    protected Serializable resolveSubdomain(@NonNull String host) {
        int index;
        String domain = this.suffixList.getRegistrableDomain(host);
        if (domain != null && (index = host.lastIndexOf("." + domain)) != -1) {
            return host.substring(0, index);
        }
        return "DEFAULT";
    }
}

