/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.multitenancy.tenantresolver;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.context.ServerRequestContext;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.multitenancy.exceptions.TenantNotFoundException;
import io.micronaut.multitenancy.tenantresolver.CookieTenantResolverConfiguration;
import io.micronaut.multitenancy.tenantresolver.HttpRequestTenantResolver;
import io.micronaut.multitenancy.tenantresolver.TenantResolver;
import jakarta.inject.Singleton;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;

@Singleton
@Requirements(value={@Requires(beans={CookieTenantResolverConfiguration.class}), @Requires(property="micronaut.multitenancy.tenantresolver.cookie.enabled", value="true", defaultValue="false")})
public class CookieTenantResolver
implements TenantResolver,
HttpRequestTenantResolver {
    protected String cookiename = "tenantId";

    public CookieTenantResolver(@NonNull CookieTenantResolverConfiguration configuration) {
        if (configuration != null) {
            this.cookiename = configuration.getCookiename();
        }
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier() throws TenantNotFoundException {
        Optional current = ServerRequestContext.currentRequest();
        return current.map(this::resolveTenantIdentifier).orElseThrow(() -> new TenantNotFoundException("Tenant could not be resolved outside a web request"));
    }

    @Override
    @NonNull
    public Serializable resolveTenantIdentifier(@NonNull HttpRequest<?> request) throws TenantNotFoundException {
        Optional optionalTenantId;
        if (Objects.requireNonNull(request, "request must not be null").getCookies() != null && (optionalTenantId = request.getCookies().findCookie((CharSequence)this.cookiename)).isPresent()) {
            return ((Cookie)optionalTenantId.get()).getValue();
        }
        throw new TenantNotFoundException("Tenant could not be resolved from the Cookie: " + this.cookiename);
    }
}

