/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core.serde;

import io.micronaut.core.type.Argument;
import io.micronaut.serde.Decoder;
import io.micronaut.serde.Deserializer;
import io.micronaut.serde.Encoder;
import io.micronaut.serde.LimitingStream;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.Serializer;
import io.micronaut.serde.bson.BsonReaderDecoder;
import io.micronaut.serde.bson.BsonWriterEncoder;
import java.io.IOException;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class SerdeCodec<T>
implements Codec<T> {
    protected final SerdeRegistry dataSerdeRegistry;
    protected final Class<T> type;
    protected final Argument<T> argument;
    protected final Serializer<? super T> serializer;
    protected final Deserializer<? extends T> deserializer;
    protected final CodecRegistry codecRegistry;
    private final Deserializer.DecoderContext decoderContext;
    private final Serializer.EncoderContext encoderContext;

    SerdeCodec(SerdeRegistry dataSerdeRegistry, Class<T> type, CodecRegistry codecRegistry) {
        this.dataSerdeRegistry = dataSerdeRegistry;
        this.type = type;
        this.argument = Argument.of(type);
        this.codecRegistry = codecRegistry;
        this.decoderContext = dataSerdeRegistry.newDecoderContext(type);
        this.encoderContext = dataSerdeRegistry.newEncoderContext(type);
        try {
            this.serializer = dataSerdeRegistry.findSerializer(this.argument).createSpecific(this.encoderContext, this.argument);
            this.deserializer = dataSerdeRegistry.findDeserializer(this.argument).createSpecific(this.decoderContext, this.argument);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot find serialize/deserializer for type: " + type + ". " + e.getMessage(), e);
        }
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        try {
            return (T)this.deserializer.deserialize((Decoder)new BsonReaderDecoder(reader, LimitingStream.DEFAULT_LIMITS), this.decoderContext, this.argument);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot deserialize: " + this.type, e);
        }
    }

    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        try {
            this.serializer.serialize((Encoder)new BsonWriterEncoder(writer, LimitingStream.DEFAULT_LIMITS), this.encoderContext, this.argument, value);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot serialize: " + value, e);
        }
    }

    public Class<T> getEncoderClass() {
        return this.type;
    }
}

