/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core.convert;

import com.mongodb.ReadPreference;
import io.micronaut.core.convert.ConversionContext;
import io.micronaut.core.convert.TypeConverter;
import java.util.Locale;
import java.util.Optional;

public class StringToReadPreferenceConverter
implements TypeConverter<CharSequence, ReadPreference> {
    public Optional<ReadPreference> convert(CharSequence object, Class<ReadPreference> targetType, ConversionContext context) {
        String readConcern;
        switch (readConcern = object.toString().toUpperCase(Locale.ENGLISH)) {
            case "PRIMARY": {
                return Optional.of(ReadPreference.primary());
            }
            case "PRIMARY_PREFERRED": {
                return Optional.of(ReadPreference.primaryPreferred());
            }
            case "SECONDARY": {
                return Optional.of(ReadPreference.secondary());
            }
            case "SECONDARY_PREFERRED": {
                return Optional.of(ReadPreference.secondaryPreferred());
            }
            case "NEAREST": {
                return Optional.of(ReadPreference.nearest());
            }
        }
        return Optional.empty();
    }
}

