/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core.test;

import com.mongodb.ConnectionString;
import de.flapdoodle.embed.mongo.MongodProcess;
import io.micronaut.configuration.mongo.core.DefaultMongoConfiguration;
import io.micronaut.configuration.mongo.core.test.AbstractMongoProcessFactory;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.BeanCreatedEvent;
import io.micronaut.context.event.BeanCreatedEventListener;
import io.micronaut.context.exceptions.ConfigurationException;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.PreDestroy;

@Requirements(value={@Requires(classes={MongodProcess.class}), @Requires(beans={DefaultMongoConfiguration.class}), @Requires(env={"test"}), @Requires(property="mongodb.embedded.enabled", notEquals="false", defaultValue="true")})
@Singleton
public class MongoProcessFactory
extends AbstractMongoProcessFactory
implements BeanCreatedEventListener<DefaultMongoConfiguration>,
Closeable {
    public DefaultMongoConfiguration onCreated(BeanCreatedEvent<DefaultMongoConfiguration> event) {
        DefaultMongoConfiguration configuration = (DefaultMongoConfiguration)event.getBean();
        try {
            Optional<ConnectionString> connectionString = configuration.getConnectionString();
            this.startEmbeddedMongoIfPossible(connectionString.orElse(null), null);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error starting Embedded MongoDB server: " + e.getMessage(), (Throwable)e);
        }
        return configuration;
    }

    @Override
    @PreDestroy
    public void close() throws IOException {
        if (this.process != null) {
            this.process.stop();
        }
    }
}

