/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.configuration.mongo.core.CodecRegistryBuilder;
import io.micronaut.context.annotation.ConfigurationBuilder;
import io.micronaut.context.annotation.ConfigurationProperties;
import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.runtime.ApplicationConfiguration;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistry;

@Requirements(value={@Requires(property="mongodb"), @Requires(missingProperty="mongodb.servers")})
@ConfigurationProperties(value="mongodb")
public class DefaultMongoConfiguration
extends AbstractMongoConfiguration {
    @ConfigurationBuilder(prefixes={""})
    protected MongoClientSettings.Builder clientSettings = MongoClientSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="cluster")
    protected ClusterSettings.Builder clusterSettings = ClusterSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="server")
    protected ServerSettings.Builder serverSettings = ServerSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="connection-pool")
    protected ConnectionPoolSettings.Builder poolSettings = ConnectionPoolSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="socket")
    protected SocketSettings.Builder socketSettings = SocketSettings.builder();
    @ConfigurationBuilder(prefixes={""}, configurationPrefix="ssl")
    protected SslSettings.Builder sslSettings = SslSettings.builder();

    public DefaultMongoConfiguration(ApplicationConfiguration applicationConfiguration) {
        super(applicationConfiguration);
    }

    @Inject
    public DefaultMongoConfiguration(ApplicationConfiguration applicationConfiguration, Environment environment) {
        super(applicationConfiguration);
        if (environment != null) {
            this.setPackageNames(environment.getPackages());
        }
    }

    @Override
    @Inject
    public void codecs(List<Codec<?>> codecList) {
        super.codecs(codecList);
    }

    @Override
    @Inject
    public void codecRegistries(List<CodecRegistry> codecRegistries) {
        super.codecRegistries(codecRegistries);
    }

    @Override
    @Inject
    public void setCodecRegistryBuilder(CodecRegistryBuilder codecRegistryBuilder) {
        super.setCodecRegistryBuilder(codecRegistryBuilder);
    }

    @Override
    @Inject
    public void commandListeners(List<CommandListener> commandListeners) {
        super.commandListeners(commandListeners);
    }

    @Override
    @Inject
    public void connectionPoolListeners(List<ConnectionPoolListener> connectionPoolListeners) {
        super.connectionPoolListeners(connectionPoolListeners);
    }

    public void setHost(ServerAddress serverAddress) {
        this.getClusterSettings().hosts(Collections.singletonList(serverAddress));
    }

    public void setHosts(List<ServerAddress> serverAddresses) {
        if (serverAddresses != null) {
            this.getClusterSettings().hosts(serverAddresses);
        }
    }

    @Override
    public ClusterSettings.Builder getClusterSettings() {
        return this.clusterSettings;
    }

    @Override
    public MongoClientSettings.Builder getClientSettings() {
        return this.clientSettings;
    }

    @Override
    public ServerSettings.Builder getServerSettings() {
        return this.serverSettings;
    }

    @Override
    public ConnectionPoolSettings.Builder getPoolSettings() {
        return this.poolSettings;
    }

    @Override
    public SocketSettings.Builder getSocketSettings() {
        return this.socketSettings;
    }

    @Override
    public SslSettings.Builder getSslSettings() {
        return this.sslSettings;
    }

    public String toString() {
        return "DefaultMongoConfiguration{uri='" + this.getUri() + '\'' + ", clientSettings=" + this.clientSettings + ", clusterSettings=" + this.clusterSettings + '}';
    }
}

