/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.configuration.mongo.core;

import com.mongodb.MongoClientSettings;
import io.micronaut.configuration.mongo.core.AbstractMongoConfiguration;
import io.micronaut.configuration.mongo.core.CodecRegistryBuilder;
import io.micronaut.configuration.mongo.core.serde.DataCodecRegistry;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.annotation.Prototype;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.serde.SerdeRegistry;
import io.micronaut.serde.annotation.Serdeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.PojoCodecProvider;

@Prototype
@Requires(missingBeans={CodecRegistryBuilder.class})
@Internal
public final class DefaultCodecRegistryBuilder
implements CodecRegistryBuilder {
    private final Environment environment;
    private final BeanProvider<SerdeRegistry> serdeRegistry;

    public DefaultCodecRegistryBuilder(Environment environment, BeanProvider<SerdeRegistry> serdeRegistry) {
        this.environment = environment;
        this.serdeRegistry = serdeRegistry;
    }

    @Override
    public CodecRegistry build(AbstractMongoConfiguration configuration) {
        List<Codec<?>> codecList;
        ArrayList<CodecRegistry> codecRegistries = new ArrayList<CodecRegistry>();
        List<CodecRegistry> configuredCodecRegistries = configuration.getCodecRegistries();
        if (configuredCodecRegistries != null) {
            codecRegistries.addAll(configuredCodecRegistries);
        }
        if ((codecList = configuration.getCodecs()) != null) {
            codecRegistries.add(CodecRegistries.fromCodecs(codecList));
        }
        codecRegistries.add(MongoClientSettings.getDefaultCodecRegistry());
        Collection<String> packageNames = configuration.getPackageNames();
        if (configuration.isUseSerde()) {
            Collection entities = Stream.concat(this.environment.scan(Serdeable.Serializable.class, packageNames.toArray(new String[0])), this.environment.scan(Serdeable.Deserializable.class, packageNames.toArray(new String[0]))).collect(Collectors.toSet());
            codecRegistries.add(new DataCodecRegistry(entities, (SerdeRegistry)this.serdeRegistry.find(null).orElseThrow(() -> new IllegalStateException("SerdeRegistry is not configured! Make sure you have added Micronaut Serialization BSON dependency."))));
        } else {
            PojoCodecProvider.Builder builder = PojoCodecProvider.builder();
            if (CollectionUtils.isNotEmpty(packageNames)) {
                builder.register(packageNames.toArray(new String[0]));
            }
            codecRegistries.add(CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{builder.automatic(configuration.isAutomaticClassModels()).build()}));
        }
        return CodecRegistries.fromRegistries(codecRegistries);
    }
}

