/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.web.router;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.order.OrderUtil;
import io.micronaut.core.reflect.ClassUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.SupplierUtil;
import io.micronaut.http.HttpAttributes;
import io.micronaut.http.HttpMethod;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.annotation.FilterMatcher;
import io.micronaut.http.filter.FilterPatternStyle;
import io.micronaut.http.filter.FilterRunner;
import io.micronaut.http.filter.GenericHttpFilter;
import io.micronaut.http.filter.HttpFilterResolver;
import io.micronaut.http.filter.HttpServerFilterResolver;
import io.micronaut.http.uri.UriMatchTemplate;
import io.micronaut.web.router.ErrorRoute;
import io.micronaut.web.router.ErrorRouteInfo;
import io.micronaut.web.router.FilterRoute;
import io.micronaut.web.router.RequestMatcher;
import io.micronaut.web.router.RouteBuilder;
import io.micronaut.web.router.RouteInfo;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.Router;
import io.micronaut.web.router.StatusRoute;
import io.micronaut.web.router.StatusRouteInfo;
import io.micronaut.web.router.UriRoute;
import io.micronaut.web.router.UriRouteInfo;
import io.micronaut.web.router.UriRouteMatch;
import io.micronaut.web.router.exceptions.RoutingException;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;

@Singleton
public class DefaultRouter
implements Router,
HttpServerFilterResolver<RouteMatch<?>> {
    private static final UriRouteInfo<Object, Object>[] EMPTY = new UriRouteInfo[0];
    private final Map<String, UriRouteInfo<Object, Object>[]> routesByMethod;
    private final StatusRouteInfo<Object, Object>[] statusRoutes;
    private final ErrorRouteInfo<Object, Object>[] errorRoutes;
    private final Set<Integer> exposedPorts;
    @Nullable
    private Set<Integer> ports;
    private final List<FilterRoute> alwaysMatchesFilterRoutes = new ArrayList<FilterRoute>();
    private final List<FilterRoute> preconditionFilterRoutes = new ArrayList<FilterRoute>();
    private final Supplier<List<GenericHttpFilter>> alwaysMatchesHttpFilters = SupplierUtil.memoized(() -> {
        if (this.alwaysMatchesFilterRoutes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GenericHttpFilter> httpFilters = new ArrayList<GenericHttpFilter>(this.alwaysMatchesFilterRoutes.size());
        for (FilterRoute filterRoute : this.alwaysMatchesFilterRoutes) {
            httpFilters.add(filterRoute.getFilter());
        }
        FilterRunner.sort(httpFilters);
        return httpFilters;
    });

    public DefaultRouter(RouteBuilder ... builders) {
        this(Arrays.asList(builders));
    }

    @Inject
    public DefaultRouter(Collection<RouteBuilder> builders) {
        HashSet<Integer> exposedPorts = new HashSet<Integer>(5);
        ArrayList<FilterRoute> filterRoutes = new ArrayList<FilterRoute>();
        HashMap routesByMethod = CollectionUtils.newHashMap((int)HttpMethod.values().length);
        LinkedHashSet<RouteInfo> statusRoutes = new LinkedHashSet<RouteInfo>();
        LinkedHashSet<RouteInfo> errorRoutes = new LinkedHashSet<RouteInfo>();
        for (RouteBuilder builder : builders) {
            RequestMatcher existing;
            RouteInfo routeInfo;
            List<UriRoute> constructedRoutes = builder.getUriRoutes();
            for (UriRoute route : constructedRoutes) {
                String key = route.getHttpMethodName();
                RouteInfo uriRouteInfo = route.toRouteInfo();
                routesByMethod.computeIfAbsent(key, x -> new ArrayList()).add(uriRouteInfo);
            }
            for (StatusRoute statusRoute : builder.getStatusRoutes()) {
                routeInfo = statusRoute.toRouteInfo();
                if (statusRoutes.contains(routeInfo)) {
                    existing = statusRoutes.stream().filter(arg_0 -> DefaultRouter.lambda$new$2((StatusRouteInfo)routeInfo, arg_0)).findFirst().orElse(null);
                    throw new RoutingException("Attempted to register multiple local routes for http status [" + statusRoute.status() + "]. New route: " + statusRoute + ". Existing: " + existing);
                }
                statusRoutes.add(routeInfo);
            }
            for (ErrorRoute errorRoute : builder.getErrorRoutes()) {
                routeInfo = errorRoute.toRouteInfo();
                if (errorRoutes.contains(routeInfo)) {
                    existing = errorRoutes.stream().filter(arg_0 -> DefaultRouter.lambda$new$3((ErrorRouteInfo)routeInfo, arg_0)).findFirst().orElse(null);
                    throw new RoutingException("Attempted to register multiple local routes for error [" + errorRoute.exceptionType().getSimpleName() + "]. New route: " + errorRoute + ". Existing: " + (ErrorRouteInfo)existing);
                }
                errorRoutes.add(routeInfo);
            }
            filterRoutes.addAll(builder.getFilterRoutes());
            exposedPorts.addAll(builder.getExposedPorts());
        }
        this.exposedPorts = CollectionUtils.isNotEmpty(exposedPorts) ? exposedPorts : Collections.emptySet();
        routesByMethod.values().forEach(this::finalizeRoutes);
        for (FilterRoute filterRoute : filterRoutes) {
            if (this.isMatchesAll(filterRoute)) {
                this.alwaysMatchesFilterRoutes.add(filterRoute);
                continue;
            }
            this.preconditionFilterRoutes.add(filterRoute);
        }
        HashMap map = CollectionUtils.newHashMap((int)routesByMethod.size());
        for (Map.Entry e : routesByMethod.entrySet()) {
            map.put((String)e.getKey(), this.finalizeRoutes((List)e.getValue()));
        }
        this.routesByMethod = map;
        this.statusRoutes = (StatusRouteInfo[])statusRoutes.toArray(StatusRouteInfo[]::new);
        this.errorRoutes = (ErrorRouteInfo[])errorRoutes.toArray(ErrorRouteInfo[]::new);
    }

    private boolean isMatchesAll(FilterRoute filterRoute) {
        if (filterRoute.getAnnotationMetadata().hasStereotype(FilterMatcher.NAME)) {
            return false;
        }
        if (filterRoute.hasMethods()) {
            return false;
        }
        if (filterRoute.hasPatterns()) {
            for (String pattern : filterRoute.getPatterns()) {
                if ("/**".equals(pattern)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<Integer> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public void applyDefaultPorts(List<Integer> ports) {
        this.ports = new HashSet<Integer>(ports);
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request, @NonNull CharSequence uri) {
        return this.toMatches(uri.toString(), this.findInternal(request)).stream();
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpRequest<?> request) {
        return this.toMatches(request.getPath(), this.findInternal(request)).stream();
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> find(@NonNull HttpMethod httpMethod, @NonNull CharSequence uri, @Nullable HttpRequest<?> context) {
        return this.toMatches(uri.toString(), this.routesByMethod.getOrDefault(httpMethod.name(), EMPTY)).stream();
    }

    @Override
    @NonNull
    public Stream<UriRouteInfo<?, ?>> uriRoutes() {
        return this.routesByMethod.values().stream().flatMap(Arrays::stream);
    }

    @Override
    @NonNull
    public <T, R> List<UriRouteMatch<T, R>> findAllClosest(@NonNull HttpRequest<?> request) {
        List<UriRouteInfo<Object, Object>> routes = this.findInternal(request);
        if (routes.isEmpty()) {
            return Collections.emptyList();
        }
        List<UriRouteMatch<T, R>> uriRoutes = this.toMatches(request.getPath(), routes);
        if (routes.size() == 1) {
            return uriRoutes;
        }
        Collection acceptedProducedTypes = request.accept();
        if (CollectionUtils.isNotEmpty((Collection)acceptedProducedTypes)) {
            MediaType mediaType = (MediaType)acceptedProducedTypes.iterator().next();
            ArrayList<UriRouteMatch<T, R>> mostSpecific = new ArrayList<UriRouteMatch<T, R>>(routes.size());
            for (UriRouteMatch<T, R> routeMatch : uriRoutes) {
                if (!routeMatch.getRouteInfo().explicitlyProduces(mediaType)) continue;
                mostSpecific.add(routeMatch);
            }
            if (!mostSpecific.isEmpty()) {
                uriRoutes = mostSpecific;
            }
        }
        boolean permitsBody = request.getMethod().permitsRequestBody();
        int routeCount = uriRoutes.size();
        if (routeCount > 1 && permitsBody) {
            MediaType contentType = request.getContentType().orElse(MediaType.ALL_TYPE);
            ArrayList<UriRouteMatch<T, R>> explicitlyConsumedRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            ArrayList<UriRouteMatch<T, R>> consumesRoutes = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (UriRouteMatch<T, R> match : uriRoutes) {
                if (match.getRouteInfo().explicitlyConsumes(contentType)) {
                    explicitlyConsumedRoutes.add(match);
                }
                if (!explicitlyConsumedRoutes.isEmpty()) continue;
                consumesRoutes.add(match);
            }
            List<UriRouteMatch<T, R>> list = uriRoutes = explicitlyConsumedRoutes.isEmpty() ? consumesRoutes : explicitlyConsumedRoutes;
        }
        if ((routeCount = uriRoutes.size()) > 1) {
            long variableCount = 0L;
            long rawLength = 0L;
            ArrayList<UriRouteMatch<T, R>> closestMatches = new ArrayList<UriRouteMatch<T, R>>(routeCount);
            for (int i = 0; i < routeCount; ++i) {
                UriRouteMatch<T, R> match = uriRoutes.get(i);
                UriMatchTemplate template = match.getRouteInfo().getUriMatchTemplate();
                long variable = template.getPathVariableSegmentCount();
                long raw = template.getRawSegmentLength();
                if (i == 0) {
                    variableCount = variable;
                    rawLength = raw;
                }
                if (variable > variableCount || raw < rawLength) break;
                closestMatches.add(match);
            }
            uriRoutes = closestMatches;
        }
        return uriRoutes;
    }

    private <T, R> List<UriRouteMatch<T, R>> toMatches(String path, List<UriRouteInfo<Object, Object>> routes) {
        if (routes.size() == 1) {
            UriRouteMatch<Object, Object> match = routes.iterator().next().tryMatch(path);
            if (match != null) {
                return List.of(match);
            }
            return List.of();
        }
        ArrayList<UriRouteMatch<T, R>> uriRoutes = new ArrayList<UriRouteMatch<T, R>>(routes.size());
        for (UriRouteInfo<Object, Object> route : routes) {
            UriRouteMatch<Object, Object> match = route.tryMatch(path);
            if (match == null) continue;
            uriRoutes.add(match);
        }
        return uriRoutes;
    }

    private <T, R> List<UriRouteMatch<T, R>> toMatches(String path, UriRouteInfo<Object, Object>[] routes) {
        if (routes.length == 1) {
            UriRouteMatch<Object, Object> match = routes[0].tryMatch(path);
            if (match != null) {
                return List.of(match);
            }
            return List.of();
        }
        ArrayList<UriRouteMatch<T, R>> uriRoutes = new ArrayList<UriRouteMatch<T, R>>(routes.length);
        for (UriRouteInfo<Object, Object> route : routes) {
            UriRouteMatch<Object, Object> match = route.tryMatch(path);
            if (match == null) continue;
            uriRoutes.add(match);
        }
        return uriRoutes;
    }

    @Override
    @NonNull
    public <T, R> Optional<UriRouteMatch<T, R>> route(@NonNull HttpMethod httpMethod, @NonNull CharSequence uri) {
        for (UriRouteInfo<Object, Object> uriRouteInfo : this.routesByMethod.getOrDefault(httpMethod.name(), EMPTY)) {
            Optional<UriRouteMatch<T, R>> match = uriRouteInfo.match(uri.toString());
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull HttpStatus status) {
        for (StatusRouteInfo<Object, Object> statusRouteInfo : this.statusRoutes) {
            Optional<RouteMatch<R>> match;
            if (statusRouteInfo.originatingType() != null || !(match = statusRouteInfo.match(status)).isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Class<?> originatingClass, @NonNull HttpStatus status) {
        for (StatusRouteInfo<Object, Object> statusRouteInfo : this.statusRoutes) {
            Optional<RouteMatch<R>> match = statusRouteInfo.match(originatingClass, status);
            if (!match.isPresent()) continue;
            return match;
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Class<?> originatingClass, @NonNull Throwable error) {
        ArrayList matchedRoutes = new ArrayList();
        for (ErrorRouteInfo<Object, Object> errorRouteInfo : this.errorRoutes) {
            Optional<RouteMatch<Object>> match = errorRouteInfo.match(originatingClass, error);
            match.ifPresent(m -> matchedRoutes.add((RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Class<?> originatingClass, @NonNull Throwable error, HttpRequest<?> request) {
        return this.findErrorRouteInternal(originatingClass, error, request);
    }

    private <R> Optional<RouteMatch<R>> findErrorRouteInternal(@Nullable Class<?> originatingClass, @NonNull Throwable error, HttpRequest<?> request) {
        Collection accept = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)accept);
        if (hasAcceptHeader) {
            ArrayList matchedRoutes = new ArrayList();
            for (ErrorRouteInfo<Object, Object> errorRoute : this.errorRoutes) {
                RouteMatch match;
                if (!errorRoute.doesProduce(accept) || !errorRoute.matching(request) || (match = (RouteMatch)errorRoute.match(originatingClass, error).orElse(null)) == null) continue;
                matchedRoutes.add(match);
            }
            return this.findRouteMatch(matchedRoutes, error);
        }
        ArrayList producesAllMatchedRoutes = new ArrayList(this.errorRoutes.length);
        ArrayList producesSpecificMatchedRoutes = new ArrayList(this.errorRoutes.length);
        for (ErrorRouteInfo<Object, Object> errorRouteInfo : this.errorRoutes) {
            RouteMatch match;
            if (!errorRouteInfo.matching(request) || (match = (RouteMatch)errorRouteInfo.match(originatingClass, error).orElse(null)) == null) continue;
            List<MediaType> produces = match.getRouteInfo().getProduces();
            if (CollectionUtils.isEmpty(produces) || produces.contains(MediaType.ALL_TYPE)) {
                producesAllMatchedRoutes.add(match);
                continue;
            }
            producesSpecificMatchedRoutes.add(match);
        }
        if (producesAllMatchedRoutes.isEmpty()) {
            return this.findRouteMatch(producesSpecificMatchedRoutes, error);
        }
        return this.findRouteMatch(producesAllMatchedRoutes, error);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findErrorRoute(@NonNull Throwable error, HttpRequest<?> request) {
        return this.findErrorRouteInternal(null, error, request);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull Class<?> originatingClass, @NonNull HttpStatus status, HttpRequest<?> request) {
        return this.findStatusInternal(originatingClass, status, request);
    }

    @Override
    public <R> Optional<RouteMatch<R>> findStatusRoute(@NonNull HttpStatus status, HttpRequest<?> request) {
        return this.findStatusInternal(null, status, request);
    }

    private <R> Optional<RouteMatch<R>> findStatusInternal(@Nullable Class<?> originatingClass, @NonNull HttpStatus status, HttpRequest<?> request) {
        Collection accept = request.accept();
        boolean hasAcceptHeader = CollectionUtils.isNotEmpty((Collection)accept);
        if (hasAcceptHeader) {
            for (StatusRouteInfo<Object, Object> statusRouteInfo : this.statusRoutes) {
                RouteMatch match;
                if (!statusRouteInfo.doesProduce(accept) || !statusRouteInfo.matching(request) || (match = (RouteMatch)statusRouteInfo.match(originatingClass, status).orElse(null)) == null) continue;
                return Optional.of(match);
            }
        } else {
            RouteMatch firstMatch = null;
            for (StatusRouteInfo<Object, Object> statusRouteInfo : this.statusRoutes) {
                RouteMatch match;
                if (!statusRouteInfo.matching(request) || (match = (RouteMatch)statusRouteInfo.match(originatingClass, status).orElse(null)) == null) continue;
                List<MediaType> produces = match.getRouteInfo().getProduces();
                if (CollectionUtils.isEmpty(produces) || produces.contains(MediaType.ALL_TYPE)) {
                    return Optional.of(match);
                }
                if (firstMatch != null) continue;
                firstMatch = match;
            }
            return Optional.ofNullable(firstMatch);
        }
        return Optional.empty();
    }

    @Override
    public <R> Optional<RouteMatch<R>> route(@NonNull Throwable error) {
        ArrayList matchedRoutes = new ArrayList();
        for (ErrorRouteInfo<Object, Object> errorRouteInfo : this.errorRoutes) {
            if (errorRouteInfo.originatingType() != null) continue;
            Optional<RouteMatch<Object>> match = errorRouteInfo.match(error);
            match.ifPresent(m -> matchedRoutes.add((RouteMatch)m));
        }
        return this.findRouteMatch(matchedRoutes, error);
    }

    @Override
    @NonNull
    public List<GenericHttpFilter> findFilters(@NonNull HttpRequest<?> request) {
        if (this.preconditionFilterRoutes.isEmpty()) {
            return this.alwaysMatchesHttpFilters.get();
        }
        ArrayList httpFilters = new ArrayList(this.alwaysMatchesFilterRoutes.size() + this.preconditionFilterRoutes.size());
        httpFilters.addAll(this.alwaysMatchesHttpFilters.get());
        RouteMatch routeMatch = request.getAttribute((CharSequence)HttpAttributes.ROUTE_MATCH).filter(o -> o instanceof RouteMatch).orElse(null);
        HttpMethod method = request.getMethod();
        URI uri = request.getUri();
        for (FilterRoute filterRoute : this.preconditionFilterRoutes) {
            if (routeMatch != null && !this.matchesFilterMatcher(filterRoute, routeMatch)) continue;
            filterRoute.match(method, uri).ifPresent(httpFilters::add);
        }
        FilterRunner.sort(httpFilters);
        return Collections.unmodifiableList(httpFilters);
    }

    @Override
    @NonNull
    public <T, R> Stream<UriRouteMatch<T, R>> findAny(@NonNull CharSequence uri, @Nullable HttpRequest<?> request) {
        ArrayList<UriRouteMatch<Object, Object>> matchedRoutes = new ArrayList<UriRouteMatch<Object, Object>>(5);
        String uriStr = uri.toString();
        for (UriRouteInfo<Object, Object>[] routes : this.routesByMethod.values()) {
            for (UriRouteInfo<Object, Object> route : routes) {
                UriRouteMatch<Object, Object> match;
                if (request != null && (this.shouldSkipForPort(request, route) || !route.matching(request)) || (match = route.tryMatch(uriStr)) == null) continue;
                matchedRoutes.add(match);
            }
        }
        return matchedRoutes.stream();
    }

    @Override
    public <T, R> List<UriRouteMatch<T, R>> findAny(HttpRequest<?> request) {
        String path = request.getPath();
        ArrayList<UriRouteMatch<T, R>> matchedRoutes = new ArrayList<UriRouteMatch<T, R>>(5);
        for (UriRouteInfo<Object, Object>[] routes : this.routesByMethod.values()) {
            for (UriRouteInfo<Object, Object> route : routes) {
                UriRouteMatch<Object, Object> match;
                if (this.shouldSkipForPort(request, route) || !route.matching(request) || (match = route.tryMatch(path)) == null) continue;
                matchedRoutes.add(match);
            }
        }
        return matchedRoutes;
    }

    private List<UriRouteInfo<Object, Object>> findInternal(HttpRequest<?> request) {
        String httpMethodName = request.getMethodName();
        boolean permitsBody = request.getMethod().permitsRequestBody();
        Collection acceptedProducedTypes = request.accept();
        UriRouteInfo<Object, Object>[] routes = this.routesByMethod.getOrDefault(httpMethodName, EMPTY);
        if (routes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<UriRouteInfo<Object, Object>> result = new ArrayList<UriRouteInfo<Object, Object>>(routes.length);
        for (UriRouteInfo<Object, Object> route : routes) {
            if (this.shouldSkipForPort(request, route) || permitsBody && (!route.isPermitsRequestBody() || !route.doesConsume(request.getContentType().orElse(null))) || !route.doesProduce(acceptedProducedTypes) || !route.matching(request)) continue;
            result.add(route);
        }
        return result;
    }

    private boolean shouldSkipForPort(HttpRequest<?> request, UriRouteInfo<Object, Object> route) {
        if (this.ports == null || route.getPort() != null) {
            return false;
        }
        return !this.ports.contains(request.getServerAddress().getPort());
    }

    private UriRouteInfo<Object, Object>[] finalizeRoutes(List<UriRouteInfo<Object, Object>> routes) {
        Collections.sort(routes);
        return routes.toArray(new UriRouteInfo[0]);
    }

    private <T> Optional<RouteMatch<T>> findRouteMatch(List<RouteMatch<T>> matchedRoutes, Throwable error) {
        if (matchedRoutes.size() == 1) {
            return matchedRoutes.stream().findFirst();
        }
        if (matchedRoutes.size() > 1) {
            int minCount = Integer.MAX_VALUE;
            Supplier<List> hierarchySupplier = () -> ClassUtils.resolveHierarchy(error.getClass());
            Optional<RouteMatch<T>> match = Optional.empty();
            Class<?> errorClass = error.getClass();
            for (RouteMatch<T> errorMatch : matchedRoutes) {
                ErrorRouteInfo routeInfo = (ErrorRouteInfo)errorMatch.getRouteInfo();
                Class<Throwable> exceptionType = routeInfo.exceptionType();
                if (exceptionType.equals(errorClass)) {
                    match = Optional.of(errorMatch);
                    break;
                }
                List hierarchy = hierarchySupplier.get();
                int index = hierarchy.indexOf(exceptionType);
                if (index <= -1 || index >= minCount) continue;
                minCount = index;
                match = Optional.of(errorMatch);
            }
            return match;
        }
        return Optional.empty();
    }

    public List<HttpFilterResolver.FilterEntry> resolveFilterEntries(RouteMatch<?> routeMatch) {
        if (this.preconditionFilterRoutes.isEmpty()) {
            return new ArrayList<HttpFilterResolver.FilterEntry>(this.alwaysMatchesFilterRoutes);
        }
        ArrayList<FilterRoute> filterEntries = new ArrayList<FilterRoute>(this.alwaysMatchesFilterRoutes.size() + this.preconditionFilterRoutes.size());
        filterEntries.addAll(this.alwaysMatchesFilterRoutes);
        for (FilterRoute filterRoute : this.preconditionFilterRoutes) {
            if (this.matchesFilterMatcher(filterRoute, routeMatch)) continue;
            filterEntries.add(filterRoute);
        }
        filterEntries.sort(OrderUtil.COMPARATOR);
        return Collections.unmodifiableList(filterEntries);
    }

    public List<GenericHttpFilter> resolveFilters(HttpRequest<?> request, List<HttpFilterResolver.FilterEntry> filterEntries) {
        ArrayList<GenericHttpFilter> httpFilters = new ArrayList<GenericHttpFilter>(filterEntries.size());
        for (HttpFilterResolver.FilterEntry entry : filterEntries) {
            if (entry.hasMethods() && !entry.getFilterMethods().contains(request.getMethod())) continue;
            if (entry.hasPatterns()) {
                String path = request.getPath();
                String[] patterns = entry.getPatterns();
                FilterPatternStyle patternStyle = entry.getAnnotationMetadata().enumValue("patternStyle", FilterPatternStyle.class).orElse(FilterPatternStyle.ANT);
                boolean matches = true;
                for (String pattern : patterns) {
                    if (!matches) break;
                    matches = "/**".equals(pattern) || patternStyle.getPathMatcher().matches(pattern, path);
                }
                if (!matches) continue;
            }
            httpFilters.add(entry.getFilter());
        }
        httpFilters.sort(OrderUtil.COMPARATOR);
        return Collections.unmodifiableList(httpFilters);
    }

    private boolean matchesFilterMatcher(FilterRoute filterRoute, RouteMatch<?> context) {
        String filterAnnotation;
        boolean matches;
        AnnotationMetadata annotationMetadata = filterRoute.getAnnotationMetadata();
        boolean bl = matches = !annotationMetadata.hasStereotype(FilterMatcher.NAME);
        if (!matches && (filterAnnotation = (String)annotationMetadata.getAnnotationNameByStereotype(FilterMatcher.NAME).orElse(null)) != null) {
            matches = context.getRouteInfo().getAnnotationMetadata().hasStereotype(filterAnnotation);
        }
        return matches;
    }

    private static /* synthetic */ boolean lambda$new$3(ErrorRouteInfo routeInfo, ErrorRouteInfo r) {
        return r.equals(routeInfo);
    }

    private static /* synthetic */ boolean lambda$new$2(StatusRouteInfo routeInfo, StatusRouteInfo r) {
        return r.equals(routeInfo);
    }
}

