/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.jackson.modules;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.io.SerializedString;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.CreatorProperty;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.introspect.VirtualAnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.SimpleBeanPropertyDefinition;
import io.micronaut.context.annotation.Requires;
import io.micronaut.core.annotation.AnnotatedElement;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.UnsafeBeanProperty;
import io.micronaut.core.naming.Named;
import io.micronaut.core.reflect.exception.InstantiationException;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.jackson.JacksonConfiguration;
import io.micronaut.jackson.JacksonDeserializationPreInstantiateCallback;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@Singleton
@Requires(property="jackson.bean-introspection-module", notEquals="false")
public class BeanIntrospectionModule
extends SimpleModule {
    private static final Logger LOG = LoggerFactory.getLogger(BeanIntrospectionModule.class);
    boolean ignoreReflectiveProperties = false;
    @Nullable
    private final JacksonDeserializationPreInstantiateCallback preInstantiateCallback;

    public BeanIntrospectionModule() {
        this(null);
    }

    @Inject
    public BeanIntrospectionModule(@Nullable JacksonDeserializationPreInstantiateCallback preInstantiateCallback) {
        this.preInstantiateCallback = preInstantiateCallback;
        this.setDeserializerModifier(new BeanIntrospectionDeserializerModifier());
        this.setSerializerModifier(new BeanIntrospectionSerializerModifier());
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        ObjectCodec owner = context.getOwner();
        if (owner instanceof ObjectMapper) {
            ObjectMapper mapper = (ObjectMapper)owner;
            mapper.setConfig((SerializationConfig)mapper.getSerializationConfig().with((AccessorNamingStrategy.Provider)new BeanIntrospectionAccessorNamingStrategyProvider(mapper.getSerializationConfig().getAccessorNaming())));
            mapper.setConfig((DeserializationConfig)mapper.getDeserializationConfig().with((AccessorNamingStrategy.Provider)new BeanIntrospectionAccessorNamingStrategyProvider(mapper.getDeserializationConfig().getAccessorNaming())));
        }
    }

    @Nullable
    protected BeanIntrospection<Object> findIntrospection(Class<?> beanClass) {
        return BeanIntrospector.SHARED.findIntrospection(beanClass).orElse(null);
    }

    private JavaType newType(Argument<?> argument, TypeFactory typeFactory) {
        return JacksonConfiguration.constructType(argument, typeFactory);
    }

    private PropertyMetadata newPropertyMetadata(Argument<?> argument, AnnotationMetadata annotationMetadata) {
        Boolean required = annotationMetadata.booleanValue(JsonProperty.class, "required").orElse(false);
        int index = annotationMetadata.intValue(JsonProperty.class, "index").orElse(-1);
        return PropertyMetadata.construct((Boolean)required, (String)annotationMetadata.stringValue(JsonPropertyDescription.class).orElse(null), (Integer)(index > -1 ? Integer.valueOf(index) : null), (String)annotationMetadata.stringValue(JsonProperty.class, "defaultValue").orElse(null));
    }

    private static boolean suppressNulls(JsonInclude.Value inclusion) {
        if (inclusion == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion.getValueInclusion();
        return incl != JsonInclude.Include.ALWAYS && incl != JsonInclude.Include.USE_DEFAULTS;
    }

    private static Object suppressableValue(JsonInclude.Value inclusion) {
        if (inclusion == null) {
            return false;
        }
        JsonInclude.Include incl = inclusion.getValueInclusion();
        if (incl == JsonInclude.Include.ALWAYS || incl == JsonInclude.Include.NON_NULL || incl == JsonInclude.Include.USE_DEFAULTS) {
            return null;
        }
        return BeanPropertyWriter.MARKER_FOR_EMPTY;
    }

    private <T> T findSerializerFromAnnotation(io.micronaut.core.beans.BeanProperty<?, ?> beanProperty, Class<? extends Annotation> annotationType) {
        Class using;
        AnnotationValue jsonSerializeAnnotation = beanProperty.getAnnotation(annotationType);
        if (jsonSerializeAnnotation != null && (using = (Class)jsonSerializeAnnotation.classValue("using").orElse(null)) != null) {
            BeanIntrospection<Object> usingIntrospection = this.findIntrospection(using);
            if (usingIntrospection != null) {
                return (T)usingIntrospection.instantiate();
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn("Cannot construct {}, please add the @Introspected annotation to the class declaration", (Object)using.getName());
            }
        }
        return null;
    }

    @NonNull
    private JsonFormat.Value parseJsonFormat(@NonNull AnnotationValue<JsonFormat> formatAnnotation) {
        return new JsonFormat.Value(formatAnnotation.stringValue("pattern").orElse(""), formatAnnotation.enumValue("shape", JsonFormat.Shape.class).orElse(JsonFormat.Shape.ANY), formatAnnotation.stringValue("locale").orElse("##default"), formatAnnotation.stringValue("timezone").orElse("##default"), JsonFormat.Features.construct((JsonFormat.Feature[])((JsonFormat.Feature[])formatAnnotation.enumValues("with", JsonFormat.Feature.class)), (JsonFormat.Feature[])((JsonFormat.Feature[])formatAnnotation.enumValues("without", JsonFormat.Feature.class))), formatAnnotation.enumValue("lenient", OptBoolean.class).orElse(OptBoolean.DEFAULT).asBoolean());
    }

    @Nullable
    private PropertyNamingStrategy findNamingStrategy(MapperConfig<?> mapperConfig, BeanIntrospection<?> introspection) {
        Optional clazz;
        AnnotationValue namingAnnotation = introspection.getAnnotation(JsonNaming.class);
        if (namingAnnotation != null && (clazz = namingAnnotation.classValue()).isPresent()) {
            try {
                Constructor emptyConstructor = ((Class)clazz.get()).getConstructor(new Class[0]);
                return (PropertyNamingStrategy)emptyConstructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException ignored) {
                return mapperConfig.getPropertyNamingStrategy();
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to construct configured PropertyNamingStrategy", e);
            }
        }
        return mapperConfig.getPropertyNamingStrategy();
    }

    private String getName(MapperConfig<?> mapperConfig, @Nullable PropertyNamingStrategy namingStrategy, AnnotatedElement property) {
        String explicitName = property.getAnnotationMetadata().stringValue(JsonProperty.class).orElse("");
        if (!explicitName.equals("")) {
            return explicitName;
        }
        String implicitName = property.getName();
        if (namingStrategy != null) {
            return namingStrategy.nameForGetterMethod(mapperConfig, null, implicitName);
        }
        return implicitName;
    }

    private class BeanIntrospectionDeserializerModifier
    extends BeanDeserializerModifier {
        private BeanIntrospectionDeserializerModifier() {
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, final BeanDescription beanDesc, final BeanDeserializerBuilder builder) {
            if (builder.getValueInstantiator().getDelegateType(config) != null) {
                return builder;
            }
            final Class beanClass = beanDesc.getBeanClass();
            final BeanIntrospection<Object> introspection = BeanIntrospectionModule.this.findIntrospection(beanClass);
            if (introspection == null) {
                return builder;
            }
            final PropertyNamingStrategy propertyNamingStrategy = BeanIntrospectionModule.this.findNamingStrategy((MapperConfig<?>)config, introspection);
            Iterator properties = builder.getProperties();
            if ((BeanIntrospectionModule.this.ignoreReflectiveProperties || !properties.hasNext()) && introspection.getPropertyNames().length > 0) {
                for (io.micronaut.core.beans.BeanProperty beanProperty : introspection.getBeanProperties()) {
                    if (beanProperty.isReadOnly()) continue;
                    builder.addOrReplaceProperty((SettableBeanProperty)new VirtualSetter((TypeResolutionContext)beanDesc.getClassInfo(), config.getTypeFactory(), (UnsafeBeanProperty<Object, Object>)((UnsafeBeanProperty)beanProperty), BeanIntrospectionModule.this.getName((MapperConfig<?>)config, propertyNamingStrategy, (AnnotatedElement)beanProperty), (JsonDeserializer<Object>)((JsonDeserializer)BeanIntrospectionModule.this.findSerializerFromAnnotation(beanProperty, JsonDeserialize.class))), true);
                }
            } else {
                LinkedHashMap<String, io.micronaut.core.beans.BeanProperty> remainingProperties = new LinkedHashMap<String, io.micronaut.core.beans.BeanProperty>();
                for (io.micronaut.core.beans.BeanProperty beanProperty : introspection.getBeanProperties()) {
                    if (beanProperty.isAnnotationPresent(JsonIgnore.class)) continue;
                    remainingProperties.put(BeanIntrospectionModule.this.getName((MapperConfig<?>)config, propertyNamingStrategy, (AnnotatedElement)beanProperty), beanProperty);
                }
                while (properties.hasNext()) {
                    SettableBeanProperty settableBeanProperty = (SettableBeanProperty)properties.next();
                    if (!(settableBeanProperty instanceof MethodProperty)) continue;
                    MethodProperty methodProperty = (MethodProperty)settableBeanProperty;
                    UnsafeBeanProperty beanProperty = (UnsafeBeanProperty)remainingProperties.remove(settableBeanProperty.getName());
                    if (beanProperty == null || beanProperty.isReadOnly()) continue;
                    BeanIntrospectionSetter newProperty = new BeanIntrospectionSetter((SettableBeanProperty)methodProperty, (UnsafeBeanProperty<Object, Object>)beanProperty);
                    builder.addOrReplaceProperty((SettableBeanProperty)newProperty, true);
                }
                for (Map.Entry entry : remainingProperties.entrySet()) {
                    SettableBeanProperty existing;
                    if (((io.micronaut.core.beans.BeanProperty)entry.getValue()).isReadOnly() || (existing = builder.findProperty(PropertyName.construct((String)((String)entry.getKey())))) != null) continue;
                    builder.addOrReplaceProperty((SettableBeanProperty)new VirtualSetter((TypeResolutionContext)beanDesc.getClassInfo(), config.getTypeFactory(), (UnsafeBeanProperty<Object, Object>)((UnsafeBeanProperty)entry.getValue()), (String)entry.getKey(), (JsonDeserializer<Object>)((JsonDeserializer)BeanIntrospectionModule.this.findSerializerFromAnnotation((io.micronaut.core.beans.BeanProperty)entry.getValue(), JsonDeserialize.class))), true);
                }
            }
            final Argument[] constructorArguments = introspection.getConstructorArguments();
            final TypeFactory typeFactory = config.getTypeFactory();
            final ValueInstantiator valueInstantiator = builder.getValueInstantiator();
            builder.setValueInstantiator((ValueInstantiator)new StdValueInstantiator(config, typeFactory.constructType((Type)beanClass)){
                SettableBeanProperty[] props;

                public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
                    SettableBeanProperty[] existing;
                    SettableBeanProperty[] settableBeanPropertyArray = existing = BeanIntrospectionModule.this.ignoreReflectiveProperties ? null : valueInstantiator.getFromObjectArguments(config);
                    if (this.props == null) {
                        this.props = new SettableBeanProperty[constructorArguments.length];
                        for (int i = 0; i < constructorArguments.length; ++i) {
                            SettableBeanProperty settableBeanProperty;
                            TypeDeserializer typeDeserializer;
                            final Argument argument = constructorArguments[i];
                            SettableBeanProperty existingProperty = existing != null && existing.length > i ? existing[i] : null;
                            final JavaType javaType = existingProperty != null ? existingProperty.getType() : BeanIntrospectionModule.this.newType(argument, typeFactory);
                            final AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
                            PropertyMetadata propertyMetadata = BeanIntrospectionModule.this.newPropertyMetadata(argument, annotationMetadata);
                            String simpleName = existingProperty != null ? existingProperty.getName() : BeanIntrospectionModule.this.getName((MapperConfig<?>)config, propertyNamingStrategy, (AnnotatedElement)argument);
                            try {
                                typeDeserializer = config.findTypeDeserializer(javaType);
                            }
                            catch (JsonMappingException e) {
                                typeDeserializer = null;
                            }
                            PropertyName propertyName = PropertyName.construct((String)simpleName);
                            if (typeDeserializer == null && (settableBeanProperty = builder.findProperty(propertyName)) != null) {
                                typeDeserializer = settableBeanProperty.getValueTypeDeserializer();
                            }
                            this.props[i] = new CreatorProperty(propertyName, javaType, null, typeDeserializer, null, null, i, null, propertyMetadata){
                                private final UnsafeBeanProperty<Object, Object> property;
                                {
                                    super(name, type, wrapperName, typeDeser, contextAnnotations, param, index, injectable, metadata);
                                    this.property = introspection.getProperty(argument.getName()).orElse(null);
                                }

                                public <A extends Annotation> A getAnnotation(Class<A> acls) {
                                    return (A)annotationMetadata.synthesize(acls);
                                }

                                public AnnotatedMember getMember() {
                                    return new IntrospectionVirtualAnnotatedMember((TypeResolutionContext)beanDesc.getClassInfo(), beanClass, argument.getName(), javaType, annotationMetadata);
                                }

                                public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
                                    if (this.property != null) {
                                        this.property.setUnsafe(instance, this.deserialize(p, ctxt));
                                    }
                                }

                                public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
                                    if (this.property != null) {
                                        this.property.setUnsafe(instance, this.deserialize(p, ctxt));
                                    }
                                    return null;
                                }

                                public void set(Object instance, Object value) {
                                    if (this.property != null) {
                                        this.property.setUnsafe(instance, value);
                                    }
                                }

                                public Object setAndReturn(Object instance, Object value) {
                                    if (this.property != null) {
                                        this.property.setUnsafe(instance, value);
                                    }
                                    return null;
                                }

                                public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
                                    AnnotationValue formatAnnotation;
                                    JsonFormat.Value v1 = config.getDefaultPropertyFormat(baseType);
                                    JsonFormat.Value v2 = null;
                                    if (this.property != null && (formatAnnotation = this.property.getAnnotation(JsonFormat.class)) != null) {
                                        v2 = BeanIntrospectionModule.this.parseJsonFormat((AnnotationValue<JsonFormat>)formatAnnotation);
                                    }
                                    if (v1 == null) {
                                        return v2 == null ? EMPTY_FORMAT : v2;
                                    }
                                    return v2 == null ? v1 : v1.withOverrides(v2);
                                }
                            };
                        }
                    }
                    return this.props;
                }

                public boolean canInstantiate() {
                    return true;
                }

                public boolean canCreateUsingDefault() {
                    return constructorArguments.length == 0;
                }

                public boolean canCreateFromObjectWith() {
                    return constructorArguments.length > 0;
                }

                public boolean canCreateUsingArrayDelegate() {
                    return valueInstantiator.canCreateUsingArrayDelegate();
                }

                public boolean canCreateUsingDelegate() {
                    return false;
                }

                public JavaType getArrayDelegateType(DeserializationConfig config) {
                    return BeanIntrospectionModule.this.newType(constructorArguments[0], typeFactory);
                }

                public JavaType getDelegateType(DeserializationConfig config) {
                    return BeanIntrospectionModule.this.newType(constructorArguments[0], typeFactory);
                }

                public boolean canCreateFromString() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.STRING);
                }

                public boolean canCreateFromInt() {
                    return constructorArguments.length == 1 && (constructorArguments[0].equalsType(Argument.INT) || constructorArguments[0].equalsType(Argument.LONG));
                }

                public boolean canCreateFromLong() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.LONG);
                }

                public boolean canCreateFromDouble() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.DOUBLE);
                }

                public boolean canCreateFromBoolean() {
                    return constructorArguments.length == 1 && constructorArguments[0].equalsType(Argument.BOOLEAN);
                }

                public Object createUsingDefault(DeserializationContext ctxt) {
                    return introspection.instantiate();
                }

                public Object createUsingDelegate(DeserializationContext ctxt, Object delegate) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, delegate);
                    }
                    return introspection.instantiate(false, new Object[]{delegate});
                }

                public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, args);
                    }
                    return introspection.instantiate(false, args);
                }

                public Object createUsingArrayDelegate(DeserializationContext ctxt, Object delegate) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, delegate);
                    }
                    return introspection.instantiate(false, new Object[]{delegate});
                }

                public Object createFromString(DeserializationContext ctxt, String value) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, value);
                    }
                    return introspection.instantiate(false, new Object[]{value});
                }

                public Object createFromInt(DeserializationContext ctxt, int value) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, value);
                    }
                    try {
                        return introspection.instantiate(false, new Object[]{value});
                    }
                    catch (InstantiationException e) {
                        InstantiationException originalException = e;
                        try {
                            return introspection.instantiate(false, new Object[]{(long)value});
                        }
                        catch (InstantiationException e2) {
                            throw originalException;
                        }
                    }
                }

                public Object createFromLong(DeserializationContext ctxt, long value) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, value);
                    }
                    return introspection.instantiate(false, new Object[]{value});
                }

                public Object createFromDouble(DeserializationContext ctxt, double value) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, value);
                    }
                    return introspection.instantiate(false, new Object[]{value});
                }

                public Object createFromBoolean(DeserializationContext ctxt, boolean value) {
                    if (BeanIntrospectionModule.this.preInstantiateCallback != null) {
                        BeanIntrospectionModule.this.preInstantiateCallback.preInstantiate(introspection, value);
                    }
                    return introspection.instantiate(false, new Object[]{value});
                }
            });
            return builder;
        }
    }

    private class BeanIntrospectionSerializerModifier
    extends BeanSerializerModifier {
        private BeanIntrospectionSerializerModifier() {
        }

        public BeanSerializerBuilder updateBuilder(final SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
            final Class beanClass = beanDesc.getBeanClass();
            BeanIntrospection<Object> introspection = BeanIntrospectionModule.this.findIntrospection(beanClass);
            if (introspection == null) {
                return super.updateBuilder(config, beanDesc, builder);
            }
            PropertyNamingStrategy namingStrategy = BeanIntrospectionModule.this.findNamingStrategy((MapperConfig<?>)config, introspection);
            BeanSerializerBuilder newBuilder = new BeanSerializerBuilder(beanDesc){

                public JsonSerializer<?> build() {
                    this.setConfig(config);
                    try {
                        return super.build();
                    }
                    catch (RuntimeException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error("Error building bean serializer for type [" + beanClass + "]: " + e.getMessage(), (Throwable)e);
                        }
                        throw e;
                    }
                }
            };
            newBuilder.setAnyGetter(builder.getAnyGetter());
            List properties = builder.getProperties();
            Collection beanProperties = introspection.getBeanProperties();
            if (BeanIntrospectionModule.this.ignoreReflectiveProperties || CollectionUtils.isEmpty((Collection)properties) && CollectionUtils.isNotEmpty((Collection)beanProperties)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Bean {} has no properties, while BeanIntrospection does. Recreating from introspection.", (Object)beanClass);
                }
                TypeResolutionContext.Empty typeResolutionContext = new TypeResolutionContext.Empty(config.getTypeFactory());
                ArrayList<BeanIntrospectionPropertyWriter> newProperties = new ArrayList<BeanIntrospectionPropertyWriter>(beanProperties.size());
                for (io.micronaut.core.beans.BeanProperty bp : beanProperties) {
                    if (bp.hasAnnotation(JsonIgnore.class) || bp.hasAnnotation(JsonValue.class)) continue;
                    final UnsafeBeanProperty beanProperty = (UnsafeBeanProperty)bp;
                    String propertyName = BeanIntrospectionModule.this.getName((MapperConfig<?>)config, namingStrategy, (AnnotatedElement)beanProperty);
                    JsonSerializer serializerFromAnnotation = (JsonSerializer)BeanIntrospectionModule.this.findSerializerFromAnnotation((io.micronaut.core.beans.BeanProperty<?, ?>)beanProperty, (Class<? extends Annotation>)JsonSerialize.class);
                    if (bp.hasAnnotation(JsonAnyGetter.class)) {
                        IntrospectionVirtualAnnotatedMember virtualMember = new IntrospectionVirtualAnnotatedMember((TypeResolutionContext)typeResolutionContext, beanProperty.getDeclaringType(), propertyName, BeanIntrospectionModule.this.newType(beanProperty.asArgument(), config.getTypeFactory()), (AnnotationMetadata)beanProperty){

                            public Object getValue(Object pojo) throws IllegalArgumentException {
                                return beanProperty.get(pojo);
                            }
                        };
                        JavaType anyType = BeanIntrospectionModule.this.newType(beanProperty.asArgument(), config.getTypeFactory());
                        if (serializerFromAnnotation == null) {
                            serializerFromAnnotation = MapSerializer.construct((Set)null, (JavaType)anyType, (boolean)config.isEnabled(MapperFeature.USE_STATIC_TYPING), null, null, null, null);
                        }
                        newBuilder.setAnyGetter(new AnyGetterWriter((BeanProperty)new BeanProperty.Std(new PropertyName(bp.getName()), anyType.getContentType(), null, (AnnotatedMember)virtualMember, PropertyMetadata.STD_OPTIONAL), (AnnotatedMember)virtualMember, serializerFromAnnotation));
                        continue;
                    }
                    BeanIntrospectionPropertyWriter writer = new BeanIntrospectionPropertyWriter((AnnotatedMember)new IntrospectionVirtualAnnotatedMember((TypeResolutionContext)typeResolutionContext, beanProperty.getDeclaringType(), propertyName, BeanIntrospectionModule.this.newType(beanProperty.asArgument(), config.getTypeFactory()), (AnnotationMetadata)beanProperty), config, propertyName, (UnsafeBeanProperty<Object, Object>)beanProperty, config.getTypeFactory(), serializerFromAnnotation);
                    newProperties.add(writer);
                }
                newBuilder.setProperties(newProperties);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updating {} properties with BeanIntrospection data for type: {}", (Object)properties.size(), (Object)beanClass);
                }
                ArrayList<BeanPropertyWriter> newProperties = new ArrayList<BeanPropertyWriter>(properties);
                LinkedHashMap<String, io.micronaut.core.beans.BeanProperty> named = new LinkedHashMap<String, io.micronaut.core.beans.BeanProperty>();
                for (io.micronaut.core.beans.BeanProperty beanProperty : beanProperties) {
                    if (beanProperty.isWriteOnly()) continue;
                    named.put(BeanIntrospectionModule.this.getName((MapperConfig<?>)config, namingStrategy, (AnnotatedElement)beanProperty), beanProperty);
                }
                for (int i = 0; i < properties.size(); ++i) {
                    BeanPropertyWriter existing = (BeanPropertyWriter)properties.get(i);
                    Optional<io.micronaut.core.beans.BeanProperty> property = Optional.ofNullable((io.micronaut.core.beans.BeanProperty)named.get(existing.getName()));
                    if (property.isPresent() && !property.get().isAnnotationPresent(JsonIgnore.class) && !existing.getClass().getName().equals("com.fasterxml.jackson.dataformat.xml.ser.XmlBeanPropertyWriter")) {
                        UnsafeBeanProperty beanProperty = (UnsafeBeanProperty)property.get();
                        newProperties.set(i, new BeanIntrospectionPropertyWriter(existing, (UnsafeBeanProperty<Object, Object>)beanProperty, (JsonSerializer<Object>)existing.getSerializer(), config.getTypeFactory(), existing.getViews()));
                        continue;
                    }
                    newProperties.set(i, existing);
                }
                newBuilder.setProperties(newProperties);
            }
            newBuilder.setFilteredProperties(builder.getFilteredProperties());
            return newBuilder;
        }
    }

    private class BeanIntrospectionAccessorNamingStrategyProvider
    extends AccessorNamingStrategy.Provider {
        private final AccessorNamingStrategy.Provider delegate;

        BeanIntrospectionAccessorNamingStrategyProvider(AccessorNamingStrategy.Provider delegate) {
            this.delegate = delegate;
        }

        public AccessorNamingStrategy forPOJO(MapperConfig<?> config, AnnotatedClass valueClass) {
            return this.delegate.forPOJO(config, valueClass);
        }

        public AccessorNamingStrategy forBuilder(MapperConfig<?> config, AnnotatedClass builderClass, BeanDescription valueTypeDesc) {
            return this.delegate.forBuilder(config, builderClass, valueTypeDesc);
        }

        public AccessorNamingStrategy forRecord(MapperConfig<?> config, AnnotatedClass recordClass) {
            final BeanIntrospection<Object> introspection = BeanIntrospectionModule.this.findIntrospection(recordClass.getRawType());
            if (introspection != null) {
                return new DefaultAccessorNamingStrategy(config, recordClass, null, "get", "is", null){
                    final Set<String> names;
                    {
                        super(config, forClass, mutatorPrefix, getterPrefix, isGetterPrefix, baseNameValidator);
                        this.names = introspection.getBeanProperties().stream().map(Named::getName).collect(Collectors.toSet());
                    }

                    public String findNameForRegularGetter(AnnotatedMethod am, String name) {
                        if (this.names.contains(name)) {
                            return name;
                        }
                        return super.findNameForRegularGetter(am, name);
                    }
                };
            }
            try {
                return this.delegate.forRecord(config, recordClass);
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().startsWith("Failed to access RecordComponents of type")) {
                    throw new RuntimeException("Failed to construct AccessorNamingStrategy for record. This can happen when running in native-image. Either make this type @Introspected, or mark it for @ReflectiveAccess.", e);
                }
                throw e;
            }
        }
    }

    private static class BeanIntrospectionSetter
    extends SettableBeanProperty.Delegating {
        final UnsafeBeanProperty<Object, Object> beanProperty;

        BeanIntrospectionSetter(SettableBeanProperty methodProperty, UnsafeBeanProperty<Object, Object> beanProperty) {
            super(methodProperty);
            this.beanProperty = beanProperty;
        }

        protected SettableBeanProperty withDelegate(SettableBeanProperty d) {
            return new BeanIntrospectionSetter(d, this.beanProperty);
        }

        public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.setUnsafe(instance, this.deserialize(p, ctxt));
        }

        public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.setUnsafe(instance, this.deserialize(p, ctxt));
            return null;
        }

        public void set(Object instance, Object value) {
            this.beanProperty.setUnsafe(instance, value);
        }

        public Object setAndReturn(Object instance, Object value) {
            this.beanProperty.setUnsafe(instance, value);
            return null;
        }
    }

    private class BeanIntrospectionPropertyWriter
    extends BeanPropertyWriter {
        protected final Class<?>[] _views;
        final UnsafeBeanProperty<Object, Object> beanProperty;
        final SerializableString fastName;
        private final JavaType type;
        private final boolean unwrapping;

        BeanIntrospectionPropertyWriter(BeanPropertyWriter src, UnsafeBeanProperty<Object, Object> beanProperty, JsonSerializer<Object> ser, TypeFactory typeFactory, Class<?>[] views) {
            this(src.getSerializedName(), src, beanProperty, ser, typeFactory, views);
        }

        BeanIntrospectionPropertyWriter(SerializableString name, BeanPropertyWriter src, UnsafeBeanProperty<Object, Object> beanProperty, JsonSerializer<Object> ser, TypeFactory typeFactory, Class<?>[] views) {
            super(src);
            this._serializer = ser != null ? ser : src.getSerializer();
            this.beanProperty = beanProperty;
            this.fastName = name;
            this._views = views;
            this.type = JacksonConfiguration.constructType(this.beanProperty.asArgument(), typeFactory);
            this._dynamicSerializers = ser == null ? PropertySerializerMap.emptyForProperties() : null;
            this.unwrapping = beanProperty.hasAnnotation(JsonUnwrapped.class);
        }

        BeanIntrospectionPropertyWriter(AnnotatedMember virtualMember, SerializationConfig config, String name, UnsafeBeanProperty<Object, Object> beanProperty, TypeFactory typeFactory, JsonSerializer<?> ser) {
            super((BeanPropertyDefinition)SimpleBeanPropertyDefinition.construct((MapperConfig)config, (AnnotatedMember)virtualMember), virtualMember, AnnotationCollector.emptyAnnotations(), null, ser, null, null, BeanIntrospectionModule.suppressNulls(config.getDefaultPropertyInclusion()), BeanIntrospectionModule.suppressableValue(config.getDefaultPropertyInclusion()), null);
            this.beanProperty = beanProperty;
            this.fastName = new SerializedString(name);
            this._views = null;
            this.type = JacksonConfiguration.constructType(this.beanProperty.asArgument(), typeFactory);
            this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
            this.unwrapping = beanProperty.hasAnnotation(JsonUnwrapped.class);
        }

        public boolean isUnwrapping() {
            return this.unwrapping;
        }

        public String getName() {
            return this.fastName.getValue();
        }

        public PropertyName getFullName() {
            return new PropertyName(this.getName());
        }

        public void fixAccess(SerializationConfig config) {
        }

        public JavaType getType() {
            return this.type;
        }

        private boolean inView(Class<?> activeView) {
            if (activeView == null || this._views == null) {
                return true;
            }
            int len = this._views.length;
            for (int i = 0; i < len; ++i) {
                if (!this._views[i].isAssignableFrom(activeView)) continue;
                return true;
            }
            return false;
        }

        public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            Class<?> cls;
            PropertySerializerMap map;
            if (!this.inView(prov.getActiveView())) {
                this.serializeAsOmittedField(bean, gen, prov);
                return;
            }
            Object value = this.beanProperty.get(bean);
            if (value == null) {
                boolean willSuppressNulls = this.willSuppressNulls();
                if (!willSuppressNulls && this._nullSerializer != null) {
                    if (!this.isUnwrapping()) {
                        gen.writeFieldName(this.fastName);
                        this._nullSerializer.serialize(null, gen, prov);
                    }
                } else if (!willSuppressNulls) {
                    gen.writeFieldName(this.fastName);
                    prov.defaultSerializeNull(gen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(prov, value) : this._suppressableValue.equals(value))) {
                return;
            }
            if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
                return;
            }
            if (this.isUnwrapping()) {
                JsonSerializer unwrappingSerializer = ser.unwrappingSerializer(null);
                unwrappingSerializer.serialize(value, gen, prov);
            } else {
                gen.writeFieldName(this.fastName);
                if (this._typeSerializer == null) {
                    ser.serialize(value, gen, prov);
                } else {
                    ser.serializeWithType(value, gen, prov, this._typeSerializer);
                }
            }
        }

        public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
            Class<?> cls;
            PropertySerializerMap map;
            if (!this.inView(prov.getActiveView())) {
                this.serializeAsOmittedField(bean, gen, prov);
                return;
            }
            Object value = this.beanProperty.get(bean);
            if (value == null) {
                boolean willSuppressNulls = this.willSuppressNulls();
                if (!willSuppressNulls && this._nullSerializer != null) {
                    this._nullSerializer.serialize(null, gen, prov);
                } else if (willSuppressNulls) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                } else {
                    prov.defaultSerializeNull(gen);
                }
                return;
            }
            JsonSerializer ser = this._serializer;
            if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
                ser = this._findAndAddDynamic(map, cls, prov);
            }
            if (this._suppressableValue != null) {
                if (MARKER_FOR_EMPTY == this._suppressableValue) {
                    if (ser.isEmpty(prov, value)) {
                        this.serializeAsPlaceholder(bean, gen, prov);
                        return;
                    }
                } else if (this._suppressableValue.equals(value)) {
                    this.serializeAsPlaceholder(bean, gen, prov);
                    return;
                }
            }
            if (value == bean && this._handleSelfReference(bean, gen, prov, ser)) {
                return;
            }
            if (this._typeSerializer == null) {
                ser.serialize(value, gen, prov);
            } else {
                ser.serializeWithType(value, gen, prov, this._typeSerializer);
            }
        }

        public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
            JsonFormat.Value v1 = config.getDefaultPropertyFormat(baseType);
            JsonFormat.Value v2 = null;
            AnnotationValue formatAnnotation = this.beanProperty.getAnnotation(JsonFormat.class);
            if (formatAnnotation != null) {
                v2 = BeanIntrospectionModule.this.parseJsonFormat((AnnotationValue<JsonFormat>)formatAnnotation);
            }
            if (v1 == null) {
                return v2 == null ? EMPTY_FORMAT : v2;
            }
            return v2 == null ? v1 : v1.withOverrides(v2);
        }
    }

    private class VirtualSetter
    extends SettableBeanProperty {
        final UnsafeBeanProperty<Object, Object> beanProperty;
        final TypeResolutionContext typeResolutionContext;

        VirtualSetter(TypeResolutionContext typeResolutionContext, TypeFactory typeFactory, UnsafeBeanProperty<Object, Object> beanProperty, String propertyName, JsonDeserializer<Object> valueDeser) {
            super(new PropertyName(propertyName), BeanIntrospectionModule.this.newType(beanProperty.asArgument(), typeFactory), BeanIntrospectionModule.this.newPropertyMetadata(beanProperty.asArgument(), beanProperty.getAnnotationMetadata()), valueDeser);
            this.beanProperty = beanProperty;
            this.typeResolutionContext = typeResolutionContext;
        }

        VirtualSetter(PropertyName propertyName, VirtualSetter src) {
            super(propertyName, src._type, src._metadata, src._valueDeserializer);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        VirtualSetter(NullValueProvider nullValueProvider, VirtualSetter src) {
            super((SettableBeanProperty)src, src._valueDeserializer, nullValueProvider);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        VirtualSetter(JsonDeserializer<Object> deser, VirtualSetter src) {
            super(src._propName, src._type, src._metadata, deser);
            this.beanProperty = src.beanProperty;
            this.typeResolutionContext = src.typeResolutionContext;
        }

        public SettableBeanProperty withValueDeserializer(JsonDeserializer<?> deser) {
            return new VirtualSetter(deser, this);
        }

        public SettableBeanProperty withName(PropertyName newName) {
            return new VirtualSetter(newName, this);
        }

        public SettableBeanProperty withNullProvider(NullValueProvider nva) {
            return new VirtualSetter(nva, this);
        }

        public AnnotatedMember getMember() {
            return new IntrospectionVirtualAnnotatedMember(this.typeResolutionContext, this.beanProperty.getDeclaringType(), this._propName.getSimpleName(), this._type, (AnnotationMetadata)this.beanProperty);
        }

        public <A extends Annotation> A getAnnotation(Class<A> acls) {
            return (A)this.beanProperty.getAnnotationMetadata().synthesize(acls);
        }

        public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.setUnsafe(instance, this.deserialize(p, ctxt));
        }

        public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
            this.beanProperty.setUnsafe(instance, this.deserialize(p, ctxt));
            return null;
        }

        public void set(Object instance, Object value) {
            this.beanProperty.setUnsafe(instance, value);
        }

        public Object setAndReturn(Object instance, Object value) {
            this.beanProperty.setUnsafe(instance, value);
            return null;
        }

        public JsonFormat.Value findPropertyFormat(MapperConfig<?> config, Class<?> baseType) {
            JsonFormat.Value v1 = config.getDefaultPropertyFormat(baseType);
            JsonFormat.Value v2 = null;
            AnnotationValue formatAnnotation = this.beanProperty.getAnnotation(JsonFormat.class);
            if (formatAnnotation != null) {
                v2 = BeanIntrospectionModule.this.parseJsonFormat((AnnotationValue<JsonFormat>)formatAnnotation);
            }
            if (v1 == null) {
                return v2 == null ? EMPTY_FORMAT : v2;
            }
            return v2 == null ? v1 : v1.withOverrides(v2);
        }
    }

    private static class IntrospectionVirtualAnnotatedMember
    extends VirtualAnnotatedMember {
        private final AnnotationMetadata annotationMetadata;

        public IntrospectionVirtualAnnotatedMember(TypeResolutionContext typeResolutionContext, Class<?> beanClass, String name, JavaType javaType, AnnotationMetadata annotationMetadata) {
            super(typeResolutionContext, beanClass, name, javaType);
            this.annotationMetadata = annotationMetadata;
        }

        public boolean hasOneOf(Class<? extends Annotation>[] annoClasses) {
            return Arrays.stream(annoClasses).anyMatch(arg_0 -> ((AnnotationMetadata)this.annotationMetadata).hasAnnotation(arg_0));
        }
    }
}

