/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.annotation.processing;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.order.Ordered;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.inject.visitor.TypeElementVisitor;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;

@Internal
final class LoadedVisitor
implements Ordered {
    private static final String OBJECT_CLASS = Object.class.getName();
    private final TypeElementVisitor visitor;
    private final String classAnnotation;
    private final String elementAnnotation;

    public LoadedVisitor(TypeElementVisitor visitor, ProcessingEnvironment processingEnvironment) {
        this.visitor = visitor;
        Class<?> aClass = visitor.getClass();
        TypeElement typeElement = processingEnvironment.getElementUtils().getTypeElement(aClass.getName());
        if (typeElement != null) {
            List<? extends TypeMirror> generics = this.interfaceGenericTypesFor(typeElement, TypeElementVisitor.class.getName());
            if (generics.size() == 2) {
                String typeName = generics.get(0).toString();
                this.classAnnotation = typeName.equals(OBJECT_CLASS) ? visitor.getClassType() : typeName;
                String elementName = generics.get(1).toString();
                this.elementAnnotation = elementName.equals(OBJECT_CLASS) ? visitor.getElementType() : elementName;
            } else {
                Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(aClass, TypeElementVisitor.class);
                if (classes != null && classes.length == 2) {
                    Class classGeneric = classes[0];
                    this.classAnnotation = classGeneric == Object.class ? visitor.getClassType() : classGeneric.getName();
                    Class elementGeneric = classes[1];
                    this.elementAnnotation = elementGeneric == Object.class ? visitor.getElementType() : elementGeneric.getName();
                } else {
                    this.classAnnotation = Object.class.getName();
                    this.elementAnnotation = Object.class.getName();
                }
            }
        } else {
            Class[] classes = GenericTypeUtils.resolveInterfaceTypeArguments(aClass, TypeElementVisitor.class);
            if (classes != null && classes.length == 2) {
                Class classGeneric = classes[0];
                this.classAnnotation = classGeneric == Object.class ? visitor.getClassType() : classGeneric.getName();
                Class elementGeneric = classes[1];
                this.elementAnnotation = elementGeneric == Object.class ? visitor.getElementType() : elementGeneric.getName();
            } else {
                this.classAnnotation = Object.class.getName();
                this.elementAnnotation = Object.class.getName();
            }
        }
    }

    private List<? extends TypeMirror> interfaceGenericTypesFor(TypeElement element, String interfaceName) {
        for (TypeMirror typeMirror : element.getInterfaces()) {
            TypeElement te;
            DeclaredType declaredType = (DeclaredType)typeMirror;
            Element declaredElement = declaredType.asElement();
            if (!(declaredElement instanceof TypeElement) || !interfaceName.equals((te = (TypeElement)declaredElement).getQualifiedName().toString())) continue;
            return declaredType.getTypeArguments();
        }
        return Collections.emptyList();
    }

    public int getOrder() {
        return this.visitor.getOrder();
    }

    public TypeElementVisitor getVisitor() {
        return this.visitor;
    }

    public boolean matchesClass(AnnotationMetadata annotationMetadata) {
        if (this.classAnnotation.equals("java.lang.Object")) {
            return true;
        }
        return annotationMetadata.hasStereotype(this.classAnnotation);
    }

    public boolean matchesElement(AnnotationMetadata annotationMetadata) {
        if (this.elementAnnotation.equals("java.lang.Object")) {
            return true;
        }
        return annotationMetadata.hasStereotype(this.elementAnnotation);
    }

    public String toString() {
        return this.visitor.toString();
    }
}

