/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.body;

import io.micronaut.core.annotation.Indexed;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.io.buffer.ReferenceCounted;
import io.micronaut.core.type.Argument;
import io.micronaut.core.type.Headers;
import io.micronaut.http.MediaType;
import io.micronaut.http.codec.CodecException;
import java.io.IOException;
import java.io.InputStream;

@Indexed(value=MessageBodyReader.class)
public interface MessageBodyReader<T> {
    default public boolean isReadable(@NonNull Argument<T> type, @Nullable MediaType mediaType) {
        return true;
    }

    @Nullable
    default public T read(@NonNull Argument<T> type, @Nullable MediaType mediaType, @NonNull Headers httpHeaders, @NonNull ByteBuffer<?> byteBuffer) throws CodecException {
        T read;
        try (InputStream inputStream = byteBuffer.toInputStream();){
            read = this.read(type, mediaType, httpHeaders, inputStream);
        }
        catch (IOException e) {
            throw new CodecException("Error reading message body: " + e.getMessage(), e);
        }
        if (byteBuffer instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)byteBuffer;
            rc.release();
        }
        return read;
    }

    @Nullable
    public T read(@NonNull Argument<T> var1, @Nullable MediaType var2, @NonNull Headers var3, @NonNull InputStream var4) throws CodecException;
}

