/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.bind.annotation;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.bind.ArgumentBinder;
import io.micronaut.core.bind.annotation.Bindable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionError;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.value.ConvertibleValues;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.StringUtils;
import java.util.List;
import java.util.Optional;

public abstract class AbstractArgumentBinder<T> {
    private static final String DEFAULT_VALUE_MEMBER = "defaultValue";
    protected final ConversionService conversionService;

    protected AbstractArgumentBinder(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String annotationValue) {
        return this.doBind(context, values, annotationValue, ArgumentBinder.BindingResult.empty());
    }

    protected ArgumentBinder.BindingResult<T> doBind(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String name, ArgumentBinder.BindingResult<T> defaultResult) {
        return this.doConvert(this.doResolve(context, values, name), context, defaultResult);
    }

    @Nullable
    protected Object doResolve(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String name) {
        String fallbackName;
        Object value = this.resolveValue(context, values, name);
        if (value == null && !name.equals(fallbackName = this.getFallbackFormat(context.getArgument()))) {
            name = fallbackName;
            value = this.resolveValue(context, values, name);
        }
        return value;
    }

    protected String getFallbackFormat(Argument<?> argument) {
        return NameUtils.hyphenate(argument.getName());
    }

    private Object resolveValue(ArgumentConversionContext<T> context, ConvertibleValues<?> values, String annotationValue) {
        Argument<T> argument = context.getArgument();
        if (StringUtils.isEmpty(annotationValue)) {
            annotationValue = argument.getName();
        }
        return values.get(annotationValue, context).orElseGet(() -> this.conversionService.convert(argument.getAnnotationMetadata().stringValue(Bindable.class, DEFAULT_VALUE_MEMBER).orElse(null), context).orElse(null));
    }

    protected ArgumentBinder.BindingResult<T> doConvert(Object value, ArgumentConversionContext<T> context) {
        return this.doConvert(value, context, ArgumentBinder.BindingResult.empty());
    }

    protected ArgumentBinder.BindingResult<T> doConvert(Object value, ArgumentConversionContext<T> context, ArgumentBinder.BindingResult<T> defaultResult) {
        if (value == null) {
            final Optional<ConversionError> lastError = context.getLastError();
            if (lastError.isPresent()) {
                return new ArgumentBinder.BindingResult<T>(){

                    @Override
                    public Optional<T> getValue() {
                        return Optional.empty();
                    }

                    @Override
                    public List<ConversionError> getConversionErrors() {
                        return lastError.map(List::of).orElseGet(List::of);
                    }
                };
            }
            return defaultResult;
        }
        Optional result = this.conversionService.convert(value, context);
        final Optional<ConversionError> lastError = context.getLastError();
        if (result.isPresent() && context.getArgument().getType() == Optional.class) {
            result = (Optional)result.get();
        }
        final Optional finalResult = result;
        return new ArgumentBinder.BindingResult<T>(){

            @Override
            public Optional<T> getValue() {
                return finalResult;
            }

            @Override
            public List<ConversionError> getConversionErrors() {
                return lastError.map(List::of).orElseGet(List::of);
            }
        };
    }
}

